/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class UniqueNameBuilder<T> {
    private static final String VFS_SEPARATOR = "/";
    private final Map<T, String> myPaths = new THashMap<T, String>();
    private final String mySeparator;
    private final int myMaxLength;
    private final String myRoot;
    private final Node myRootNode = new Node("", null);

    public UniqueNameBuilder(String root2, String separator, int maxLength) {
        this.myRoot = root2;
        this.mySeparator = separator;
        this.myMaxLength = maxLength;
    }

    public boolean contains(T file2) {
        return this.myPaths.containsKey(file2);
    }

    public void addPath(T key, String path2) {
        path2 = StringUtil.trimStart(path2, this.myRoot);
        this.myPaths.put(key, path2);
        Node current = this.myRootNode;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String word = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(word);
        }
        Node c = current;
        while (c != null) {
            ++c.myNestedChildrenCount;
            c = c.myParentNode;
        }
    }

    public String getShortPath(T key) {
        String path2 = this.myPaths.get(key);
        if (path2 == null) {
            return key.toString();
        }
        Node current = this.myRootNode;
        Node firstNodeWithBranches = null;
        Node firstNodeBeforeNodeWithBranches = null;
        Node fileNameNode = null;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String pathComponent = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(pathComponent);
            if (fileNameNode == null) {
                fileNameNode = current;
            }
            if (firstNodeBeforeNodeWithBranches == null && firstNodeWithBranches != null && current.myChildren.size() <= 1 && current.myParentNode.myNestedChildrenCount - current.myParentNode.myChildren.size() < 1) {
                firstNodeBeforeNodeWithBranches = current;
            }
            if (current.myChildren.size() == 1 || firstNodeWithBranches != null) continue;
            firstNodeWithBranches = current;
        }
        StringBuilder b2 = new StringBuilder();
        if (firstNodeBeforeNodeWithBranches == null) {
            firstNodeBeforeNodeWithBranches = current;
        }
        boolean skipFirstSeparator = true;
        Node c = firstNodeBeforeNodeWithBranches;
        while (c != this.myRootNode) {
            if (c != fileNameNode && c != firstNodeBeforeNodeWithBranches && c.myParentNode.myChildren.size() == 1) {
                b2.append(this.mySeparator);
                b2.append("\u2026");
                while (c.myParentNode != fileNameNode && c.myParentNode.myChildren.size() == 1) {
                    c = c.myParentNode;
                }
            } else if (c.myText.startsWith(VFS_SEPARATOR)) {
                if (!skipFirstSeparator) {
                    b2.append(this.mySeparator);
                }
                skipFirstSeparator = false;
                b2.append(c.myText, VFS_SEPARATOR.length(), c.myText.length());
            } else {
                b2.append(c.myText);
            }
            c = c.myParentNode;
        }
        return b2.toString();
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    private static class PathComponentsIterator
    implements Iterator<String> {
        private final String myPath;
        private int myLastPos;
        private int mySeparatorPos;

        PathComponentsIterator(String path2) {
            this.myPath = path2;
            this.myLastPos = path2.length();
            this.mySeparatorPos = path2.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR);
        }

        @Override
        public boolean hasNext() {
            return this.myLastPos != 0;
        }

        @Override
        public String next() {
            String pathComponent;
            if (this.myLastPos == 0) {
                throw new NoSuchElementException();
            }
            if (this.mySeparatorPos != -1) {
                pathComponent = this.myPath.substring(this.mySeparatorPos, this.myLastPos);
                this.myLastPos = this.mySeparatorPos;
                this.mySeparatorPos = this.myPath.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR, this.myLastPos - 1);
            } else {
                pathComponent = this.myPath.substring(0, this.myLastPos);
                if (!pathComponent.startsWith(UniqueNameBuilder.VFS_SEPARATOR)) {
                    pathComponent = UniqueNameBuilder.VFS_SEPARATOR + pathComponent;
                }
                this.myLastPos = 0;
            }
            return pathComponent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class Node {
        final String myText;
        final THashMap<String, Node> myChildren;
        final Node myParentNode;
        int myNestedChildrenCount;

        Node(String text2, Node parentNode) {
            this.myText = text2;
            this.myParentNode = parentNode;
            this.myChildren = new THashMap(1);
        }

        Node findOrAddChild(String word) {
            Node node = this.myChildren.get(word);
            if (node == null) {
                node = new Node(word, this);
                this.myChildren.put(word, node);
            }
            return node;
        }
    }
}

