/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import gnu.trove.PrimeFinder;

final class AddonlyKeylessHash<K, V> {
    private int size;
    private Object[] entries;
    private final KeyValueMapper<K, V> keyValueMapper;

    public AddonlyKeylessHash(KeyValueMapper<K, V> _keyValueMapper) {
        this(4, _keyValueMapper);
    }

    public AddonlyKeylessHash(int expectedSize, KeyValueMapper<K, V> _keyValueMapper) {
        int i2 = PrimeFinder.nextPrime(5 * expectedSize / 4 + 1);
        this.entries = new Object[i2];
        this.keyValueMapper = _keyValueMapper;
    }

    public int size() {
        return this.size;
    }

    public void add(V item) {
        V v;
        if (this.size >= 4 * this.entries.length / 5) {
            this.rehash();
        }
        if ((v = this.doPut(this.entries, item)) == null) {
            ++this.size;
        }
    }

    private V doPut(Object[] a2, V o) {
        K key = this.keyValueMapper.key(o);
        int index2 = this.hashIndex(a2, key);
        Object obj = a2[index2];
        a2[index2] = o;
        return (V)obj;
    }

    private int hashIndex(Object[] a2, K key) {
        int hash = this.keyValueMapper.hash(key) & Integer.MAX_VALUE;
        int index2 = hash % a2.length;
        Object candidate2 = a2[index2];
        if (candidate2 == null || this.keyValueMapper.valueHasKey(candidate2, key)) {
            return index2;
        }
        int probe = 1 + hash % (a2.length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += a2.length;
        } while ((candidate2 = a2[index2]) != null && !this.keyValueMapper.valueHasKey(candidate2, key));
        return index2;
    }

    private void rehash() {
        Object[] b2 = new Object[PrimeFinder.nextPrime(this.entries.length * 2)];
        int i2 = this.entries.length;
        while (--i2 >= 0) {
            Object ns = this.entries[i2];
            if (ns == null) continue;
            this.doPut(b2, ns);
        }
        this.entries = b2;
    }

    public V get(K key) {
        return (V)this.entries[this.hashIndex(this.entries, key)];
    }

    public static abstract class KeyValueMapper<K, V> {
        public abstract int hash(K var1);

        public abstract K key(V var1);

        public boolean valueHasKey(V value, K key) {
            return key == this.key(value);
        }

        protected boolean isIdentity() {
            return true;
        }
    }
}

