/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies;

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(1);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    }

    public ForwardDependenciesBuilder(Project project, AnalysisScope scope, AnalysisScope scopeOfInterest) {
        super(project, scope, scopeOfInterest);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
    }

    public ForwardDependenciesBuilder(Project project, AnalysisScope scope, int transitive) {
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myTransitive = transitive;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisScopeBundle.message("forward.dependencies.usage.view.root.node.text", new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisScopeBundle.message("forward.dependencies.usage.view.initial.text", new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance(this.getProject());
        psiManager.startBatchFilesProcessingMode();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.getProject()).getFileIndex();
        try {
            this.getScope().accept(new PsiRecursiveElementVisitor(){

                @Override
                public void visitFile(PsiFile file2) {
                    ForwardDependenciesBuilder.this.visit(file2, fileIndex, psiManager, 0);
                }
            });
        }
        finally {
            psiManager.finishBatchFilesProcessingMode();
        }
    }

    private void visit(PsiFile file2, final ProjectFileIndex fileIndex, PsiManager psiManager, int depth) {
        final FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        if (this.getScopeOfInterest() != null && !this.getScopeOfInterest().contains(file2)) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisScopeBundle.message("package.dependencies.progress.text", new Object[0]));
            if (virtualFile2 != null) {
                indicator.setText2(this.getRelativeToProjectPath(virtualFile2));
            }
            if (this.myTotalFileCount > 0) {
                indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile2 == null || fileIndex.isInLibrarySource(virtualFile2) || fileIndex.isInLibraryClasses(virtualFile2);
        HashSet<PsiFile> collectedDeps = new HashSet<PsiFile>();
        HashSet<PsiFile> processed2 = new HashSet<PsiFile>();
        collectedDeps.add(file2);
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator != null) {
                        indicator.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && (fileIndex.isInLibraryClasses(vFile) || fileIndex.isInLibrarySource(vFile))) {
                        processed2.add(psiFile);
                    }
                }
                final HashSet found = new HashSet();
                if (processed2.contains(psiFile)) continue;
                processed2.add(psiFile);
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, new DependenciesBuilder.DependencyProcessor(){

                    @Override
                    public void process(PsiElement place, PsiElement dependency) {
                        PsiFile dependencyFile = dependency.getContainingFile();
                        if (dependencyFile != null) {
                            VirtualFile virtualFile2;
                            if (viewProvider == dependencyFile.getViewProvider()) {
                                return;
                            }
                            if (dependencyFile.isPhysical() && (virtualFile2 = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(virtualFile2) || fileIndex.isInLibraryClasses(virtualFile2) || fileIndex.isInLibrarySource(virtualFile2))) {
                                PsiElement navigationElement = dependencyFile.getNavigationElement();
                                found.add(navigationElement instanceof PsiFile ? (PsiFile)navigationElement : dependencyFile);
                            }
                        }
                    }
                });
                Set<PsiFile> deps = this.getDependencies().get(file2);
                if (deps == null) {
                    deps = new HashSet<PsiFile>();
                    this.getDependencies().put(file2, deps);
                }
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance(file2.getProject()).dropFileCaches(file2);
            }
            collectedDeps.removeAll(processed2);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.myDirectDependencies;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

