/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlTextChanged;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;

public class XmlTextChangedImpl
implements XmlTextChanged {
    private final String myOldText;
    private final XmlText myText;

    public XmlTextChangedImpl(XmlText xmlText, String oldText) {
        this.myOldText = oldText;
        this.myText = xmlText;
    }

    @Override
    public String getOldText() {
        return this.myOldText;
    }

    @Override
    public XmlText getText() {
        return this.myText;
    }

    public static PomModelEvent createXmlTextChanged(PomModel source2, XmlText xmlText, String oldText) {
        PomModelEvent event = new PomModelEvent(source2);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(source2, PsiTreeUtil.getParentOfType((PsiElement)xmlText, XmlFile.class));
        xmlAspectChangeSet.add(new XmlTextChangedImpl(xmlText, oldText));
        event.registerChangeSet(source2.getModelAspect(XmlAspect.class), xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "text changed to '" + StringUtil.escapeStringCharacters(this.myText.getValue()) + "' was: '" + StringUtil.escapeStringCharacters(this.myOldText) + "'";
    }
}

