/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.CompositeInstructionClientVisitor;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowStack;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.IntStack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ControlFlowUtil");
    public static final Class[] DEFAULT_EXIT_STATEMENTS_CLASSES = new Class[]{PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class};
    public static final int NORMAL_COMPLETION_REASON = 1;
    public static final int RETURN_COMPLETION_REASON = 2;

    public static List<PsiVariable> getSSAVariables(ControlFlow flow) {
        return ControlFlowUtil.getSSAVariables(flow, 0, flow.getSize(), false);
    }

    public static List<PsiVariable> getSSAVariables(ControlFlow flow, int from, int to, boolean reportVarsIfNonInitializingPathExists) {
        List<Instruction> instructions = flow.getInstructions();
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, from, to, false);
        ArrayList<PsiVariable> result2 = new ArrayList<PsiVariable>(1);
        block0: for (PsiVariable psiVariable : writtenVariables) {
            ArrayList<SSAInstructionState> queue = new ArrayList<SSAInstructionState>();
            queue.add(new SSAInstructionState(0, from));
            THashSet<SSAInstructionState> processedStates = new THashSet<SSAInstructionState>();
            while (!queue.isEmpty()) {
                SSAInstructionState state2 = (SSAInstructionState)queue.remove(0);
                if (state2.getWriteCount() > 1) continue block0;
                if (processedStates.contains(state2)) continue;
                processedStates.add(state2);
                int i2 = state2.getInstructionIdx();
                if (i2 < to) {
                    Instruction instruction = instructions.get(i2);
                    if (instruction instanceof ReturnInstruction) {
                        int[] offsets;
                        for (int offset2 : offsets = ((ReturnInstruction)instruction).getPossibleReturnOffsets()) {
                            queue.add(new SSAInstructionState(state2.getWriteCount(), Math.min(offset2, to)));
                        }
                        continue;
                    }
                    if (instruction instanceof GoToInstruction) {
                        int nextOffset = ((GoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ThrowToInstruction) {
                        int nextOffset = ((ThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ConditionalGoToInstruction) {
                        int nextOffset = ((ConditionalGoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i2 + 1));
                        continue;
                    }
                    if (instruction instanceof ConditionalThrowToInstruction) {
                        int nextOffset = ((ConditionalThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state2.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i2 + 1));
                        continue;
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction write2 = (WriteVariableInstruction)instruction;
                        queue.add(new SSAInstructionState(state2.getWriteCount() + (write2.variable == psiVariable ? 1 : 0), i2 + 1));
                        continue;
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction read2 = (ReadVariableInstruction)instruction;
                        if (read2.variable == psiVariable && state2.getWriteCount() == 0) continue block0;
                        queue.add(new SSAInstructionState(state2.getWriteCount(), i2 + 1));
                        continue;
                    }
                    queue.add(new SSAInstructionState(state2.getWriteCount(), i2 + 1));
                    continue;
                }
                if (reportVarsIfNonInitializingPathExists || state2.getWriteCount() != 0) continue;
                continue block0;
            }
            result2.add(psiVariable);
        }
        return result2;
    }

    public static boolean needVariableValueAt(final PsiVariable variable2, final ControlFlow flow, final int offset2) {
        InstructionClientVisitor<Boolean> visitor2 = new InstructionClientVisitor<Boolean>(){
            final boolean[] neededBelow;
            {
                this.neededBelow = new boolean[flow.getSize() + 1];
            }

            @Override
            public void procedureEntered(int startOffset, int endOffset) {
                for (int i2 = startOffset; i2 < endOffset; ++i2) {
                    this.neededBelow[i2] = false;
                }
            }

            @Override
            public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable2)) {
                    needed = true;
                }
                int n = offset22;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable2)) {
                    needed = false;
                }
                this.neededBelow[offset22] = needed;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset22, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                int n = offset22;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public Boolean getResult() {
                return this.neededBelow[offset2];
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset2, flow.getSize());
        return (Boolean)visitor2.getResult();
    }

    public static Collection<PsiVariable> getWrittenVariables(ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites) {
        HashSet<PsiVariable> set = new HashSet<PsiVariable>();
        ControlFlowUtil.getWrittenVariables(flow, start, end, ignoreNotReachingWrites, set);
        return set;
    }

    public static void getWrittenVariables(ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites, Collection<PsiVariable> set) {
        List<Instruction> instructions = flow.getInstructions();
        for (int i2 = start; i2 < end; ++i2) {
            Instruction instruction = instructions.get(i2);
            if (!(instruction instanceof WriteVariableInstruction) || ignoreNotReachingWrites && !ControlFlowUtil.isInstructionReachable(flow, end, i2)) continue;
            set.add(((WriteVariableInstruction)instruction).variable);
        }
    }

    public static List<PsiVariable> getUsedVariables(ControlFlow flow, int start, int end) {
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        if (start < 0) {
            return array;
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i2 = start; i2 < end; ++i2) {
            PsiVariable variable2;
            Instruction instruction = instructions.get(i2);
            if (instruction instanceof ReadVariableInstruction) {
                variable2 = ((ReadVariableInstruction)instruction).variable;
                if (array.contains(variable2)) continue;
                array.add(variable2);
                continue;
            }
            if (!(instruction instanceof WriteVariableInstruction) || array.contains(variable2 = ((WriteVariableInstruction)instruction).variable)) continue;
            array.add(variable2);
        }
        return array;
    }

    public static boolean isVariableUsed(ControlFlow flow, int start, int end, PsiVariable variable2) {
        List<Instruction> instructions = flow.getInstructions();
        LOG.assertTrue(start >= 0, "flow start");
        LOG.assertTrue(end <= instructions.size(), "flow end");
        for (int i2 = start; i2 < end; ++i2) {
            Instruction instruction = instructions.get(i2);
            if (!(instruction instanceof ReadVariableInstruction ? ((ReadVariableInstruction)instruction).variable == variable2 : instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable2)) continue;
            return true;
        }
        return false;
    }

    private static int findSingleReadOffset(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(1);
        }
        List<Instruction> instructions = flow.getInstructions();
        if (startOffset < 0 || endOffset < 0 || endOffset > instructions.size()) {
            return -1;
        }
        int readOffset = -1;
        for (int i2 = startOffset; i2 < endOffset; ++i2) {
            Instruction instruction = instructions.get(i2);
            if (instruction instanceof ReadVariableInstruction) {
                if (((ReadVariableInstruction)instruction).variable != variable2) continue;
                if (readOffset < 0) {
                    readOffset = i2;
                    continue;
                }
                return -1;
            }
            if (!(instruction instanceof WriteVariableInstruction) || ((WriteVariableInstruction)instruction).variable != variable2) continue;
            return -1;
        }
        return readOffset;
    }

    public static PsiReferenceExpression findSingleReadOccurrence(@NotNull ControlFlow flow, @NotNull PsiElement element, @NotNull PsiVariable variable2) {
        int readOffset;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(3);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(4);
        }
        if ((readOffset = ControlFlowUtil.findSingleReadOffset(flow, flow.getStartOffset(element), flow.getEndOffset(element), variable2)) >= 0) {
            PsiElement readElement = flow.getElement(readOffset);
            if ((readElement = PsiTreeUtil.findFirstParent(readElement, false, e -> {
                if (element == null) {
                    ControlFlowUtil.$$$reportNull$$$0(35);
                }
                return e == element || e instanceof PsiReferenceExpression;
            })) instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)readElement;
            }
        }
        return null;
    }

    public static boolean isVariableReadInFinally(@NotNull ControlFlow flow, @Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment, @NotNull PsiVariable variable2) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(5);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(7);
        }
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiCodeBlock finallyBlock;
            PsiTryStatement tryStatement;
            PsiElement parent2;
            if (!(element instanceof PsiCodeBlock) || !((parent2 = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent2).getTryBlock() != element || (finallyBlock = tryStatement.getFinallyBlock()) == null) continue;
            List<Instruction> instructions = flow.getInstructions();
            int startOffset = flow.getStartOffset(finallyBlock);
            int endOffset = flow.getEndOffset(finallyBlock);
            LOG.assertTrue(startOffset >= 0, "flow start");
            LOG.assertTrue(endOffset <= instructions.size(), "flow end");
            for (int i2 = startOffset; i2 < endOffset; ++i2) {
                Instruction instruction = instructions.get(i2);
                if (!(instruction instanceof ReadVariableInstruction) || ((ReadVariableInstruction)instruction).variable != variable2) continue;
                return true;
            }
        }
        return false;
    }

    public static List<PsiVariable> getInputVariables(ControlFlow flow, int start, int end) {
        List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(flow, start, end);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>(usedVariables.size());
        for (PsiVariable variable2 : usedVariables) {
            if (!ControlFlowUtil.needVariableValueAt(variable2, flow, start)) continue;
            array.add(variable2);
        }
        return array;
    }

    @NotNull
    public static PsiVariable[] getOutputVariables(ControlFlow flow, int start, int end, int[] exitPoints) {
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, start, end, false);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        for (PsiVariable variable2 : writtenVariables) {
            int[] nArray = exitPoints;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int exitPoint = nArray[j];
                if (!ControlFlowUtil.needVariableValueAt(variable2, flow, exitPoint)) continue;
                array.add(variable2);
            }
        }
        PsiVariable[] outputVariables = array.toArray(new PsiVariable[array.size()]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("output variables:");
            for (PsiVariable variable3 : outputVariables) {
                LOG.debug("  " + variable3.toString());
            }
        }
        if (outputVariables == null) {
            ControlFlowUtil.$$$reportNull$$$0(8);
        }
        return outputVariables;
    }

    public static Collection<PsiStatement> findExitPointsAndStatements(final ControlFlow flow, final int start, final int end, final IntArrayList exitPoints, final Class ... classesFilter) {
        if (end == start) {
            exitPoints.add(end);
            return Collections.emptyList();
        }
        final THashSet<PsiStatement> exitStatements = new THashSet<PsiStatement>();
        InstructionClientVisitor visitor2 = new InstructionClientVisitor(){

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, ControlFlowUtil.findStatement(flow, offset2));
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset2, int nextOffset) {
                ControlFlowUtil.processGoto(flow, start, end, exitPoints, exitStatements, instruction, classesFilter, ControlFlowUtil.findStatement(flow, offset2));
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset2, int nextOffset) {
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                this.visitInstruction(instruction, offset2, nextOffset);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (offset2 >= end - 1) {
                    int exitOffset = end;
                    if (!exitPoints.contains(exitOffset = ControlFlowUtil.promoteThroughGotoChain(flow, exitOffset))) {
                        exitPoints.add(exitOffset);
                    }
                }
            }

            public Object getResult() {
                return null;
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor2, start, end);
        return exitStatements;
    }

    private static void processGoto(ControlFlow flow, int start, int end, IntArrayList exitPoints, Collection<PsiStatement> exitStatements, BranchingInstruction instruction, Class[] classesFilter, PsiStatement statement2) {
        if (statement2 == null) {
            return;
        }
        int gotoOffset = instruction.offset;
        if (start > gotoOffset || gotoOffset >= end || ControlFlowUtil.isElementOfClass(statement2, classesFilter)) {
            if (!(exitPoints.contains(gotoOffset = ControlFlowUtil.promoteThroughGotoChain(flow, gotoOffset)) || gotoOffset < end && gotoOffset >= start || gotoOffset <= 0)) {
                exitPoints.add(gotoOffset);
            }
            if (gotoOffset >= end || gotoOffset < start) {
                ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, statement2);
            } else {
                boolean isReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                Instruction gotoInstruction = flow.getInstructions().get(gotoOffset);
                if (isReturn |= gotoInstruction instanceof GoToInstruction && ((GoToInstruction)gotoInstruction).isReturn) {
                    ControlFlowUtil.processGotoStatement(classesFilter, exitStatements, statement2);
                }
            }
        }
    }

    private static void processGotoStatement(Class[] classesFilter, Collection<PsiStatement> exitStatements, PsiStatement statement2) {
        if (statement2 != null && ControlFlowUtil.isElementOfClass(statement2, classesFilter)) {
            exitStatements.add(statement2);
        }
    }

    private static boolean isElementOfClass(PsiElement element, Class[] classesFilter) {
        if (classesFilter == null) {
            return true;
        }
        for (Class aClassesFilter : classesFilter) {
            if (!ReflectionUtil.isAssignable(aClassesFilter, element.getClass())) continue;
            return true;
        }
        return false;
    }

    private static int promoteThroughGotoChain(ControlFlow flow, int offset2) {
        Instruction instruction;
        List<Instruction> instructions = flow.getInstructions();
        while (offset2 < instructions.size() && (instruction = instructions.get(offset2)) instanceof GoToInstruction && !((GoToInstruction)instruction).isReturn) {
            offset2 = ((BranchingInstruction)instruction).offset;
        }
        return offset2;
    }

    private static PsiStatement findStatement(ControlFlow flow, int offset2) {
        PsiElement element = flow.getElement(offset2);
        return PsiTreeUtil.getParentOfType(element, PsiStatement.class, false);
    }

    public static boolean hasObservableThrowExitPoints(@NotNull ControlFlow flow, final int flowStart, final int flowEnd, @NotNull PsiElement[] elements, @NotNull PsiElement enclosingCodeFragment) {
        List<Instruction> instructions;
        Worker worker;
        Map writeOffsets;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            ControlFlowUtil.$$$reportNull$$$0(10);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(11);
        }
        class Worker {
            final /* synthetic */ List val$instructions;
            final /* synthetic */ ControlFlow val$flow;

            Worker() {
                this.val$instructions = list2;
                this.val$flow = controlFlow;
            }

            @NotNull
            private Map<PsiVariable, IntArrayList> getWritesOffsets() {
                THashMap<PsiVariable, IntArrayList> writeOffsets = new THashMap<PsiVariable, IntArrayList>();
                for (int i2 = flowStart; i2 < flowEnd; ++i2) {
                    PsiVariable variable2;
                    Instruction instruction = (Instruction)this.val$instructions.get(i2);
                    if (!(instruction instanceof WriteVariableInstruction) || !((variable2 = ((WriteVariableInstruction)instruction).variable) instanceof PsiLocalVariable) && !(variable2 instanceof PsiParameter)) continue;
                    IntArrayList offsets = (IntArrayList)writeOffsets.get(variable2);
                    if (offsets == null) {
                        offsets = new IntArrayList();
                        writeOffsets.put(variable2, offsets);
                    }
                    offsets.add(i2);
                }
                LOG.debug("writeOffsets:", writeOffsets);
                THashMap<PsiVariable, IntArrayList> tHashMap = writeOffsets;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(0);
                }
                return tHashMap;
            }

            @NotNull
            private Map<PsiVariable, IntArrayList> getVisibleReadsOffsets(Map<PsiVariable, IntArrayList> writeOffsets, PsiCodeBlock tryBlock) {
                THashMap<PsiVariable, IntArrayList> visibleReadOffsets = new THashMap<PsiVariable, IntArrayList>();
                for (PsiVariable variable2 : writeOffsets.keySet()) {
                    if (PsiTreeUtil.isAncestor(tryBlock, variable2, true)) continue;
                    visibleReadOffsets.put(variable2, new IntArrayList());
                }
                if (visibleReadOffsets.isEmpty()) {
                    THashMap<PsiVariable, IntArrayList> tHashMap = visibleReadOffsets;
                    if (tHashMap == null) {
                        Worker.$$$reportNull$$$0(1);
                    }
                    return tHashMap;
                }
                for (int i2 = 0; i2 < this.val$instructions.size(); ++i2) {
                    PsiVariable variable3;
                    IntArrayList readOffsets;
                    Instruction instruction = (Instruction)this.val$instructions.get(i2);
                    if (!(instruction instanceof ReadVariableInstruction) || (readOffsets = (IntArrayList)visibleReadOffsets.get(variable3 = ((ReadVariableInstruction)instruction).variable)) == null) continue;
                    readOffsets.add(i2);
                }
                LOG.debug("visibleReadOffsets:", visibleReadOffsets);
                THashMap<PsiVariable, IntArrayList> tHashMap = visibleReadOffsets;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(2);
                }
                return tHashMap;
            }

            @NotNull
            private Map<PsiVariable, Set<PsiElement>> getReachableAfterWrite(Map<PsiVariable, IntArrayList> writeOffsets, Map<PsiVariable, IntArrayList> visibleReadOffsets) {
                THashMap<PsiVariable, Set<PsiElement>> afterWrite = new THashMap<PsiVariable, Set<PsiElement>>();
                for (PsiVariable variable2 : visibleReadOffsets.keySet()) {
                    Function<Integer, BitSet> calculator = this.getReachableInstructionsCalculator();
                    BitSet collectedOffsets = new BitSet(flowEnd);
                    for (int writeOffset : writeOffsets.get(variable2).toArray()) {
                        LOG.assertTrue(writeOffset >= flowStart, "writeOffset");
                        BitSet reachableOffsets = calculator.fun(writeOffset);
                        collectedOffsets.or(reachableOffsets);
                    }
                    THashSet<PsiElement> throwSources = (THashSet<PsiElement>)afterWrite.get(variable2);
                    if (throwSources == null) {
                        throwSources = new THashSet<PsiElement>();
                        afterWrite.put(variable2, throwSources);
                    }
                    for (int i2 = flowStart; i2 < flowEnd; ++i2) {
                        if (!collectedOffsets.get(i2)) continue;
                        throwSources.add(this.val$flow.getElement(i2));
                    }
                    ArrayList<PsiElement> subordinates = new ArrayList<PsiElement>();
                    for (PsiElement element : throwSources) {
                        if (!throwSources.contains(element.getParent())) continue;
                        subordinates.add(element);
                    }
                    throwSources.removeAll(subordinates);
                }
                LOG.debug("afterWrite:", afterWrite);
                THashMap<PsiVariable, Set<PsiElement>> tHashMap = afterWrite;
                if (tHashMap == null) {
                    Worker.$$$reportNull$$$0(3);
                }
                return tHashMap;
            }

            @NotNull
            private IntArrayList getCatchOrFinallyOffsets(List<PsiTryStatement> tryStatements, List<PsiClassType> thrownExceptions) {
                IntArrayList catchOrFinallyOffsets = new IntArrayList();
                for (PsiTryStatement tryStatement : tryStatements) {
                    int offset2;
                    PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
                    if (finallyBlock != null && (offset2 = this.val$flow.getStartOffset(finallyBlock)) >= 0) {
                        catchOrFinallyOffsets.add(offset2 - 2);
                    }
                    for (PsiCatchSection catchSection : tryStatement.getCatchSections()) {
                        PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                        PsiParameter parameter = catchSection.getParameter();
                        if (catchBlock == null || parameter == null) continue;
                        for (PsiClassType throwType : thrownExceptions) {
                            int offset3;
                            if (!ControlFlowUtil.isCaughtExceptionType(throwType, parameter.getType()) || (offset3 = this.val$flow.getStartOffset(catchBlock)) < 0) continue;
                            catchOrFinallyOffsets.add(offset3 - 1);
                        }
                    }
                }
                IntArrayList intArrayList = catchOrFinallyOffsets;
                if (intArrayList == null) {
                    Worker.$$$reportNull$$$0(4);
                }
                return intArrayList;
            }

            private boolean isAnyReadOffsetReachableFrom(IntArrayList readOffsets, IntArrayList fromOffsets) {
                if (readOffsets != null && !readOffsets.isEmpty()) {
                    int[] readOffsetsArray = readOffsets.toArray();
                    for (int j = 0; j < fromOffsets.size(); ++j) {
                        int fromOffset = fromOffsets.get(j);
                        if (!ControlFlowUtil.areInstructionsReachable(this.val$flow, readOffsetsArray, fromOffset)) continue;
                        LOG.debug("reachableFromOffset:", fromOffset);
                        return true;
                    }
                }
                return false;
            }

            private Function<Integer, BitSet> getReachableInstructionsCalculator() {
                ControlFlowGraph graph2 = new ControlFlowGraph(this.val$flow.getSize()){

                    @Override
                    void addArc(int offset2, int nextOffset) {
                        if ((nextOffset = ControlFlowUtil.promoteThroughGotoChain(val$flow, nextOffset)) >= flowStart && nextOffset < flowEnd) {
                            super.addArc(offset2, nextOffset);
                        }
                    }
                };
                graph2.buildFrom(this.val$flow);
                return startOffset -> {
                    BitSet visitedOffsets = new BitSet(flowEnd);
                    graph2.depthFirstSearch((int)startOffset, visitedOffsets);
                    return visitedOffsets;
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$1Worker";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWritesOffsets";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibleReadsOffsets";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReachableAfterWrite";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCatchOrFinallyOffsets";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
        if ((writeOffsets = (worker = new Worker()).getWritesOffsets()).isEmpty()) {
            return false;
        }
        PsiElement commonParent = elements.length != 1 ? PsiTreeUtil.findCommonParent(elements) : elements[0].getParent();
        List<PsiTryStatement> tryStatements = ControlFlowUtil.collectTryStatementStack(commonParent, enclosingCodeFragment);
        if (tryStatements.isEmpty()) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatements.get(0).getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        Map visibleReadOffsets = worker.getVisibleReadsOffsets(writeOffsets, tryBlock);
        if (visibleReadOffsets.isEmpty()) {
            return false;
        }
        Map afterWrite = worker.getReachableAfterWrite(writeOffsets, visibleReadOffsets);
        if (afterWrite.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : afterWrite.entrySet()) {
            PsiVariable variable2 = (PsiVariable)entry.getKey();
            PsiElement[] psiElements = ((Set)entry.getValue()).toArray(PsiElement.EMPTY_ARRAY);
            List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions(psiElements);
            if (thrownExceptions.isEmpty()) continue;
            IntArrayList catchOrFinallyOffsets = worker.getCatchOrFinallyOffsets(tryStatements, thrownExceptions);
            if (!worker.isAnyReadOffsetReachableFrom((IntArrayList)visibleReadOffsets.get(variable2), catchOrFinallyOffsets)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiTryStatement getEnclosingTryStatementHavingCatchOrFinally(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(12);
        }
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiTryStatement tryStatement;
            PsiElement parent2;
            if (!(element instanceof PsiCodeBlock) || !((parent2 = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent2).getTryBlock() != element || tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) continue;
            return tryStatement;
        }
        return null;
    }

    @NotNull
    private static List<PsiTryStatement> collectTryStatementStack(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(13);
        }
        ArrayList<PsiTryStatement> stack = new ArrayList<PsiTryStatement>();
        PsiTryStatement tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(startElement, enclosingCodeFragment);
        while (tryStatement != null) {
            stack.add(tryStatement);
            tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(tryStatement, enclosingCodeFragment);
        }
        ArrayList<PsiTryStatement> arrayList = stack;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement findCodeFragment(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(15);
        }
        PsiElement codeFragment = element;
        for (PsiElement parent2 = codeFragment.getParent(); !(parent2 == null || parent2 instanceof PsiDirectory || parent2 instanceof PsiMethod || parent2 instanceof PsiField || parent2 instanceof PsiClassInitializer || parent2 instanceof DummyHolder || parent2 instanceof PsiLambdaExpression); parent2 = parent2.getParent()) {
            codeFragment = parent2;
        }
        PsiElement psiElement = codeFragment;
        if (psiElement == null) {
            ControlFlowUtil.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    private static boolean checkReferenceExpressionScope(PsiReferenceExpression ref, @NotNull PsiElement targetClassMember) {
        JavaResolveResult resolveResult;
        PsiElement def;
        if (targetClassMember == null) {
            ControlFlowUtil.$$$reportNull$$$0(17);
        }
        if ((def = (resolveResult = ref.advancedResolve(false)).getElement()) != null) {
            PsiElement commonParent;
            PsiElement parent2 = def.getParent();
            PsiElement psiElement = commonParent = parent2 == null ? null : PsiTreeUtil.findCommonParent(parent2, targetClassMember);
            if (commonParent == null) {
                parent2 = resolveResult.getCurrentFileResolveScope();
            }
            if (parent2 instanceof PsiClass) {
                PsiClass clss = (PsiClass)parent2;
                if (PsiTreeUtil.isAncestor(targetClassMember, clss, false)) {
                    return false;
                }
                for (PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class); containingClass != null; containingClass = containingClass.getContainingClass()) {
                    if (!containingClass.isInheritor(clss, true) || !PsiTreeUtil.isAncestor(targetClassMember, containingClass, false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collectOuterLocals(List<PsiVariable> array, PsiElement scope, PsiElement member, PsiElement targetClassMember) {
        PsiJavaCodeReferenceElement qualifier;
        PsiMethodCallExpression call2;
        if (scope instanceof PsiMethodCallExpression ? !ControlFlowUtil.checkReferenceExpressionScope((call2 = (PsiMethodCallExpression)scope).getMethodExpression(), targetClassMember) : scope instanceof PsiReferenceExpression && !ControlFlowUtil.checkReferenceExpressionScope((PsiReferenceExpression)scope, targetClassMember)) {
            return false;
        }
        if (scope instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)scope;
            JavaResolveResult result2 = ref.advancedResolve(false);
            PsiElement refElement = result2.getElement();
            if (refElement != null) {
                PsiElement parent2 = refElement.getParent();
                PsiElement psiElement = parent2 = parent2 != null ? PsiTreeUtil.findCommonParent(parent2, member) : null;
                if (parent2 == null) {
                    parent2 = result2.getCurrentFileResolveScope();
                }
                if (parent2 != null && !member.equals(parent2) && targetClassMember.equals(parent2 = PsiTreeUtil.findCommonParent(parent2, targetClassMember))) {
                    if (!(refElement instanceof PsiVariable)) return false;
                    if (scope instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiReferenceExpression)scope)) {
                        return false;
                    }
                    PsiVariable variable2 = (PsiVariable)refElement;
                    if (!array.contains(variable2)) {
                        array.add(variable2);
                    }
                }
            }
        } else if (scope instanceof PsiThisExpression ? (qualifier = ((PsiThisExpression)scope).getQualifier()) == null : scope instanceof PsiSuperExpression && ((PsiSuperExpression)scope).getQualifier() == null) {
            return false;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (ControlFlowUtil.collectOuterLocals(array, child, member, targetClassMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean returnPresent(ControlFlow flow) {
        ReturnPresentClientVisitor visitor2 = new ReturnPresentClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (Boolean)((InstructionClientVisitor)visitor2).getResult();
    }

    public static boolean processReturns(ControlFlow flow, ReturnStatementsVisitor afterVisitor) throws IncorrectOperationException {
        ConvertReturnClientVisitor instructionsVisitor = new ConvertReturnClientVisitor(flow, afterVisitor);
        ControlFlowUtil.depthFirstSearch(flow, instructionsVisitor);
        instructionsVisitor.afterProcessing();
        return instructionsVisitor.getResult();
    }

    public static boolean returnPresentBetween(final ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] isNormalCompletion;

            public MyVisitor() {
                int i2;
                this.isNormalCompletion = new boolean[flow.getSize() + 1];
                int length = flow.getSize();
                for (i2 = 0; i2 < startOffset; ++i2) {
                    this.isNormalCompletion[i2] = true;
                }
                for (i2 = endOffset; i2 <= length; ++i2) {
                    this.isNormalCompletion[i2] = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                boolean isNormal;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                if (throwToOffset == nextOffset) {
                    if (throwToOffset > endOffset) return;
                    isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                } else {
                    isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                }
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                    int n = offset2;
                    this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset2 + 1) {
                    return;
                }
                boolean isNormal = this.isNormalCompletion[nextOffset];
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                boolean isRethrowFromFinally = instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isRethrowFromFinally();
                boolean isNormal = !instruction.isReturn && this.isNormalCompletion[nextOffset] && !isRethrowFromFinally;
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                int n = offset2;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public Boolean getResult() {
                return !this.isNormalCompletion[startOffset];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    @NotNull
    public static Object[] getAllWorldProblemsAtOnce(ControlFlow flow) {
        InstructionClientVisitor[] visitors = new InstructionClientVisitor[]{new ReturnPresentClientVisitor(flow), new UnreachableStatementClientVisitor(flow), new ReadBeforeWriteClientVisitor(flow, true), new InitializedTwiceClientVisitor(flow, 0)};
        CompositeInstructionClientVisitor visitor2 = new CompositeInstructionClientVisitor(visitors);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        Object[] objectArray = visitor2.getResult();
        if (objectArray == null) {
            ControlFlowUtil.$$$reportNull$$$0(18);
        }
        return objectArray;
    }

    public static boolean canCompleteNormally(final ControlFlow flow, final int startOffset, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] canCompleteNormally;

            MyVisitor() {
                this.canCompleteNormally = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, false);
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, instruction.isReturn);
            }

            private void checkInstruction(int offset2, int nextOffset, boolean isReturn) {
                boolean isNormal;
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean bl = isNormal = nextOffset <= endOffset && !isReturn && (nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                if (isNormal && nextOffset == endOffset) {
                    PsiStatement continuedStatement;
                    PsiElement element = flow.getElement(offset2);
                    if (element instanceof PsiBreakStatement) {
                        PsiStatement exitedStatement = ((PsiBreakStatement)element).findExitedStatement();
                        if (exitedStatement == null || flow.getStartOffset(exitedStatement) < startOffset) {
                            isNormal = false;
                        }
                    } else if (element instanceof PsiContinueStatement && ((continuedStatement = ((PsiContinueStatement)element).findContinuedStatement()) == null || flow.getStartOffset(continuedStatement) < startOffset)) {
                        isNormal = false;
                    }
                }
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                boolean isNormal = throwToOffset == nextOffset ? throwToOffset <= endOffset && !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset] : this.canCompleteNormally[nextOffset];
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                    int n = offset2;
                    this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset2 > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset2 + 1) {
                    return;
                }
                boolean isNormal = this.canCompleteNormally[nextOffset];
                int n = offset2;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                this.checkInstruction(offset2, nextOffset, false);
            }

            @Override
            public Boolean getResult() {
                return this.canCompleteNormally[startOffset];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        return visitor2.getResult();
    }

    public static PsiElement getUnreachableStatement(ControlFlow flow) {
        UnreachableStatementClientVisitor visitor2 = new UnreachableStatementClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (PsiElement)((InstructionClientVisitor)visitor2).getResult();
    }

    private static PsiReferenceExpression getEnclosingReferenceExpression(PsiElement element, PsiVariable variable2) {
        PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(element, variable2);
        if (reference != null) {
            return reference;
        }
        while (element != null) {
            if (element instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)element;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiReferenceExpression findReferenceTo(PsiElement element, PsiVariable variable2) {
        PsiElement[] children2;
        if (element instanceof PsiReferenceExpression && ControlFlowUtil.isUnqualified((PsiReferenceExpression)element) && ((PsiReferenceExpression)element).resolve() == variable2) {
            return (PsiReferenceExpression)element;
        }
        for (PsiElement child : children2 = element.getChildren()) {
            PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(child, variable2);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    private static boolean isUnqualified(PsiReferenceExpression element) {
        if (element.isQualified()) {
            PsiExpression qualifierExpression = element.getQualifierExpression();
            return qualifierExpression instanceof PsiThisExpression && ((PsiThisExpression)qualifierExpression).getQualifier() == null;
        }
        return true;
    }

    public static boolean isVariableDefinitelyAssigned(final @NotNull PsiVariable variable2, final @NotNull ControlFlow flow) {
        if (variable2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(19);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (flow.getSize() == 0) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] maybeUnassigned;

            MyVisitor() {
                this.maybeUnassigned = new boolean[flow.getSize() + 1];
                this.maybeUnassigned[this.maybeUnassigned.length - 1] = true;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (instruction.variable == variable2) {
                    this.maybeUnassigned[offset2] = false;
                } else {
                    this.visitInstruction(instruction, offset2, nextOffset);
                }
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = offset2 == flow.getSize() - 1 || !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                this.visitInstruction(instruction, offset2, nextOffset);
                for (int i2 = instruction.procBegin; i2 < instruction.procEnd + 3; ++i2) {
                    this.maybeUnassigned[i2] = false;
                }
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = this.isLeaf(nextOffset) || this.maybeUnassigned[nextOffset];
                int n = offset2;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public Boolean getResult() {
                int variableDeclarationOffset = flow.getStartOffset(variable2.getParent());
                return !this.maybeUnassigned[variableDeclarationOffset > -1 ? variableDeclarationOffset : 0];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean isVariableDefinitelyNotAssigned(final PsiVariable variable2, final ControlFlow flow) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] maybeAssigned;

            MyVisitor() {
                this.maybeAssigned = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = instruction.variable == variable2 || this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
                int throwToOffset;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = (throwToOffset = instruction.offset) == nextOffset ? !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset] : this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.maybeAssigned[nextOffset];
                int n = offset2;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public Boolean getResult() {
                return !this.maybeAssigned[0];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    public static boolean isValueUsedWithoutVisitingStop(final ControlFlow flow, final int start, final int stop, final PsiVariable variable2) {
        if (start == stop) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final boolean[] maybeReferenced;

            MyVisitor() {
                this.maybeReferenced = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                boolean nextState;
                if (offset2 == stop) {
                    this.maybeReferenced[offset2] = false;
                    return;
                }
                if (instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable2) {
                    this.maybeReferenced[offset2] = false;
                    return;
                }
                if (this.maybeReferenced[offset2]) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                this.maybeReferenced[offset2] = (nextState = this.maybeReferenced[nextOffset]) || instruction instanceof ReadVariableInstruction && ((ReadVariableInstruction)instruction).variable == variable2;
            }

            @Override
            public Boolean getResult() {
                return this.maybeReferenced[start];
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, start, flow.getSize());
        return visitor2.getResult();
    }

    public static boolean isVariableAccess(ControlFlow flow, int offset2, PsiVariable variable2) {
        Instruction instruction = flow.getInstructions().get(offset2);
        return instruction instanceof ReadVariableInstruction && ((ReadVariableInstruction)instruction).variable == variable2 || instruction instanceof WriteVariableInstruction && ((WriteVariableInstruction)instruction).variable == variable2;
    }

    public static List<ControlFlowEdge> getEdges(ControlFlow flow, int start) {
        final ArrayList<ControlFlowEdge> list2 = new ArrayList<ControlFlowEdge>();
        ControlFlowUtil.depthFirstSearch(flow, new InstructionClientVisitor<Void>(){

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                list2.add(new ControlFlowEdge(offset2, nextOffset));
            }

            @Override
            public Void getResult() {
                return null;
            }
        }, start, flow.getSize());
        return list2;
    }

    public static int getMinDefinitelyReachedOffset(final ControlFlow flow, final int sourceOffset, final List references) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            final TIntHashSet[] exitPoints;

            MyVisitor() {
                this.exitPoints = new TIntHashSet[flow.getSize()];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (this.exitPoints[offset2] == null) {
                    this.exitPoints[offset2] = new TIntHashSet();
                }
                if (this.isLeaf(nextOffset)) {
                    this.exitPoints[offset2].add(offset2);
                } else if (this.exitPoints[nextOffset] != null) {
                    this.exitPoints[offset2].addAll(this.exitPoints[nextOffset].toArray());
                }
            }

            @Override
            public Integer getResult() {
                int minOffset = flow.getSize();
                int maxExitPoints = 0;
                block0: for (int i2 = sourceOffset; i2 < this.exitPoints.length; ++i2) {
                    int size;
                    TIntHashSet exitPointSet = this.exitPoints[i2];
                    int n = size = exitPointSet == null ? 0 : exitPointSet.size();
                    if (size <= maxExitPoints) continue;
                    for (Object reference : references) {
                        int endOffset;
                        PsiElement element = (PsiElement)reference;
                        PsiElement statement2 = PsiUtil.getEnclosingStatement(element);
                        if (statement2 == null || (endOffset = flow.getEndOffset(statement2)) == -1 || i2 == endOffset || ControlFlowUtil.isInstructionReachable(flow, i2, endOffset)) continue;
                        continue block0;
                    }
                    minOffset = i2;
                    maxExitPoints = size;
                }
                return minOffset;
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult();
    }

    private static void depthFirstSearch(ControlFlow flow, InstructionClientVisitor visitor2) {
        ControlFlowUtil.depthFirstSearch(flow, visitor2, 0, flow.getSize());
    }

    private static void depthFirstSearch(ControlFlow flow, InstructionClientVisitor visitor2, int startOffset, int endOffset) {
        visitor2.processedInstructions = new boolean[endOffset];
        ControlFlowUtil.internalDepthFirstSearch(flow.getInstructions(), visitor2, startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void internalDepthFirstSearch(final List<Instruction> instructions, final InstructionClientVisitor clientVisitor, int startOffset, int endOffset) {
        final WalkThroughStack walkThroughStack = new WalkThroughStack(instructions.size() / 2);
        walkThroughStack.push(startOffset);
        List<Instruction> list2 = instructions;
        synchronized (list2) {
            final IntArrayList currentProcedureReturnOffsets = new IntArrayList();
            ControlFlowInstructionVisitor getNextOffsetVisitor = new ControlFlowInstructionVisitor(){

                @Override
                public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
                    int i2;
                    instruction.execute(offset2 + 1);
                    int newOffset = instruction.offset;
                    for (i2 = instruction.procBegin; i2 < clientVisitor.processedInstructions.length && (i2 < instruction.procEnd || i2 < instructions.size() && instructions.get(i2) instanceof ReturnInstruction); ++i2) {
                        clientVisitor.processedInstructions[i2] = false;
                    }
                    clientVisitor.procedureEntered(instruction.procBegin, i2);
                    walkThroughStack.push(offset2, newOffset);
                    walkThroughStack.push(newOffset);
                    currentProcedureReturnOffsets.add(offset2 + 1);
                }

                @Override
                public void visitReturnInstruction(ReturnInstruction instruction, int offset2, int nextOffset) {
                    int newOffset = instruction.execute(false);
                    if (newOffset != -1) {
                        walkThroughStack.push(offset2, newOffset);
                        walkThroughStack.push(newOffset);
                    }
                }

                @Override
                public void visitBranchingInstruction(BranchingInstruction instruction, int offset2, int nextOffset) {
                    int newOffset = instruction.offset;
                    walkThroughStack.push(offset2, newOffset);
                    walkThroughStack.push(newOffset);
                }

                @Override
                public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset2, int nextOffset) {
                    int newOffset = instruction.offset;
                    walkThroughStack.push(offset2, newOffset);
                    walkThroughStack.push(offset2, offset2 + 1);
                    walkThroughStack.push(newOffset);
                    walkThroughStack.push(offset2 + 1);
                }

                @Override
                public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                    int newOffset = offset2 + 1;
                    walkThroughStack.push(offset2, newOffset);
                    walkThroughStack.push(newOffset);
                }
            };
            while (!walkThroughStack.isEmpty()) {
                int offset2 = walkThroughStack.peekOldOffset();
                int newOffset = walkThroughStack.popNewOffset();
                if (offset2 >= endOffset) continue;
                Instruction instruction = instructions.get(offset2);
                if (clientVisitor.processedInstructions[offset2]) {
                    if (newOffset != -1) {
                        instruction.accept(clientVisitor, offset2, newOffset);
                    }
                    if (currentProcedureReturnOffsets.isEmpty() || currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1) - 1 != offset2) continue;
                    currentProcedureReturnOffsets.remove(currentProcedureReturnOffsets.size() - 1);
                    continue;
                }
                if (!currentProcedureReturnOffsets.isEmpty()) {
                    int returnOffset = currentProcedureReturnOffsets.get(currentProcedureReturnOffsets.size() - 1);
                    CallInstruction callInstruction = (CallInstruction)instructions.get(returnOffset - 1);
                    ControlFlowStack controlFlowStack = callInstruction.stack;
                    synchronized (controlFlowStack) {
                        if (callInstruction.procBegin <= offset2 && offset2 < callInstruction.procEnd + 2 && (callInstruction.stack.size() == 0 || callInstruction.stack.peekReturnOffset() != returnOffset)) {
                            callInstruction.stack.push(returnOffset, callInstruction);
                        }
                    }
                }
                clientVisitor.processedInstructions[offset2] = true;
                instruction.accept(getNextOffsetVisitor, offset2, newOffset);
            }
        }
    }

    private static boolean isInsideReturnStatement(PsiElement element) {
        while (element instanceof PsiExpression) {
            element = element.getParent();
        }
        return element instanceof PsiReturnStatement;
    }

    private static void merge(int offset2, CopyOnWriteList source2, CopyOnWriteList[] target) {
        if (source2 != null) {
            CopyOnWriteList existing = target[offset2];
            target[offset2] = existing == null ? source2 : existing.addAll(source2);
        }
    }

    public static List<PsiReferenceExpression> getReadBeforeWriteLocals(ControlFlow flow) {
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, true);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return (List)((InstructionClientVisitor)visitor2).getResult();
    }

    public static List<PsiReferenceExpression> getReadBeforeWrite(ControlFlow flow) {
        return ControlFlowUtil.getReadBeforeWrite(flow, 0);
    }

    public static List<PsiReferenceExpression> getReadBeforeWrite(ControlFlow flow, int startOffset) {
        if (startOffset < 0 || startOffset >= flow.getSize()) {
            return Collections.emptyList();
        }
        ReadBeforeWriteClientVisitor visitor2 = new ReadBeforeWriteClientVisitor(flow, false);
        ControlFlowUtil.depthFirstSearch(flow, visitor2);
        return visitor2.getResult(startOffset);
    }

    public static int getCompletionReasons(final ControlFlow flow, final int offset2, final int endOffset) {
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            final boolean[] normalCompletion;
            final boolean[] returnCalled;

            MyVisitor() {
                this.normalCompletion = new boolean[endOffset];
                this.returnCalled = new boolean[endOffset];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset22, int nextOffset) {
                boolean goToReturn;
                boolean ret = nextOffset < endOffset && this.returnCalled[nextOffset];
                boolean normal = nextOffset < endOffset && this.normalCompletion[nextOffset];
                PsiElement element = flow.getElement(offset22);
                boolean bl = goToReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                if (goToReturn || ControlFlowUtil.isInsideReturnStatement(element)) {
                    ret = true;
                } else if (instruction instanceof ConditionalThrowToInstruction) {
                    int throwOffset = ((ConditionalThrowToInstruction)instruction).offset;
                    boolean normalWhenThrow = throwOffset < endOffset && this.normalCompletion[throwOffset];
                    boolean normalWhenNotThrow = offset22 == endOffset - 1 || this.normalCompletion[offset22 + 1];
                    normal = normalWhenThrow || normalWhenNotThrow;
                } else if (!(instruction instanceof ThrowToInstruction) && nextOffset >= endOffset) {
                    normal = true;
                }
                int n = offset22;
                this.returnCalled[n] = this.returnCalled[n] | ret;
                int n2 = offset22;
                this.normalCompletion[n2] = this.normalCompletion[n2] | normal;
            }

            @Override
            public Integer getResult() {
                return (this.returnCalled[offset2] ? 2 : 0) | (this.normalCompletion[offset2] ? 1 : 0);
            }
        }
        MyVisitor visitor2 = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor2, offset2, endOffset);
        return visitor2.getResult();
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(21);
        }
        Collection<VariableInfo> collection = ControlFlowUtil.getInitializedTwice(flow, 0, flow.getSize());
        if (collection == null) {
            ControlFlowUtil.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow, int startOffset, int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(23);
        }
        InitializedTwiceClientVisitor visitor2 = new InitializedTwiceClientVisitor(flow, startOffset);
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, endOffset);
        Object object = visitor2.getResult();
        if (object == null) {
            ControlFlowUtil.$$$reportNull$$$0(24);
        }
        return object;
    }

    public static boolean isInstructionReachable(@NotNull ControlFlow flow, int instructionOffset, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(25);
        }
        return ControlFlowUtil.areInstructionsReachable(flow, new int[]{instructionOffset}, startOffset);
    }

    private static boolean areInstructionsReachable(@NotNull ControlFlow flow, @NotNull int[] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(26);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(27);
        }
        if (startOffset != 0 && ControlFlowUtil.hasCalls(flow)) {
            return ControlFlowUtil.areInstructionsReachableWithCalls(flow, instructionOffsets, startOffset);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            boolean reachable;
            final /* synthetic */ int[] val$instructionOffsets;

            MyVisitor(int[] nArray) {
                this.val$instructionOffsets = nArray;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                this.reachable |= ArrayUtil.indexOf(this.val$instructionOffsets, nextOffset) >= 0;
            }

            @Override
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor2 = new MyVisitor(instructionOffsets);
        ControlFlowUtil.depthFirstSearch(flow, visitor2, startOffset, flow.getSize());
        return visitor2.getResult();
    }

    private static boolean hasCalls(ControlFlow flow) {
        for (Instruction instruction : flow.getInstructions()) {
            if (!(instruction instanceof CallInstruction)) continue;
            return true;
        }
        return false;
    }

    private static boolean areInstructionsReachableWithCalls(@NotNull ControlFlow flow, final @NotNull int[] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(29);
        }
        ControlFlowGraph graph2 = new ControlFlowGraph(flow.getSize()){

            @Override
            boolean isComplete(int offset2, int nextOffset) {
                return ArrayUtil.indexOf(instructionOffsets, nextOffset) >= 0;
            }
        };
        graph2.buildFrom(flow);
        return graph2.depthFirstSearch(startOffset);
    }

    public static boolean isVariableAssignedInLoop(@NotNull PsiReferenceExpression expression2, PsiElement resolved) {
        ControlFlow flow;
        if (expression2 == null) {
            ControlFlowUtil.$$$reportNull$$$0(30);
        }
        if (!(expression2.getParent() instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)expression2.getParent()).getLExpression() != expression2) {
            return false;
        }
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        if (!(resolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable2 = (PsiVariable)resolved;
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable2, expression2);
        if (codeBlock == null) {
            return false;
        }
        try {
            flow = ControlFlowFactory.getInstance(codeBlock.getProject()).getControlFlow(codeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2.getParent();
        int startOffset = flow.getStartOffset(assignmentExpression);
        return startOffset != -1 && ControlFlowUtil.isInstructionReachable(flow, startOffset, startOffset);
    }

    public static boolean isCaughtExceptionType(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(31);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(32);
        }
        return catchType.isAssignableFrom(throwType) || ControlFlowUtil.mightBeAssignableFromSubclass(throwType, catchType);
    }

    private static boolean mightBeAssignableFromSubclass(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(33);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(34);
        }
        if (catchType instanceof PsiDisjunctionType) {
            for (PsiType catchDisjunction : ((PsiDisjunctionType)catchType).getDisjunctions()) {
                if (!throwType.isAssignableFrom(catchDisjunction)) continue;
                return true;
            }
            return false;
        }
        return throwType.isAssignableFrom(catchType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 15: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCodeFragment";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassMember";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionOffsets";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwType";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTryStatementStack";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeFragment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWorldProblemsAtOnce";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedTwice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOffset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOccurrence";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReadInFinally";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasObservableThrowExitPoints";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingTryStatementHavingCatchOrFinally";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectTryStatementStack";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCodeFragment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionScope";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDefinitelyAssigned";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedTwice";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInstructionReachable";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachable";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachableWithCalls";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAssignedInLoop";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isCaughtExceptionType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mightBeAssignableFromSubclass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSingleReadOccurrence$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ControlFlowGraph
    extends InstructionClientVisitor<Void> {
        final int[][] nextOffsets;

        ControlFlowGraph(int size) {
            this.nextOffsets = new int[size][];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.size()) {
                nextOffset = this.size();
            }
            this.addArc(offset2, nextOffset);
        }

        void addArc(int offset2, int nextOffset) {
            if (this.nextOffsets[offset2] == null) {
                this.nextOffsets[offset2] = new int[]{nextOffset, -1};
            } else {
                int[] targets = this.nextOffsets[offset2];
                if (ArrayUtil.indexOf(targets, nextOffset) < 0) {
                    int freeIndex = ArrayUtil.indexOf(targets, -1);
                    if (freeIndex >= 0) {
                        targets[freeIndex] = nextOffset;
                    } else {
                        int oldLength = targets.length;
                        targets = ArrayUtil.realloc(targets, oldLength * 3 / 2);
                        this.nextOffsets[offset2] = targets;
                        Arrays.fill(targets, oldLength, targets.length, -1);
                        targets[oldLength] = nextOffset;
                    }
                }
            }
        }

        @NotNull
        int[] getNextOffsets(int offset2) {
            int[] nArray = this.nextOffsets[offset2] != null ? this.nextOffsets[offset2] : ArrayUtil.EMPTY_INT_ARRAY;
            if (nArray == null) {
                ControlFlowGraph.$$$reportNull$$$0(0);
            }
            return nArray;
        }

        int size() {
            return this.nextOffsets.length;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i2 = 0; i2 < this.nextOffsets.length; ++i2) {
                int[] targets = this.nextOffsets[i2];
                if (targets == null || targets.length == 0 || targets[0] == -1) continue;
                if (s.length() != 0) {
                    s.append(' ');
                }
                s.append('(').append(i2).append("->");
                for (int j = 0; j < targets.length && targets[j] != -1; ++j) {
                    if (j != 0) {
                        s.append(",");
                    }
                    s.append(targets[j]);
                }
                s.append(')');
            }
            return s.toString();
        }

        boolean depthFirstSearch(int startOffset) {
            return this.depthFirstSearch(startOffset, new BitSet(this.size()));
        }

        boolean depthFirstSearch(int startOffset, BitSet visitedOffsets) {
            IntStack walkThroughStack = new IntStack(Math.max(this.size() / 2, 2));
            visitedOffsets.clear();
            walkThroughStack.push(startOffset);
            while (!walkThroughStack.empty()) {
                int[] nextOffsets;
                int currentOffset = walkThroughStack.pop();
                if (currentOffset >= this.size() || visitedOffsets.get(currentOffset)) continue;
                visitedOffsets.set(currentOffset);
                for (int nextOffset : nextOffsets = this.getNextOffsets(currentOffset)) {
                    if (nextOffset == -1) break;
                    if (this.isComplete(currentOffset, nextOffset)) {
                        return true;
                    }
                    walkThroughStack.push(nextOffset);
                }
            }
            return false;
        }

        @Override
        public Void getResult() {
            return null;
        }

        boolean isComplete(int offset2, int nextOffset) {
            return false;
        }

        void buildFrom(ControlFlow flow) {
            ControlFlowUtil.depthFirstSearch(flow, this, 0, flow.getSize());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$ControlFlowGraph", "getNextOffsets"));
        }
    }

    private static class InitializedTwiceClientVisitor
    extends InstructionClientVisitor<Collection<VariableInfo>> {
        private final CopyOnWriteList[] writtenVariables;
        private final CopyOnWriteList[] writtenTwiceVariables;
        private final ControlFlow myFlow;
        private final int myStartOffset;

        public InitializedTwiceClientVisitor(@NotNull ControlFlow flow, int startOffset) {
            if (flow == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.myStartOffset = startOffset;
            this.writtenVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
            this.writtenTwiceVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            int safeNextOffset = Math.min(nextOffset, this.myFlow.getSize());
            CopyOnWriteList writeVars = this.writtenVariables[safeNextOffset];
            CopyOnWriteList writeTwiceVars = this.writtenTwiceVariables[safeNextOffset];
            if (instruction instanceof WriteVariableInstruction) {
                PsiVariable variable2 = ((WriteVariableInstruction)instruction).variable;
                PsiElement latestWriteVarExpression = InitializedTwiceClientVisitor.getLatestWriteVarExpression(writeVars, variable2);
                if (latestWriteVarExpression == null) {
                    PsiElement expression2 = InitializedTwiceClientVisitor.getExpression(this.myFlow.getElement(offset2));
                    writeVars = CopyOnWriteList.add(writeVars, new VariableInfo(variable2, expression2));
                } else {
                    writeTwiceVars = CopyOnWriteList.add(writeTwiceVars, new VariableInfo(variable2, latestWriteVarExpression));
                }
            }
            ControlFlowUtil.merge(offset2, writeVars, this.writtenVariables);
            ControlFlowUtil.merge(offset2, writeTwiceVars, this.writtenTwiceVariables);
        }

        @Nullable
        private static PsiElement getExpression(@NotNull PsiElement element) {
            if (element == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)element).getLExpression() instanceof PsiReferenceExpression) {
                return ((PsiAssignmentExpression)element).getLExpression();
            }
            if (element instanceof PsiUnaryExpression) {
                return ((PsiUnaryExpression)element).getOperand();
            }
            if (element instanceof PsiDeclarationStatement) {
                return element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getLatestWriteVarExpression(@Nullable CopyOnWriteList writeVars, @Nullable PsiVariable variable2) {
            if (writeVars == null) {
                return null;
            }
            for (VariableInfo variableInfo : writeVars.getList()) {
                if (variableInfo.variable != variable2) continue;
                return variableInfo.expression;
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VariableInfo> getResult() {
            CopyOnWriteList writtenTwiceVariable = this.writtenTwiceVariables[this.myStartOffset];
            if (writtenTwiceVariable == null) {
                List<VariableInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    InitializedTwiceClientVisitor.$$$reportNull$$$0(2);
                }
                return list2;
            }
            List<VariableInfo> list3 = writtenTwiceVariable.getList();
            if (list3 == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(3);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpression";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReadBeforeWriteClientVisitor
    extends InstructionClientVisitor<List<PsiReferenceExpression>> {
        private final CopyOnWriteList[] readVariables;
        private final ControlFlow myFlow;
        private final boolean localVariablesOnly;

        public ReadBeforeWriteClientVisitor(ControlFlow flow, boolean localVariablesOnly) {
            this.myFlow = flow;
            this.localVariablesOnly = localVariablesOnly;
            this.readVariables = new CopyOnWriteList[this.myFlow.getSize() + 1];
        }

        @Override
        public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset2, int nextOffset) {
            PsiReferenceExpression expression2;
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            PsiVariable variable2 = instruction.variable;
            if (!(this.localVariablesOnly && ReadBeforeWriteClientVisitor.isMethodParameter(variable2) || (expression2 = ControlFlowUtil.getEnclosingReferenceExpression(this.myFlow.getElement(offset2), variable2)) == null)) {
                readVars = CopyOnWriteList.add(readVars, new VariableInfo(variable2, expression2));
            }
            ControlFlowUtil.merge(offset2, readVars, this.readVariables);
        }

        @Override
        public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
            CopyOnWriteList readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            if (readVars == null) {
                return;
            }
            PsiVariable variable2 = instruction.variable;
            if (!this.localVariablesOnly || !ReadBeforeWriteClientVisitor.isMethodParameter(variable2)) {
                readVars = readVars.remove(new VariableInfo(variable2, null));
            }
            ControlFlowUtil.merge(offset2, readVars, this.readVariables);
        }

        private static boolean isMethodParameter(@NotNull PsiVariable variable2) {
            if (variable2 == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(0);
            }
            if (variable2 instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable2;
                return !(parameter.getDeclarationScope() instanceof PsiForeachStatement);
            }
            return false;
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            ControlFlowUtil.merge(offset2, this.readVariables[Math.min(nextOffset, this.myFlow.getSize())], this.readVariables);
        }

        @Override
        public void visitCallInstruction(CallInstruction instruction, int offset2, int nextOffset) {
            this.visitInstruction(instruction, offset2, nextOffset);
            for (int i2 = instruction.procBegin; i2 <= instruction.procEnd; ++i2) {
                this.readVariables[i2] = null;
            }
        }

        @Override
        public List<PsiReferenceExpression> getResult() {
            return this.getResult(0);
        }

        public List<PsiReferenceExpression> getResult(int startOffset) {
            CopyOnWriteList topReadVariables = this.readVariables[startOffset];
            if (topReadVariables == null) {
                return Collections.emptyList();
            }
            ArrayList<PsiReferenceExpression> result2 = new ArrayList<PsiReferenceExpression>();
            List<VariableInfo> list2 = topReadVariables.getList();
            for (VariableInfo variableInfo : list2) {
                result2.add((PsiReferenceExpression)variableInfo.expression);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor", "isMethodParameter"));
        }
    }

    public static class VariableInfo {
        private final PsiVariable variable;
        public final PsiElement expression;

        public VariableInfo(PsiVariable variable2, PsiElement expression2) {
            this.variable = variable2;
            this.expression = expression2;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof VariableInfo && this.variable.equals(((VariableInfo)o).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }
    }

    private static class CopyOnWriteList {
        private final List<VariableInfo> list;

        public CopyOnWriteList add(VariableInfo value) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            newList.list.add(value);
            return newList;
        }

        public CopyOnWriteList remove(VariableInfo value) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            for (VariableInfo variableInfo : list2) {
                if (value.equals(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        @NotNull
        public List<VariableInfo> getList() {
            List<VariableInfo> list2 = this.list;
            if (list2 == null) {
                CopyOnWriteList.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public CopyOnWriteList() {
            this(Collections.emptyList());
        }

        public CopyOnWriteList(VariableInfo ... infos2) {
            this(Arrays.asList(infos2));
        }

        public CopyOnWriteList(Collection<VariableInfo> infos2) {
            this.list = new SmartList<VariableInfo>(infos2);
        }

        public CopyOnWriteList addAll(CopyOnWriteList addList) {
            CopyOnWriteList newList = new CopyOnWriteList();
            List<VariableInfo> list2 = this.getList();
            newList.list.addAll(list2);
            List<VariableInfo> toAdd = addList.getList();
            for (VariableInfo variableInfo : toAdd) {
                if (newList.list.contains(variableInfo)) continue;
                newList.list.add(variableInfo);
            }
            return newList;
        }

        public static CopyOnWriteList add(@Nullable CopyOnWriteList list2, @NotNull VariableInfo value) {
            if (value == null) {
                CopyOnWriteList.$$$reportNull$$$0(1);
            }
            return list2 == null ? new CopyOnWriteList(value) : list2.add(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$CopyOnWriteList";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WalkThroughStack {
        private int[] oldOffsets;
        private int[] newOffsets;
        private int size;

        WalkThroughStack(int initialSize) {
            if (initialSize < 2) {
                initialSize = 2;
            }
            this.oldOffsets = new int[initialSize];
            this.newOffsets = new int[initialSize];
        }

        void push(int oldOffset, int newOffset) {
            if (this.size >= this.newOffsets.length) {
                this.oldOffsets = ArrayUtil.realloc(this.oldOffsets, this.size * 3 / 2);
                this.newOffsets = ArrayUtil.realloc(this.newOffsets, this.size * 3 / 2);
            }
            this.oldOffsets[this.size] = oldOffset;
            this.newOffsets[this.size] = newOffset;
            ++this.size;
        }

        void push(int offset2) {
            this.push(offset2, -1);
        }

        int peekOldOffset() {
            return this.oldOffsets[this.size - 1];
        }

        int popNewOffset() {
            return this.newOffsets[--this.size];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (s.length() != 0) {
                    s.append(' ');
                }
                if (this.newOffsets[i2] != -1) {
                    s.append('(').append(this.oldOffsets[i2]).append("->").append(this.newOffsets[i2]).append(')');
                    continue;
                }
                s.append('[').append(this.oldOffsets[i2]).append(']');
            }
            return s.toString();
        }
    }

    public static class ControlFlowEdge {
        public final int myFrom;
        public final int myTo;

        public ControlFlowEdge(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        public String toString() {
            return this.myFrom + "->" + this.myTo;
        }
    }

    private static class UnreachableStatementClientVisitor
    extends InstructionClientVisitor<PsiElement> {
        private final ControlFlow myFlow;

        public UnreachableStatementClientVisitor(ControlFlow flow) {
            this.myFlow = flow;
        }

        @Override
        public PsiElement getResult() {
            for (int i2 = 0; i2 < this.processedInstructions.length; ++i2) {
                int startOffset;
                int endOffset;
                if (this.processedInstructions[i2]) continue;
                PsiElement element = this.myFlow.getElement(i2);
                PsiElement unreachableParent = UnreachableStatementClientVisitor.getUnreachableExpressionParent(element);
                if (unreachableParent != null) {
                    return unreachableParent;
                }
                if (element == null || !PsiUtil.isStatement(element) || element.getParent() instanceof PsiExpression) continue;
                while (element instanceof PsiExpression) {
                    element = element.getParent();
                }
                if (element instanceof PsiStatement && element.getParent() instanceof PsiForStatement && element == ((PsiForStatement)element.getParent()).getUpdate() || (endOffset = this.myFlow.getEndOffset(element)) != i2 + 1 || 0 <= (startOffset = this.myFlow.getStartOffset(element)) && startOffset < this.processedInstructions.length && this.processedInstructions[startOffset]) continue;
                PsiElement enclosingStatement = UnreachableStatementClientVisitor.getEnclosingUnreachableStatement(element);
                return enclosingStatement != null ? enclosingStatement : element;
            }
            return null;
        }

        @Nullable
        private static PsiElement getUnreachableExpressionParent(@Nullable PsiElement element) {
            PsiElement expression2;
            if (element instanceof PsiExpression && (expression2 = PsiTreeUtil.findFirstParent(element, e -> !(e.getParent() instanceof PsiParenthesizedExpression))) != null) {
                PsiElement parent2 = expression2.getParent();
                if (parent2 instanceof PsiExpressionStatement) {
                    return UnreachableStatementClientVisitor.getUnreachableStatementParent(parent2);
                }
                if (parent2 instanceof PsiIfStatement && ((PsiIfStatement)parent2).getCondition() == expression2 || parent2 instanceof PsiSwitchStatement && ((PsiSwitchStatement)parent2).getExpression() == expression2 || parent2 instanceof PsiWhileStatement && ((PsiWhileStatement)parent2).getCondition() == expression2 || parent2 instanceof PsiForeachStatement && ((PsiForeachStatement)parent2).getIteratedValue() == expression2) {
                    return parent2;
                }
            }
            return null;
        }

        @Nullable
        private static PsiElement getEnclosingUnreachableStatement(@NotNull PsiElement statement2) {
            PsiElement blockParent;
            PsiBlockStatement blockStatement;
            PsiElement parent2;
            if (statement2 == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(0);
            }
            if ((parent2 = statement2.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)parent2).getBody() == statement2) {
                return parent2;
            }
            if (parent2 instanceof PsiCodeBlock && PsiTreeUtil.getNextSiblingOfType(parent2.getFirstChild(), PsiStatement.class) == statement2 && (blockStatement = ObjectUtils.tryCast(parent2.getParent(), PsiBlockStatement.class)) != null && (blockParent = blockStatement.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)blockParent).getBody() == blockStatement) {
                return blockParent;
            }
            return UnreachableStatementClientVisitor.getUnreachableStatementParent(statement2);
        }

        @Nullable
        private static PsiElement getUnreachableStatementParent(@NotNull PsiElement statement2) {
            PsiElement parent2;
            if (statement2 == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(1);
            }
            if ((parent2 = statement2.getParent()) instanceof PsiForStatement && ((PsiForStatement)parent2).getInitialization() == statement2) {
                return parent2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$UnreachableStatementClientVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnclosingUnreachableStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUnreachableStatementParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnPresentClientVisitor
    extends InstructionClientVisitor<Boolean> {
        private final boolean[] isNormalCompletion;
        protected final ControlFlow myFlow;

        public ReturnPresentClientVisitor(ControlFlow flow) {
            this.myFlow = flow;
            this.isNormalCompletion = new boolean[this.myFlow.getSize() + 1];
            this.isNormalCompletion[this.myFlow.getSize()] = true;
        }

        @Override
        public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = instruction.offset == nextOffset && nextOffset != offset2 + 1 ? !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset] : this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public void visitThrowToInstruction(ThrowToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!instruction.isReturn && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset2;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public Boolean getResult() {
            return !this.isNormalCompletion[0];
        }
    }

    private static class ConvertReturnClientVisitor
    extends ReturnPresentClientVisitor {
        private final List<PsiReturnStatement> myAffectedReturns = new ArrayList<PsiReturnStatement>();
        private final ReturnStatementsVisitor myVisitor;

        ConvertReturnClientVisitor(ControlFlow flow, ReturnStatementsVisitor visitor2) {
            super(flow);
            this.myVisitor = visitor2;
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset2, int nextOffset) {
            PsiElement element;
            super.visitGoToInstruction(instruction, offset2, nextOffset);
            if (instruction.isReturn && (element = this.myFlow.getElement(offset2)) instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                this.myAffectedReturns.add(returnStatement);
            }
        }

        public void afterProcessing() throws IncorrectOperationException {
            this.myVisitor.visit(this.myAffectedReturns);
        }
    }

    private static class SSAInstructionState
    implements Cloneable {
        private final int myWriteCount;
        private final int myInstructionIdx;

        public SSAInstructionState(int writeCount, int instructionIdx) {
            this.myWriteCount = writeCount;
            this.myInstructionIdx = instructionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SSAInstructionState)) {
                return false;
            }
            SSAInstructionState ssaInstructionState = (SSAInstructionState)o;
            if (this.myInstructionIdx != ssaInstructionState.myInstructionIdx) {
                return false;
            }
            return Math.min(2, this.myWriteCount) == Math.min(2, ssaInstructionState.myWriteCount);
        }

        public int hashCode() {
            int result2 = Math.min(2, this.myWriteCount);
            result2 = 29 * result2 + this.myInstructionIdx;
            return result2;
        }

        public int getWriteCount() {
            return this.myWriteCount;
        }

        public int getInstructionIdx() {
            return this.myInstructionIdx;
        }
    }
}

