/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.IdDataConsumer;
import gnu.trove.TObjectIntHashMap;

public final class OccurrenceConsumer {
    private final IdDataConsumer myIndexDataConsumer;
    private TObjectIntHashMap<IndexPattern> myTodoOccurrences;
    private final boolean myNeedToDo;

    public OccurrenceConsumer(IdDataConsumer indexDataConsumer, boolean needToDo) {
        this.myIndexDataConsumer = indexDataConsumer;
        this.myNeedToDo = needToDo;
    }

    public void addOccurrence(CharSequence charSequence, char[] charArray, int start, int end, int occurrenceMask) {
        if (this.myIndexDataConsumer == null) {
            return;
        }
        if (charArray != null) {
            this.myIndexDataConsumer.addOccurrence(charArray, start, end, occurrenceMask);
        } else {
            this.myIndexDataConsumer.addOccurrence(charSequence, start, end, occurrenceMask);
        }
    }

    public void incTodoOccurrence(IndexPattern pattern) {
        if (this.myTodoOccurrences == null) {
            this.myTodoOccurrences = new TObjectIntHashMap();
            for (IndexPattern indexPattern : IndexPatternUtil.getIndexPatterns()) {
                this.myTodoOccurrences.put(indexPattern, 0);
            }
        }
        this.myTodoOccurrences.adjustValue(pattern, 1);
    }

    public int getOccurrenceCount(IndexPattern pattern) {
        if (this.myTodoOccurrences == null) {
            return 0;
        }
        return this.myTodoOccurrences.get(pattern);
    }

    public boolean isNeedToDo() {
        return this.myNeedToDo;
    }
}

