/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringSearcher;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionIndex
extends FileBasedIndexExtension<FunctionalExpressionKey, List<FunExprOccurrence>>
implements PsiDependentIndex {
    public static final ID<FunctionalExpressionKey, List<FunExprOccurrence>> INDEX_ID = ID.create("java.fun.expression");
    private static final KeyDescriptor<FunctionalExpressionKey> KEY_DESCRIPTOR = new KeyDescriptor<FunctionalExpressionKey>(){

        @Override
        public int getHashCode(FunctionalExpressionKey value) {
            return value.hashCode();
        }

        @Override
        public boolean isEqual(FunctionalExpressionKey val1, FunctionalExpressionKey val2) {
            return val1.equals(val2);
        }

        @Override
        public void save(@NotNull DataOutput out, FunctionalExpressionKey value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            value.serializeKey(out);
        }

        @Override
        public FunctionalExpressionKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return FunctionalExpressionKey.deserializeKey(in);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    private static List<ReferenceChainLink> createCallChain(FileLocalResolver resolver2, @Nullable LighterASTNode expr) {
        ArrayList<ReferenceChainLink> chain = new ArrayList<ReferenceChainLink>();
        while (true) {
            if (expr == null) {
                List<ReferenceChainLink> list2 = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list2 == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(0);
                }
                return list2;
            }
            if (expr.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
                expr = LightTreeUtil.firstChildOfType(resolver2.getLightTree(), expr, ElementType.EXPRESSION_BIT_SET);
                continue;
            }
            if (expr.getTokenType() == JavaElementType.TYPE_CAST_EXPRESSION) {
                String typeName = resolver2.getShortClassTypeName(expr);
                ContainerUtil.addIfNotNull(chain, typeName != null ? new ReferenceChainLink(typeName, false, -1) : null);
                List<ReferenceChainLink> list3 = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list3 == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(1);
                }
                return list3;
            }
            boolean isCall = expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || expr.getTokenType() == JavaElementType.NEW_EXPRESSION;
            String referenceName = JavaFunctionalExpressionIndex.getReferencedMemberName(resolver2.getLightTree(), expr, isCall);
            if (referenceName == null) {
                List<ReferenceChainLink> list4 = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list4 == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(2);
                }
                return list4;
            }
            LighterASTNode qualifier = JavaFunctionalExpressionIndex.getQualifier(resolver2.getLightTree(), expr, isCall);
            if (qualifier == null) {
                ContainerUtil.addIfNotNull(chain, JavaFunctionalExpressionIndex.createChainStart(resolver2, expr, isCall, referenceName));
                List<ReferenceChainLink> list5 = JavaFunctionalExpressionIndex.reversedChain(chain);
                if (list5 == null) {
                    JavaFunctionalExpressionIndex.$$$reportNull$$$0(3);
                }
                return list5;
            }
            chain.add(new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver2.getLightTree(), expr)));
            expr = qualifier;
        }
    }

    @NotNull
    private static List<ReferenceChainLink> reversedChain(List<ReferenceChainLink> chain) {
        Collections.reverse(chain);
        List<ReferenceChainLink> list2 = chain;
        if (list2 == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static int getArgCount(LighterAST tree, LighterASTNode expr) {
        List<LighterASTNode> args = JavaLightTreeUtil.getArgList(tree, expr);
        return args == null ? -1 : args.size();
    }

    @Nullable
    private static LighterASTNode getQualifier(LighterAST tree, LighterASTNode expr, boolean isCall) {
        LighterASTNode qualifier = tree.getChildren(expr).get(0);
        if (isCall) {
            List<LighterASTNode> children2 = tree.getChildren(qualifier);
            qualifier = children2.isEmpty() ? null : children2.get(0);
        }
        return qualifier != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getTokenType()) ? qualifier : null;
    }

    @Nullable
    private static String getReferencedMemberName(LighterAST tree, LighterASTNode expr, boolean isCall) {
        if (isCall) {
            return JavaFunctionalExpressionIndex.getCalledMethodName(tree, expr);
        }
        if (expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, expr);
        }
        return null;
    }

    @Nullable
    private static ReferenceChainLink createChainStart(FileLocalResolver resolver2, LighterASTNode expr, boolean isCall, String referenceName) {
        if (!isCall) {
            FileLocalResolver.LightResolveResult result2 = resolver2.resolveLocally(expr);
            if (result2 == FileLocalResolver.LightResolveResult.UNKNOWN) {
                return null;
            }
            LighterASTNode target = result2.getTarget();
            if (target != null) {
                String typeName = resolver2.getShortClassTypeName(target);
                return typeName != null ? new ReferenceChainLink(typeName, false, -1) : null;
            }
        }
        return new ReferenceChainLink(referenceName, isCall, JavaFunctionalExpressionIndex.getArgCount(resolver2.getLightTree(), expr));
    }

    @NotNull
    private static String calcExprType(LighterASTNode funExpr, FileLocalResolver resolver2) {
        LighterASTNode scope = JavaFunctionalExpressionIndex.skipExpressionsUp(resolver2.getLightTree(), funExpr, TokenSet.create(JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD, JavaElementType.TYPE_CAST_EXPRESSION, JavaElementType.RETURN_STATEMENT, JavaElementType.ASSIGNMENT_EXPRESSION));
        if (scope != null) {
            if (scope.getTokenType() == JavaElementType.ASSIGNMENT_EXPRESSION) {
                LighterASTNode lValue = JavaFunctionalExpressionIndex.findExpressionChild(scope, resolver2.getLightTree());
                scope = lValue == null ? null : resolver2.resolveLocally(lValue).getTarget();
            } else if (scope.getTokenType() == JavaElementType.RETURN_STATEMENT) {
                scope = LightTreeUtil.getParentOfType(resolver2.getLightTree(), scope, TokenSet.create(JavaElementType.METHOD), TokenSet.orSet(ElementType.MEMBER_BIT_SET, TokenSet.create(JavaElementType.LAMBDA_EXPRESSION)));
            }
        }
        String string = StringUtil.notNullize(scope == null ? null : resolver2.getShortClassTypeName(scope));
        if (string == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static int getArgIndex(List<LighterASTNode> args, LighterASTNode expr) {
        for (int i2 = 0; i2 < args.size(); ++i2) {
            if (args.get(i2).getEndOffset() < expr.getEndOffset()) continue;
            return i2;
        }
        return -1;
    }

    private static FunctionalExpressionKey.CoarseType calcReturnType(final LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        LighterASTNode block = LightTreeUtil.firstChildOfType(tree, funExpr, JavaElementType.CODE_BLOCK);
        if (block == null) {
            LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(funExpr, tree);
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr) ? FunctionalExpressionKey.CoarseType.BOOLEAN : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        final Ref<Object> returnsSomething = Ref.create(null);
        final AtomicBoolean isBoolean = new AtomicBoolean();
        final AtomicBoolean hasStatements = new AtomicBoolean();
        new RecursiveLighterASTNodeWalkingVisitor(tree){

            @Override
            public void visitNode(@NotNull LighterASTNode element) {
                IElementType type2;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((type2 = element.getTokenType()) == JavaElementType.LAMBDA_EXPRESSION || ElementType.MEMBER_BIT_SET.contains(type2)) {
                    return;
                }
                if (type2 == JavaElementType.RETURN_STATEMENT) {
                    LighterASTNode expr = JavaFunctionalExpressionIndex.findExpressionChild(element, tree);
                    returnsSomething.set(expr != null);
                    if (JavaFunctionalExpressionIndex.isBooleanExpression(tree, expr)) {
                        isBoolean.set(true);
                    }
                    return;
                }
                if (type2 == JavaElementType.EXPRESSION_STATEMENT) {
                    hasStatements.set(true);
                }
                super.visitNode(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$2", "visitNode"));
            }
        }.visitNode(block);
        if (isBoolean.get()) {
            return FunctionalExpressionKey.CoarseType.BOOLEAN;
        }
        if (returnsSomething.isNull()) {
            return hasStatements.get() ? FunctionalExpressionKey.CoarseType.VOID : FunctionalExpressionKey.CoarseType.UNKNOWN;
        }
        return (Boolean)returnsSomething.get() != false ? FunctionalExpressionKey.CoarseType.NON_VOID : FunctionalExpressionKey.CoarseType.VOID;
    }

    @Nullable
    private static LighterASTNode findExpressionChild(@NotNull LighterASTNode element, LighterAST tree) {
        if (element == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(6);
        }
        return LightTreeUtil.firstChildOfType(tree, element, ElementType.EXPRESSION_BIT_SET);
    }

    private static boolean isBooleanExpression(LighterAST tree, @Nullable LighterASTNode expr) {
        if (expr == null) {
            return false;
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.LITERAL_EXPRESSION) {
            IElementType child = tree.getChildren(expr).get(0).getTokenType();
            return child == JavaTokenType.TRUE_KEYWORD || child == JavaTokenType.FALSE_KEYWORD;
        }
        if (type2 == JavaElementType.POLYADIC_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION) {
            return LightTreeUtil.firstChildOfType(tree, expr, PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS) != null;
        }
        if (type2 == JavaElementType.PREFIX_EXPRESSION) {
            return tree.getChildren(expr).get(0).getTokenType() == JavaTokenType.EXCL;
        }
        if (type2 == JavaElementType.PARENTH_EXPRESSION) {
            return JavaFunctionalExpressionIndex.isBooleanExpression(tree, JavaFunctionalExpressionIndex.findExpressionChild(expr, tree));
        }
        if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children2 = LightTreeUtil.getChildrenOfType(tree, expr, ElementType.EXPRESSION_BIT_SET);
            return children2.size() == 3 && (JavaFunctionalExpressionIndex.isBooleanExpression(tree, children2.get(1)) || JavaFunctionalExpressionIndex.isBooleanExpression(tree, children2.get(2)));
        }
        return false;
    }

    private static int getFunExprParameterCount(LighterAST tree, LighterASTNode funExpr) {
        if (funExpr.getTokenType() == JavaElementType.METHOD_REF_EXPRESSION) {
            return -1;
        }
        assert (funExpr.getTokenType() == JavaElementType.LAMBDA_EXPRESSION);
        LighterASTNode paramList = LightTreeUtil.firstChildOfType(tree, funExpr, JavaElementType.PARAMETER_LIST);
        assert (paramList != null);
        return LightTreeUtil.getChildrenOfType(tree, paramList, Constants.PARAMETER_BIT_SET).size();
    }

    @Nullable
    private static String getCalledMethodName(LighterAST tree, LighterASTNode call2) {
        if (call2.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            LighterASTNode anonClass = LightTreeUtil.firstChildOfType(tree, call2, JavaElementType.ANONYMOUS_CLASS);
            LighterASTNode ref = LightTreeUtil.firstChildOfType(tree, anonClass != null ? anonClass : call2, JavaElementType.JAVA_CODE_REFERENCE);
            return ref == null ? null : JavaLightTreeUtil.getNameIdentifierText(tree, ref);
        }
        LighterASTNode methodExpr = tree.getChildren(call2).get(0);
        if (LightTreeUtil.firstChildOfType(tree, methodExpr, JavaTokenType.SUPER_KEYWORD) != null) {
            return JavaFunctionalExpressionIndex.getSuperClassName(tree, call2);
        }
        if (LightTreeUtil.firstChildOfType(tree, methodExpr, JavaTokenType.THIS_KEYWORD) != null) {
            return JavaLightTreeUtil.getNameIdentifierText(tree, JavaFunctionalExpressionIndex.findClass(tree, call2));
        }
        return JavaLightTreeUtil.getNameIdentifierText(tree, methodExpr);
    }

    @Nullable
    private static String getSuperClassName(LighterAST tree, LighterASTNode call2) {
        LighterASTNode aClass2 = JavaFunctionalExpressionIndex.findClass(tree, call2);
        return JavaFunctionalExpressionIndex.getReferenceName(tree, LightTreeUtil.firstChildOfType(tree, aClass2, JavaElementType.EXTENDS_LIST));
    }

    @Nullable
    private static String getReferenceName(LighterAST tree, LighterASTNode refParent) {
        return JavaLightTreeUtil.getNameIdentifierText(tree, LightTreeUtil.firstChildOfType(tree, refParent, JavaElementType.JAVA_CODE_REFERENCE));
    }

    @Nullable
    private static LighterASTNode getContainingCall(LighterAST tree, LighterASTNode node) {
        LighterASTNode expressionList = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, node, TokenSet.create(JavaElementType.EXPRESSION_LIST));
        if (expressionList != null) {
            LighterASTNode parent2 = tree.getParent(expressionList);
            if (parent2 != null && parent2.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
                parent2 = tree.getParent(parent2);
            }
            if (parent2 != null && (parent2.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION || parent2.getTokenType() == JavaElementType.NEW_EXPRESSION)) {
                return parent2;
            }
        }
        return null;
    }

    private static LighterASTNode skipExpressionsUp(LighterAST tree, @NotNull LighterASTNode node, TokenSet types) {
        if (node == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(7);
        }
        node = tree.getParent(node);
        while (node != null) {
            IElementType type2 = node.getTokenType();
            if (types.contains(type2)) {
                return node;
            }
            if (type2 != JavaElementType.PARENTH_EXPRESSION && type2 != JavaElementType.CONDITIONAL_EXPRESSION) {
                return null;
            }
            node = tree.getParent(node);
        }
        return null;
    }

    private static LighterASTNode findClass(LighterAST tree, LighterASTNode node) {
        return JBIterable.generate(node, tree::getParent).find(n -> n.getTokenType() == JavaElementType.CLASS);
    }

    @Override
    @NotNull
    public KeyDescriptor<FunctionalExpressionKey> getKeyDescriptor() {
        KeyDescriptor<FunctionalExpressionKey> keyDescriptor = KEY_DESCRIPTOR;
        if (keyDescriptor == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(8);
        }
        return keyDescriptor;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    @NotNull
    public ID<FunctionalExpressionKey, List<FunExprOccurrence>> getName() {
        ID<FunctionalExpressionKey, List<FunExprOccurrence>> iD = INDEX_ID;
        if (iD == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(9);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<FunctionalExpressionKey, List<FunExprOccurrence>, FileContent> getIndexer() {
        DataIndexer<FunctionalExpressionKey, List<FunExprOccurrence>, FileContent> dataIndexer = inputData -> {
            CharSequence text2 = inputData.getContentAsText();
            int[] offsets = ArrayUtil.mergeArrays(new StringSearcher("->", true, true).findAllOccurrences(text2), new StringSearcher("::", true, true).findAllOccurrences(text2));
            if (offsets.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<FunctionalExpressionKey, SmartList<FunExprOccurrence>> result2 = new HashMap<FunctionalExpressionKey, SmartList<FunExprOccurrence>>();
            LighterAST tree = ((FileContentImpl)inputData).getLighterASTForPsiDependentIndex();
            FileLocalResolver resolver2 = new FileLocalResolver(tree);
            for (int offset2 : offsets) {
                LighterASTNode element;
                LighterASTNode leaf = LightTreeUtil.findLeafElementAt(tree, offset2);
                LighterASTNode lighterASTNode = element = leaf == null ? null : tree.getParent(leaf);
                if (element == null || element.getTokenType() != JavaElementType.METHOD_REF_EXPRESSION && element.getTokenType() != JavaElementType.LAMBDA_EXPRESSION) continue;
                FunctionalExpressionKey key = new FunctionalExpressionKey(JavaFunctionalExpressionIndex.getFunExprParameterCount(tree, element), JavaFunctionalExpressionIndex.calcReturnType(tree, element), JavaFunctionalExpressionIndex.calcExprType(element, resolver2));
                SmartList<FunExprOccurrence> list2 = (SmartList<FunExprOccurrence>)result2.get(key);
                if (list2 == null) {
                    list2 = new SmartList<FunExprOccurrence>();
                    result2.put(key, list2);
                }
                list2.add(JavaFunctionalExpressionIndex.createOccurrence(element, resolver2));
            }
            return result2;
        };
        if (dataIndexer == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(10);
        }
        return dataIndexer;
    }

    @NotNull
    private static FunExprOccurrence createOccurrence(@NotNull LighterASTNode funExpr, FileLocalResolver resolver2) {
        LighterASTNode assignment;
        LighterASTNode containingCall;
        LighterAST tree;
        List<LighterASTNode> args;
        if (funExpr == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(11);
        }
        int argIndex = (args = JavaLightTreeUtil.getArgList(tree = resolver2.getLightTree(), containingCall = JavaFunctionalExpressionIndex.getContainingCall(tree, funExpr))) == null ? -1 : JavaFunctionalExpressionIndex.getArgIndex(args, funExpr);
        LighterASTNode chainExpr = containingCall;
        if (chainExpr == null && (assignment = JavaFunctionalExpressionIndex.skipExpressionsUp(tree, funExpr, TokenSet.create(JavaElementType.ASSIGNMENT_EXPRESSION))) != null) {
            chainExpr = JavaFunctionalExpressionIndex.findExpressionChild(assignment, tree);
        }
        FunExprOccurrence funExprOccurrence = new FunExprOccurrence(funExpr.getStartOffset(), argIndex, JavaFunctionalExpressionIndex.createCallChain(resolver2, chainExpr));
        if (funExprOccurrence == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(12);
        }
        return funExprOccurrence;
    }

    @Override
    @NotNull
    public DataExternalizer<List<FunExprOccurrence>> getValueExternalizer() {
        DataExternalizer<List<FunExprOccurrence>> dataExternalizer = new DataExternalizer<List<FunExprOccurrence>>(){

            @Override
            public void save(@NotNull DataOutput out, List<FunExprOccurrence> value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT(out, value.size());
                for (FunExprOccurrence info : value) {
                    info.serialize(out);
                }
            }

            @Override
            public List<FunExprOccurrence> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                int length = DataInputOutputUtil.readINT(in);
                SmartList<FunExprOccurrence> list2 = new SmartList<FunExprOccurrence>();
                for (int i2 = 0; i2 < length; ++i2) {
                    list2.add(FunExprOccurrence.deserialize(in));
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(13);
        }
        return dataExternalizer;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            @Override
            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file2) && JavaFileElementType.isInSourceContent(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex$4", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            JavaFunctionalExpressionIndex.$$$reportNull$$$0(14);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallChain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reversedChain";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExprType";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/JavaFunctionalExpressionIndex";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createOccurrence";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipExpressionsUp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createOccurrence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

