/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();
    private static final Pattern MULTI_RESOLVE_VERSION = Pattern.compile("/META-INF/versions/([^/]+)/module-info.class");

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    @Override
    public int getVersion() {
        return super.getVersion() + (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping ? 2 : 0);
    }

    @Override
    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        StubIndexKey<String, PsiJavaModule> stubIndexKey = JavaStubIndexKeys.MODULE_NAMES;
        if (stubIndexKey == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    @Override
    public Collection<PsiJavaModule> get(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules;
        if (name == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(3);
        }
        if ((modules = StubIndex.getElements(this.getKey(), name, project, new JavaSourceFilterScope(scope, true), PsiJavaModule.class)).size() > 1) {
            modules = JavaModuleNameIndex.filterVersions(project, modules);
        }
        return modules;
    }

    private static Collection<PsiJavaModule> filterVersions(Project project, Collection<PsiJavaModule> modules) {
        HashMap<VirtualFile, PsiJavaModule> filter2 = ContainerUtil.newHashMap();
        HashSet screened = ContainerUtil.newHashSet();
        ProjectFileIndex index2 = ProjectFileIndex.SERVICE.getInstance(project);
        for (PsiJavaModule module3 : modules) {
            VirtualFile classRoot;
            VirtualFile file2 = module3.getContainingFile().getVirtualFile();
            if (!index2.isInLibraryClasses(file2) || (classRoot = index2.getClassRootForFile(file2)) == null) continue;
            PsiJavaModule previous = (PsiJavaModule)filter2.get(classRoot);
            if (previous == null) {
                filter2.put(classRoot, module3);
                continue;
            }
            if (StringUtil.compareVersionNumbers(JavaModuleNameIndex.fileVersion(file2), JavaModuleNameIndex.fileVersion(previous.getContainingFile().getVirtualFile())) < 0) {
                filter2.put(classRoot, module3);
                screened.add(previous);
                continue;
            }
            screened.add(module3);
        }
        return screened.isEmpty() ? modules : (Collection)modules.stream().filter(module2 -> !screened.contains(module2)).collect(Collectors.toList());
    }

    private static String fileVersion(VirtualFile file2) {
        Matcher matcher = MULTI_RESOLVE_VERSION.matcher(file2.getPath());
        return matcher.find() ? matcher.group(1) : "0";
    }

    @Override
    public boolean traceKeyHashToVirtualFileMapping() {
        return FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

