/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AnnotatedPackagesSearcher
implements QueryExecutor<PsiPackage, AnnotatedPackagesSearch.Parameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.AnnotatedPackagesSearcher");

    @Override
    public boolean execute(@NotNull AnnotatedPackagesSearch.Parameters p2, @NotNull Processor<PsiPackage> consumer) {
        if (p2 == null) {
            AnnotatedPackagesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AnnotatedPackagesSearcher.$$$reportNull$$$0(1);
        }
        PsiClass annClass = p2.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated packages search";
        String annotationFQN = ReadAction.compute(() -> annClass.getQualifiedName());
        assert (annotationFQN != null);
        PsiManager psiManager = ReadAction.compute(() -> annClass.getManager());
        GlobalSearchScope useScope = (GlobalSearchScope)p2.getScope();
        String annotationShortName = ReadAction.compute(() -> annClass.getName());
        assert (annotationShortName != null);
        Collection<PsiAnnotation> annotations2 = JavaAnnotationIndex.getInstance().get(annotationShortName, psiManager.getProject(), useScope);
        for (PsiAnnotation annotation2 : annotations2) {
            boolean accepted = ReadAction.compute(() -> {
                PsiClass candidate2;
                PsiModifierList modList;
                PsiElement owner;
                if (consumer == null) {
                    AnnotatedPackagesSearcher.$$$reportNull$$$0(3);
                }
                if ((owner = (modList = (PsiModifierList)annotation2.getParent()).getParent()) instanceof PsiClass && "package-info".equals((candidate2 = (PsiClass)owner).getName())) {
                    String qname;
                    LOG.assertTrue(candidate2.isValid());
                    PsiJavaCodeReferenceElement ref = annotation2.getNameReferenceElement();
                    if (ref != null && psiManager.areElementsEquivalent(ref.resolve(), annClass) && useScope.contains(candidate2.getContainingFile().getVirtualFile()) && (qname = candidate2.getQualifiedName()) != null && !consumer.process(JavaPsiFacade.getInstance(psiManager.getProject()).findPackage(qname.substring(0, qname.lastIndexOf(46))))) {
                        return false;
                    }
                }
                return true;
            });
            if (accepted) continue;
            return false;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance(psiManager.getProject());
        PackageInfoFilesOnly infoFilesFilter = new PackageInfoFilesOnly();
        GlobalSearchScope infoFiles = useScope.intersectWith(infoFilesFilter);
        boolean[] wantMore = new boolean[]{true};
        helper.processAllFilesWithWord(annotationShortName, infoFiles, psiFile -> {
            PsiPackageStatement stmt;
            if (consumer == null) {
                AnnotatedPackagesSearcher.$$$reportNull$$$0(2);
            }
            if ((stmt = PsiTreeUtil.getChildOfType(psiFile, PsiPackageStatement.class)) == null) {
                return true;
            }
            PsiModifierList annotations1 = stmt.getAnnotationList();
            if (annotations1 == null) {
                return true;
            }
            PsiAnnotation ann = annotations1.findAnnotation(annotationFQN);
            if (ann == null) {
                return true;
            }
            PsiJavaCodeReferenceElement ref = ann.getNameReferenceElement();
            if (ref == null) {
                return true;
            }
            if (!psiManager.areElementsEquivalent(ref.resolve(), annClass)) {
                return true;
            }
            wantMore[0] = consumer.process(JavaPsiFacade.getInstance(psiManager.getProject()).findPackage(stmt.getPackageName()));
            return wantMore[0];
        }, true);
        return wantMore[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/AnnotatedPackagesSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$4";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PackageInfoFilesOnly
    extends GlobalSearchScope {
        private PackageInfoFilesOnly() {
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(1);
            }
            return 0;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(2);
            }
            return "package-info.java".equals(file2.getName());
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                PackageInfoFilesOnly.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/search/AnnotatedPackagesSearcher$PackageInfoFilesOnly";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

