/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.NullFileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.net.URI;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReference
implements PsiFileReference,
FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
BindablePsiReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference");
    public static final FileReference[] EMPTY = new FileReference[0];
    private final int myIndex;
    private TextRange myRange;
    private final String myText;
    @NotNull
    private final FileReferenceSet myFileReferenceSet;

    public FileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index2, String text2) {
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(0);
        }
        this.myFileReferenceSet = fileReferenceSet;
        this.myIndex = index2;
        this.myRange = range;
        this.myText = text2;
    }

    public FileReference(FileReference original) {
        this(original.myFileReferenceSet, original.myRange, original.myIndex, original.myText);
    }

    @Nullable
    public static FileReference findFileReference(@NotNull PsiReference original) {
        PsiFileReference fileReference;
        if (original == null) {
            FileReference.$$$reportNull$$$0(1);
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                return (FileReference)reference;
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = ((FileReferenceOwner)((Object)original)).getLastFileReference()) instanceof FileReference) {
            return (FileReference)fileReference;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        FileReference contextRef = this.getContextReference();
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>();
        if (contextRef == null) {
            Collection<PsiFileSystemItem> defaultContexts = this.myFileReferenceSet.getDefaultContexts();
            for (PsiFileSystemItem context : defaultContexts) {
                if (context != null) continue;
                LOG.error(this.myFileReferenceSet.getClass() + " provided a null context");
            }
            result2.addAll(defaultContexts);
        } else {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = contextRef.multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add((PsiFileSystemItem)resolveResult.getElement());
            }
        }
        result2.addAll(this.myFileReferenceSet.getExtraContexts());
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            FileReference.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(file2.getProject()).resolveWithCaching(this, MyResolver.INSTANCE, false, false, file2);
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        String referenceText;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(4);
        }
        if ((referenceText = this.getText()).isEmpty() && this.myIndex == 0) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(containingFile)};
            if (resolveResultArray == null) {
                FileReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        Collection<PsiFileSystemItem> contexts = this.getContexts();
        THashSet<ResolveResult> result2 = new THashSet<ResolveResult>();
        for (PsiFileSystemItem context : contexts) {
            this.innerResolveInContext(referenceText, context, result2, caseSensitive);
        }
        if (contexts.isEmpty() && this.isAllowedEmptyPath(referenceText)) {
            result2.add(new PsiElementResolveResult(containingFile));
        }
        ResolveResult[] resolveResultArray = (resultCount = result2.size()) > 0 ? result2.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(6);
        }
        return resolveResultArray;
    }

    protected void innerResolveInContext(@NotNull String text2, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result2, final boolean caseSensitive) {
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(7);
        }
        if (context == null) {
            FileReference.$$$reportNull$$$0(8);
        }
        if (this.isAllowedEmptyPath(text2) || ".".equals(text2) || "/".equals(text2)) {
            if (context instanceof FileReferenceResolver) {
                ContainerUtil.addIfNotNull(result2, this.resolveFileReferenceResolver((FileReferenceResolver)((Object)context), text2));
                return;
            }
            result2.add(new PsiElementResolveResult(context));
        } else if ("..".equals(text2)) {
            if (context instanceof FileReferenceResolver) {
                ContainerUtil.addIfNotNull(result2, this.resolveFileReferenceResolver((FileReferenceResolver)((Object)context), text2));
                return;
            }
            PsiFileSystemItem resolved = context.getParent();
            if (resolved != null) {
                result2.add(new PsiElementResolveResult(resolved));
            }
        } else {
            int separatorIndex = text2.indexOf(47);
            if (separatorIndex >= 0) {
                ArrayList<ResolveResult> resolvedContexts = new ArrayList<ResolveResult>();
                if (separatorIndex == 0 && "/".equals(context.getName())) {
                    resolvedContexts.add(new PsiElementResolveResult(context));
                } else {
                    this.innerResolveInContext(text2.substring(0, separatorIndex), context, resolvedContexts, caseSensitive);
                }
                String restOfText = text2.substring(separatorIndex + 1);
                for (ResolveResult contextVariant : resolvedContexts) {
                    PsiFileSystemItem item = (PsiFileSystemItem)contextVariant.getElement();
                    if (item == null) continue;
                    this.innerResolveInContext(restOfText, item, result2, caseSensitive);
                }
            } else {
                ResolveResult child;
                final String decoded = this.decode(text2);
                if (context instanceof PackagePrefixFileSystemItem) {
                    context = ((PackagePrefixFileSystemItem)context).getDirectory();
                } else if (context instanceof FileReferenceResolver && (child = this.resolveFileReferenceResolver((FileReferenceResolver)((Object)context), decoded)) != null) {
                    result2.add(child);
                    return;
                }
                if (context.getParent() == null && FileUtil.namesEqual(decoded, context.getName())) {
                    result2.add(new PsiElementResolveResult(FileReference.getOriginalFile(context)));
                } else if (context instanceof PsiDirectory && FileReference.caseSensitivityApplies((PsiDirectory)context, caseSensitive)) {
                    PsiDirectory directory = (PsiDirectory)context;
                    PsiFileSystemItem child2 = directory.findFile(decoded);
                    if (child2 == null) {
                        child2 = directory.findSubdirectory(decoded);
                    }
                    if (child2 != null) {
                        result2.add(new PsiElementResolveResult(FileReference.getOriginalFile(child2)));
                    }
                } else {
                    FileReference.processVariants(context, new PsiFileSystemItemProcessor(){

                        @Override
                        public boolean acceptItem(String name, boolean isDirectory) {
                            return caseSensitive ? decoded.equals(name) : decoded.compareToIgnoreCase(name) == 0;
                        }

                        @Override
                        public boolean execute(@NotNull PsiFileSystemItem element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            result2.add(new PsiElementResolveResult(FileReference.getOriginalFile(element)));
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$1", "execute"));
                        }
                    });
                }
            }
        }
    }

    @NotNull
    public String getFileNameToCreate() {
        String string = this.decode(this.getCanonicalText());
        if (string == null) {
            FileReference.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getNewFileTemplateName() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(this.myText);
        if (fileType != UnknownFileType.INSTANCE) {
            return fileType.getName() + " File." + fileType.getDefaultExtension();
        }
        return null;
    }

    @Nullable
    private ResolveResult resolveFileReferenceResolver(@NotNull FileReferenceResolver fileReferenceResolver, @NotNull String text2) {
        PsiFileSystemItem resolve2;
        if (fileReferenceResolver == null) {
            FileReference.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(11);
        }
        return (resolve2 = fileReferenceResolver.resolveFileReference(this, text2)) != null ? new PsiElementResolveResult(FileReference.getOriginalFile(resolve2)) : null;
    }

    private static boolean caseSensitivityApplies(PsiDirectory context, boolean caseSensitive) {
        VirtualFileSystem fs = context.getVirtualFile().getFileSystem();
        return fs.isCaseSensitive() == caseSensitive;
    }

    private boolean isAllowedEmptyPath(String text2) {
        return text2.isEmpty() && this.isLast() && (StringUtil.isEmpty(this.myFileReferenceSet.getPathString()) && this.myFileReferenceSet.isEmptyPathAllowed() || !this.myFileReferenceSet.isEndingSlashNotAllowed() && this.myIndex > 0);
    }

    @NotNull
    public String decode(@NotNull String text2) {
        if (text2 == null) {
            FileReference.$$$reportNull$$$0(12);
        }
        if (SystemInfo.isMac) {
            text2 = Normalizer.normalize(text2, Normalizer.Form.NFC);
        }
        String _text = text2;
        int paramIndex = text2.lastIndexOf(63);
        if (paramIndex >= 0) {
            _text = text2.substring(0, paramIndex);
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            String string;
            try {
                string = StringUtil.notNullize(new URI(_text).getPath(), text2);
            }
            catch (Exception ignored) {
                String string2 = text2;
                if (string2 == null) {
                    FileReference.$$$reportNull$$$0(14);
                }
                return string2;
            }
            if (string == null) {
                FileReference.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = _text;
        if (string == null) {
            FileReference.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        FileReferenceCompletion completion = FileReferenceCompletion.getInstance();
        if (completion != null) {
            Object[] objectArray = completion.getFileReferenceCompletionVariants(this);
            if (objectArray == null) {
                FileReference.$$$reportNull$$$0(16);
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            FileReference.$$$reportNull$$$0(17);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    protected Object createLookupItem(PsiElement candidate2) {
        return null;
    }

    protected static PsiFileSystemItem getOriginalFile(PsiFileSystemItem fileSystemItem) {
        PsiFile psiFile;
        PsiManager psiManager;
        VirtualFile file2 = fileSystemItem.getVirtualFile();
        if (file2 != null && !file2.isDirectory() && (psiManager = fileSystemItem.getManager()) != null && (psiFile = psiManager.findFile(file2)) != null) {
            fileSystemItem = psiFile;
        }
        return fileSystemItem;
    }

    @Nullable
    protected String encode(String name, PsiElement psiElement) {
        try {
            return new URI(null, null, name, null).toString();
        }
        catch (Exception ignored) {
            return name;
        }
    }

    protected static void processVariants(PsiFileSystemItem context, PsiFileSystemItemProcessor processor) {
        context.processChildren(processor);
    }

    @Nullable
    private FileReference getContextReference() {
        return this.myIndex > 0 ? this.myFileReferenceSet.getReference(this.myIndex - 1) : null;
    }

    @Override
    public PsiElement getElement() {
        return this.myFileReferenceSet.getElement();
    }

    @Override
    public PsiFileSystemItem resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem innerSingleResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        ResolveResult[] resolveResults;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(18);
        }
        return (resolveResults = this.innerResolve(caseSensitive, containingFile)).length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiFileSystemItem item = this.resolve();
        return item != null && FileReferenceHelperRegistrar.areElementsEquivalent(item, (PsiFileSystemItem)element);
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            FileReference.$$$reportNull$$$0(19);
        }
        return string;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public boolean isSoft() {
        return this.myFileReferenceSet.isSoft();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<PsiElement> manipulator = CachingReference.getManipulator(this.getElement());
        this.myFileReferenceSet.setElement(manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName));
        int delta = newElementName.length() - this.myRange.getLength();
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        FileReference[] references = this.myFileReferenceSet.getAllReferences();
        for (int idx = this.myIndex + 1; idx < references.length; ++idx) {
            references[idx].myRange = references[idx].myRange.shiftRight(delta);
        }
        return this.myFileReferenceSet.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newName2;
        VirtualFile curVFile;
        if (element == null) {
            FileReference.$$$reportNull$$$0(20);
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
        }
        if (this.getCanonicalText().isEmpty() && element == this.getElement().getContainingFile()) {
            return this.getElement();
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        PsiFile file2 = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance(file2.getProject()).getInjectionHost(file2);
        if (contextPsiFile != null) {
            file2 = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file2.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + file2);
        }
        Project project = element.getProject();
        if (absolute) {
            String relativePath;
            PsiFileSystemItem root2 = null;
            PsiFileSystemItem dstItem = null;
            for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem;
                if (!helper.isMine(project, dstVFile) || (_dstItem = helper.getPsiFileSystemItem(project, dstVFile)) == null || (_root = helper.findRoot(project, dstVFile)) == null) continue;
                root2 = _root;
                dstItem = _dstItem;
                break;
            }
            if (root2 == null) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem = NullFileReferenceHelper.INSTANCE.getPsiFileSystemItem(project, dstVFile);
                if (_dstItem != null && (_root = NullFileReferenceHelper.INSTANCE.findRoot(project, dstVFile)) != null) {
                    root2 = _root;
                    dstItem = _dstItem;
                }
                if (root2 == null) {
                    return this.getElement();
                }
            }
            if ((relativePath = PsiFileSystemItemUtil.getRelativePath(root2, dstItem)) == null) {
                return this.getElement();
            }
            newName2 = this.myFileReferenceSet.getNewAbsolutePath(root2, relativePath);
        } else {
            FileReferenceHelper helper = FileReferenceHelperRegistrar.getNotNullHelper(file2);
            Collection<PsiFileSystemItem> contexts = this.getContextsForBindToElement(curVFile, project, helper);
            for (PsiFileSystemItem context : contexts) {
                String path2;
                VirtualFile contextFile = context.getVirtualFile();
                assert (contextFile != null);
                if (!VfsUtilCore.isAncestor(contextFile, dstVFile, true) || (path2 = VfsUtilCore.getRelativePath(dstVFile, contextFile, '/')) == null) continue;
                return this.rename(path2);
            }
            PsiFileSystemItem dstItem = helper.getPsiFileSystemItem(project, dstVFile);
            PsiFileSystemItem curItem = helper.getPsiFileSystemItem(project, curVFile);
            if (curItem == null) {
                throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; dst = " + dstVFile.getPresentableUrl() + "; Contexts: " + contexts);
            }
            if (curItem.equals(dstItem)) {
                if (this.getCanonicalText().equals(dstItem.getName())) {
                    return this.getElement();
                }
                return this.fixRefText(file2.getName());
            }
            newName2 = PsiFileSystemItemUtil.getRelativePath(curItem, dstItem);
            if (newName2 == null) {
                return this.getElement();
            }
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            newName2 = this.encode(newName2, element);
        }
        return this.rename(newName2);
    }

    protected Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project, FileReferenceHelper helper) {
        return helper.getContexts(project, curVFile);
    }

    protected PsiElement fixRefText(String name) {
        return ElementManipulators.getManipulator(this.getElement()).handleContentChange(this.getElement(), this.getRangeInElement(), name);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            FileReference.$$$reportNull$$$0(21);
        }
        return this.bindToElement(element, this.myFileReferenceSet.isAbsolutePathReference());
    }

    protected PsiElement rename(String newName2) throws IncorrectOperationException {
        TextRange range = new TextRange(this.myFileReferenceSet.getStartInElement(), this.getRangeInElement().getEndOffset());
        PsiElement element = this.getElement();
        try {
            return CachingReference.getManipulator(element).handleContentChange(element, range, newName2);
        }
        catch (IncorrectOperationException e) {
            LOG.error("Cannot rename " + this.getClass() + " from " + this.myFileReferenceSet.getClass() + " to " + newName2, e);
            throw e;
        }
    }

    @NotNull
    protected static FileReferenceHelper[] getHelpers() {
        FileReferenceHelper[] fileReferenceHelperArray = FileReferenceHelperRegistrar.getHelpers();
        if (fileReferenceHelperArray == null) {
            FileReference.$$$reportNull$$$0(22);
        }
        return fileReferenceHelperArray;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = LangBundle.message("error.cannot.resolve", new Object[0]) + " " + LangBundle.message(this.isLast() ? "terms.file" : "terms.directory", new Object[0]) + " '" + StringUtil.escapePattern(this.decode(this.getCanonicalText())) + "'";
        if (string == null) {
            FileReference.$$$reportNull$$$0(23);
        }
        return string;
    }

    public final boolean isLast() {
        return this.myIndex == this.myFileReferenceSet.getAllReferences().length - 1;
    }

    @NotNull
    public FileReferenceSet getFileReferenceSet() {
        FileReferenceSet fileReferenceSet = this.myFileReferenceSet;
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(24);
        }
        return fileReferenceSet;
    }

    @Override
    public LocalQuickFix[] getQuickFixes() {
        ArrayList<? extends LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            result2.addAll(helper.registerFixes(this));
        }
        return result2.toArray(new LocalQuickFix[result2.size()]);
    }

    @Override
    public FileReference getLastFileReference() {
        return this.myFileReferenceSet.getLastReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceResolver";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileReference";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileReferenceResolver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "innerSingleResolve";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<FileReference> {
        static final MyResolver INSTANCE = new MyResolver();

        MyResolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull FileReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            ResolveResult[] resolveResultArray = ref.innerResolve(ref.getFileReferenceSet().isCaseSensitive(), containingFile);
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

