/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorAwareAboutChildren;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class TagNameVariantCollector {
    public static List<XmlElementDescriptor> getTagDescriptors(XmlTag element, Collection<String> namespaces, @Nullable List<String> nsInfo) {
        XmlElementDescriptor elementDescriptor = null;
        String elementNamespace = element.getNamespacePrefix().isEmpty() ? null : element.getNamespace();
        HashMap<String, XmlElementDescriptor> descriptorsMap = new HashMap<String, XmlElementDescriptor>();
        PsiElement context = element.getParent();
        PsiElement curElement = element.getParent();
        while (curElement instanceof XmlTag) {
            XmlElementDescriptor descriptor3;
            XmlTag declarationTag = (XmlTag)curElement;
            String namespace = declarationTag.getNamespace();
            if (!descriptorsMap.containsKey(namespace) && (descriptor3 = declarationTag.getDescriptor()) != null) {
                descriptorsMap.put(namespace, descriptor3);
                if (elementDescriptor == null) {
                    elementDescriptor = descriptor3;
                    if (elementNamespace == null) {
                        elementNamespace = namespace;
                    }
                }
            }
            curElement = curElement.getContext();
        }
        HashSet<XmlNSDescriptor> visited2 = new HashSet<XmlNSDescriptor>();
        XmlExtension extension = XmlExtension.getExtension(element.getContainingFile());
        ArrayList<XmlElementDescriptor> variants = new ArrayList<XmlElementDescriptor>();
        for (String namespace : namespaces) {
            int initialSize = variants.size();
            TagNameVariantCollector.processVariantsInNamespace(namespace, element, variants, elementDescriptor, elementNamespace, descriptorsMap, visited2, context instanceof XmlTag ? (XmlTag)context : element, extension);
            if (nsInfo == null) continue;
            for (int i2 = initialSize; i2 < variants.size(); ++i2) {
                XmlElementDescriptor descriptor4 = variants.get(i2);
                nsInfo.add(descriptor4 instanceof XmlElementDescriptorImpl && !(descriptor4 instanceof RelaxedHtmlFromSchemaElementDescriptor) ? ((XmlElementDescriptorImpl)descriptor4).getNamespaceByContext(element) : namespace);
            }
        }
        boolean hasPrefix = StringUtil.isNotEmpty(element.getNamespacePrefix());
        return ContainerUtil.filter(variants, descriptor2 -> {
            if (descriptor2 instanceof AnyXmlElementDescriptor) {
                return false;
            }
            return !hasPrefix || !(descriptor2 instanceof XmlElementDescriptorImpl) || namespaces.contains(((XmlElementDescriptorImpl)descriptor2).getNamespace());
        });
    }

    private static void processVariantsInNamespace(String namespace, XmlTag element, List<XmlElementDescriptor> variants, XmlElementDescriptor elementDescriptor, String elementNamespace, Map<String, XmlElementDescriptor> descriptorsMap, Set<XmlNSDescriptor> visited2, XmlTag parent2, XmlExtension extension) {
        if (descriptorsMap.containsKey(namespace)) {
            XmlElementDescriptor descriptor2 = descriptorsMap.get(namespace);
            if (TagNameVariantCollector.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                for (XmlElementDescriptor containedDescriptor : descriptor2.getElementsDescriptors(parent2)) {
                    if (containedDescriptor == null) continue;
                    variants.add(containedDescriptor);
                }
            }
            if (element instanceof HtmlTag) {
                HtmlUtil.addHtmlSpecificCompletions(descriptor2, element, variants);
            }
            visited2.add(descriptor2.getNSDescriptor());
        } else {
            if (namespace == null) {
                return;
            }
            if (namespace.isEmpty() && !visited2.isEmpty()) {
                return;
            }
            XmlNSDescriptor nsDescriptor = TagNameVariantCollector.getDescriptor(element, namespace, true, extension);
            if (nsDescriptor == null) {
                if (!descriptorsMap.isEmpty()) {
                    return;
                }
                nsDescriptor = TagNameVariantCollector.getDescriptor(element, namespace, false, extension);
            }
            if (nsDescriptor != null && !visited2.contains(nsDescriptor) && TagNameVariantCollector.isAcceptableNs(element, elementDescriptor, elementNamespace, namespace)) {
                XmlElementDescriptor parentDescriptor;
                visited2.add(nsDescriptor);
                XmlElementDescriptor[] rootElementsDescriptors = nsDescriptor.getRootElementsDescriptors(PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class));
                XmlTag parentTag = extension.getParentTagForNamespace(element, nsDescriptor);
                if (parentTag == element.getParentTag()) {
                    parentDescriptor = elementDescriptor;
                } else {
                    assert (parentTag != null);
                    parentDescriptor = parentTag.getDescriptor();
                }
                for (XmlElementDescriptor candidateDescriptor : rootElementsDescriptors) {
                    if (candidateDescriptor == null || !TagNameVariantCollector.couldContainDescriptor(parentTag, parentDescriptor, candidateDescriptor, namespace, false)) continue;
                    variants.add(candidateDescriptor);
                }
            }
        }
    }

    private static XmlNSDescriptor getDescriptor(XmlTag element, String namespace, boolean strict, XmlExtension extension) {
        return extension.getNSDescriptor(element, namespace, strict);
    }

    static boolean couldContainDescriptor(XmlTag parentTag, XmlElementDescriptor parentDescriptor, XmlElementDescriptor childDescriptor, String childNamespace, boolean strict) {
        if (XmlUtil.nsFromTemplateFramework(childNamespace)) {
            return true;
        }
        if (parentTag == null) {
            return true;
        }
        if (parentDescriptor == null) {
            return false;
        }
        XmlTag childTag = parentTag.createChildTag(childDescriptor.getName(), childNamespace, null, false);
        childTag.putUserData(XmlElement.INCLUDING_ELEMENT, parentTag);
        XmlElementDescriptor descriptor2 = parentDescriptor.getElementDescriptor(childTag, parentTag);
        return descriptor2 != null && (!strict || !(descriptor2 instanceof AnyXmlElementDescriptor));
    }

    private static boolean isAcceptableNs(XmlTag element, XmlElementDescriptor elementDescriptor, String elementNamespace, String namespace) {
        return !(elementDescriptor instanceof XmlElementDescriptorAwareAboutChildren) || elementNamespace == null || elementNamespace.equals(namespace) || ((XmlElementDescriptorAwareAboutChildren)((Object)elementDescriptor)).allowElementsFromNamespace(namespace, element.getParentTag());
    }

    public static boolean couldContain(XmlTag parent2, XmlTag child) {
        return TagNameVariantCollector.couldContainDescriptor(parent2, parent2.getDescriptor(), child.getDescriptor(), child.getNamespace(), true);
    }
}

