/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolPresentationUtil {
    private SymbolPresentationUtil() {
    }

    public static String getSymbolPresentableText(@NotNull PsiElement element) {
        ItemPresentation presentation;
        if (element == null) {
            SymbolPresentationUtil.$$$reportNull$$$0(0);
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)((Object)element)).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        return element.getText();
    }

    @Nullable
    public static String getSymbolContainerText(PsiElement element) {
        if (element instanceof NavigationItem) {
            VirtualFile virtualFile2;
            ItemPresentation presentation = ((NavigationItem)((Object)element)).getPresentation();
            if (presentation != null) {
                return presentation.getLocationString();
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 != null && (virtualFile2 = file2.getVirtualFile()) != null) {
                return virtualFile2.getPath();
            }
        }
        return null;
    }

    public static String getFilePathPresentation(PsiFile psiFile) {
        String relativePath;
        VirtualFile rootForFile;
        ProjectFileIndex index2 = ProjectRootManager.getInstance(psiFile.getProject()).getFileIndex();
        VirtualFile file2 = psiFile.getOriginalFile().getVirtualFile();
        VirtualFile virtualFile2 = rootForFile = file2 != null ? index2.getContentRootForFile(file2) : null;
        if (rootForFile != null && (relativePath = VfsUtilCore.getRelativePath(file2, rootForFile, File.separatorChar)) != null) {
            return relativePath;
        }
        return psiFile.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/SymbolPresentationUtil", "getSymbolPresentableText"));
    }
}

