/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.Colored;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Colored(color="ffffe4", darkVariant="494539")
public class NonProjectFilesScope
extends NamedScope {
    public static final String NAME = "Non-Project Files";

    public NonProjectFilesScope() {
        super(NAME, new AbstractPackageSet("NonProject"){

            @Override
            public boolean contains(VirtualFile file2, NamedScopesHolder holder) {
                return this.contains(file2, holder.getProject(), holder);
            }

            @Override
            public boolean contains(VirtualFile file2, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null || file2.getFileSystem() instanceof NonPhysicalFileSystem) {
                    return false;
                }
                if (!file2.isInLocalFileSystem()) {
                    return true;
                }
                if (NonProjectFilesScope.isInsideProjectContent(project, file2)) {
                    return false;
                }
                return !ProjectScope.getProjectScope(project).contains(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/NonProjectFilesScope$1", "contains"));
            }
        });
    }

    private static boolean isInsideProjectContent(@NotNull Project project, @NotNull VirtualFile file2) {
        String projectBaseDir;
        if (project == null) {
            NonProjectFilesScope.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            NonProjectFilesScope.$$$reportNull$$$0(1);
        }
        if (!file2.isInLocalFileSystem() && (projectBaseDir = project.getBasePath()) != null) {
            return FileUtil.isAncestor(projectBaseDir, file2.getPath(), false);
        }
        return false;
    }

    @NotNull
    public static NamedScope[] removeFromList(@NotNull NamedScope[] scopes) {
        if (scopes == null) {
            NonProjectFilesScope.$$$reportNull$$$0(2);
        }
        int nonProjectIdx = -1;
        int length = scopes.length;
        for (int i2 = 0; i2 < length; ++i2) {
            NamedScope scope = scopes[i2];
            if (!(scope instanceof NonProjectFilesScope)) continue;
            nonProjectIdx = i2;
            break;
        }
        if (nonProjectIdx > -1) {
            scopes = (NamedScope[])ArrayUtil.remove(scopes, nonProjectIdx);
        }
        if (scopes == null) {
            NonProjectFilesScope.$$$reportNull$$$0(3);
        }
        return scopes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/NonProjectFilesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/NonProjectFilesScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsideProjectContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeFromList";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

