/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters2) {
        if (substitutor2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(0);
        }
        if (parameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(1);
        }
        if (typeParameters2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(2);
        }
        this.mySubstitutor = substitutor2;
        assert (substitutor2.isValid());
        this.myParameterTypes = PsiType.createArray(parameterTypes.length);
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            PsiType type2 = parameterTypes[i2];
            if (type2 != null) {
                PsiUtil.ensureValidType(type2);
            }
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            this.myParameterTypes[i2] = substitutor2.substitute(type2);
        }
        this.myTypeParameters = typeParameters2;
    }

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor2, @Nullable PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(3);
        }
        this.mySubstitutor = substitutor2;
        if (parameterList == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.myParameterTypes = PsiType.createArray(parameters2.length);
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType type2 = parameters2[i2].getType();
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                }
                this.myParameterTypes[i2] = substitutor2.substitute(type2);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            MethodSignatureBase.$$$reportNull$$$0(4);
        }
        return this.myParameterTypes;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            MethodSignatureBase.$$$reportNull$$$0(5);
        }
        return this.myTypeParameters;
    }

    @NotNull
    public PsiType[] getErasedParameterTypes() {
        PsiType[] result2 = this.myErasedParameterTypes;
        if (result2 == null) {
            result2 = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result2;
        }
        if (result2 == null) {
            MethodSignatureBase.$$$reportNull$$$0(6);
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        PsiType[] parameterTypes = this.getErasedParameterTypes();
        result2 = 31 * result2 + parameterTypes.length;
        int length = Math.min(3, parameterTypes.length);
        for (int i2 = 0; i2 < length; ++i2) {
            PsiType type2 = parameterTypes[i2];
            if (type2 == null) continue;
            result2 = 31 * result2 + type2.hashCode();
        }
        return result2;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters2 = this.getTypeParameters();
        if (typeParameters2.length != 0) {
            String sep = "<";
            for (PsiTypeParameter typeParameter : typeParameters2) {
                s = s + sep + typeParameter.getName();
                sep = ", ";
            }
            s = s + ">";
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            MethodSignatureBase.$$$reportNull$$$0(7);
        }
        return psiSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/MethodSignatureBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/MethodSignatureBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErasedParameterTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

