/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Colors;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorOrientation;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SeparatorComponent
extends JComponent {
    private int myVGap = 3;
    private Color myColor = Color.lightGray;
    private Color myShadow = Gray._240;
    private int myHGap = 1;
    private SeparatorOrientation myOrientation = SeparatorOrientation.HORIZONTAL;

    public SeparatorComponent() {
    }

    public SeparatorComponent(int aVerticalGap) {
        this.myVGap = aVerticalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, int aHorizontalGap) {
        this.myVGap = aVerticalGap;
        this.myHGap = aHorizontalGap;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(int aVerticalGap, Color aColor, Color aShadowColor) {
        this(aVerticalGap, 1, aColor, aShadowColor);
    }

    public SeparatorComponent(int aVerticalGap, int horizontalGap, Color aColor, Color aShadowColor) {
        this.myVGap = aVerticalGap;
        this.myHGap = horizontalGap;
        this.myColor = aColor;
        this.myShadow = aShadowColor;
        this.setBorder(JBUI.Borders.empty(this.myVGap, 0));
    }

    public SeparatorComponent(Color color, SeparatorOrientation orientation) {
        this.myColor = color;
        this.myOrientation = orientation;
        this.myShadow = null;
        this.myHGap = 0;
        this.myVGap = 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        if (this.myColor == null) {
            return;
        }
        g.setColor(this.myColor);
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            g.drawLine(this.myHGap, this.myVGap, this.getWidth() - this.myHGap - 1, this.myVGap);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                g.drawLine(this.myHGap + 1, this.myVGap + 1, this.getWidth() - this.myHGap, this.myVGap + 1);
            }
        } else {
            g.drawLine(this.myHGap, this.myVGap, this.myHGap, this.getHeight() - this.myVGap - 1);
            if (this.myShadow != null) {
                g.setColor(this.myShadow);
                g.drawLine(this.myHGap + 1, this.myVGap + 1, this.myHGap + 1, this.getHeight() - this.myVGap);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            return new Dimension(0, this.myVGap * 2 + 1);
        }
        return new Dimension(this.myHGap * 2 + 1, 1 + (this.myShadow != null ? 1 : 0));
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size = this.getPreferredSize();
        if (this.myOrientation != SeparatorOrientation.VERTICAL) {
            size.width = Integer.MAX_VALUE;
        } else {
            size.height = Integer.MAX_VALUE;
        }
        return size;
    }

    public static JComponent createLabeledLineSeparator(String titleText, Color containerBackgroundColor) {
        return SeparatorComponent.createLabeledLineSeparator(titleText, containerBackgroundColor, new JBColor(Colors.DARK_BLUE, containerBackgroundColor.brighter().brighter()));
    }

    public static JComponent createLabeledLineSeparator(String titleText, Color containerBackgroundColor, Color foregroundColor) {
        JLabel titleLabel = new JLabel(titleText);
        titleLabel.setFont(UIUtil.getLabelFont());
        titleLabel.setForeground(foregroundColor);
        SeparatorComponent separatorComponent = new SeparatorComponent(5, containerBackgroundColor.darker(), containerBackgroundColor.brighter());
        int hgap = !titleText.isEmpty() ? 5 : 0;
        JPanel result2 = new JPanel(new BorderLayout(hgap, 10));
        result2.add((Component)titleLabel, "West");
        result2.add((Component)separatorComponent, "Center");
        if (containerBackgroundColor != null) {
            result2.setBackground(containerBackgroundColor);
        }
        return result2;
    }

    public static JComponent createLabbeledLineSeparator(String titleText, Color containerBackgroundColor) {
        return SeparatorComponent.createLabeledLineSeparator(titleText, containerBackgroundColor);
    }
}

