/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleTextAttributes {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int FONT_MASK = 3;
    public static final int STYLE_STRIKEOUT = 4;
    public static final int STYLE_WAVED = 8;
    public static final int STYLE_UNDERLINE = 16;
    public static final int STYLE_BOLD_DOTTED_LINE = 32;
    public static final int STYLE_SEARCH_MATCH = 64;
    public static final int STYLE_SMALLER = 128;
    public static final int STYLE_OPAQUE = 256;
    public static final int STYLE_CLICKABLE = 512;
    public static final SimpleTextAttributes REGULAR_ATTRIBUTES = new SimpleTextAttributes(0, null);
    public static final SimpleTextAttributes REGULAR_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, null);
    public static final SimpleTextAttributes REGULAR_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, null);
    public static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, JBColor.red);
    public static final SimpleTextAttributes GRAYED_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_BOLD_ATTRIBUTES = new SimpleTextAttributes(1, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes GRAYED_SMALL_ATTRIBUTES = new SimpleTextAttributes(128, UIUtil.getInactiveTextColor());
    public static final SimpleTextAttributes SYNTHETIC_ATTRIBUTES = new SimpleTextAttributes(0, JBColor.blue);
    public static final SimpleTextAttributes GRAY_ATTRIBUTES = new SimpleTextAttributes(0, Color.GRAY);
    public static final SimpleTextAttributes GRAY_ITALIC_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes DARK_TEXT = new SimpleTextAttributes(0, new Color(112, 112, 164));
    public static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, new JBColor(Gray._0, Gray._187));
    public static final SimpleTextAttributes SELECTED_SIMPLE_CELL_ATTRIBUTES = new SimpleTextAttributes(0, UIUtil.getListSelectionForeground());
    public static final SimpleTextAttributes EXCLUDED_ATTRIBUTES = new SimpleTextAttributes(2, Color.GRAY);
    public static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(16, JBColor.blue);
    public static final SimpleTextAttributes LINK_BOLD_ATTRIBUTES = new SimpleTextAttributes(17, JBColor.blue);
    private final Color myBgColor;
    private final Color myFgColor;
    private final Color myWaveColor;
    @StyleAttributeConstant
    private final int myStyle;

    public SimpleTextAttributes(@StyleAttributeConstant int style2, Color fgColor) {
        this(style2, fgColor, null);
    }

    public SimpleTextAttributes(@StyleAttributeConstant int style2, Color fgColor, @Nullable Color waveColor) {
        this(null, fgColor, waveColor, style2);
    }

    public SimpleTextAttributes(@Nullable Color bgColor, Color fgColor, @Nullable Color waveColor, @StyleAttributeConstant int style2) {
        if ((0xFFFFFC00 & style2) != 0) {
            throw new IllegalArgumentException("Wrong style: " + style2);
        }
        this.myBgColor = bgColor;
        this.myFgColor = fgColor;
        this.myWaveColor = waveColor;
        this.myStyle = style2;
    }

    public Color getFgColor() {
        return this.myFgColor;
    }

    @Nullable
    public Color getBgColor() {
        return this.myBgColor;
    }

    @Nullable
    public Color getWaveColor() {
        return this.myWaveColor;
    }

    @StyleAttributeConstant
    public int getStyle() {
        return this.myStyle;
    }

    public boolean isStrikeout() {
        return BitUtil.isSet(this.myStyle, 4);
    }

    public boolean isWaved() {
        return BitUtil.isSet(this.myStyle, 8);
    }

    public boolean isUnderline() {
        return BitUtil.isSet(this.myStyle, 16);
    }

    public boolean isBoldDottedLine() {
        return BitUtil.isSet(this.myStyle, 32);
    }

    public boolean isSearchMatch() {
        return BitUtil.isSet(this.myStyle, 64);
    }

    public boolean isSmaller() {
        return BitUtil.isSet(this.myStyle, 128);
    }

    public boolean isOpaque() {
        return BitUtil.isSet(this.myStyle, 256);
    }

    public boolean isClickable() {
        return BitUtil.isSet(this.myStyle, 512);
    }

    @NotNull
    public static SimpleTextAttributes fromTextAttributes(TextAttributes attributes2) {
        if (attributes2 == null) {
            SimpleTextAttributes simpleTextAttributes = REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                SimpleTextAttributes.$$$reportNull$$$0(0);
            }
            return simpleTextAttributes;
        }
        Color fgColor = attributes2.getForegroundColor();
        if (fgColor == null) {
            fgColor = REGULAR_ATTRIBUTES.getFgColor();
        }
        Color bgColor = attributes2.getBackgroundColor();
        int style2 = attributes2.getFontType();
        if (attributes2.getEffectColor() != null) {
            EffectType effectType = attributes2.getEffectType();
            if (effectType == EffectType.STRIKEOUT) {
                style2 |= 4;
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                style2 |= 8;
            } else if (effectType == EffectType.LINE_UNDERSCORE || effectType == EffectType.BOLD_LINE_UNDERSCORE || effectType == EffectType.BOLD_DOTTED_LINE) {
                style2 |= 0x10;
            } else if (effectType == EffectType.SEARCH_MATCH) {
                style2 |= 0x40;
            }
        }
        SimpleTextAttributes simpleTextAttributes = new SimpleTextAttributes(bgColor, fgColor, attributes2.getEffectColor(), style2);
        if (simpleTextAttributes == null) {
            SimpleTextAttributes.$$$reportNull$$$0(1);
        }
        return simpleTextAttributes;
    }

    @JdkConstants.FontStyle
    public int getFontStyle() {
        return this.myStyle & 3;
    }

    public TextAttributes toTextAttributes() {
        EffectType effectType;
        Color effectColor;
        if (this.isWaved()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.WAVE_UNDERSCORE;
        } else if (this.isStrikeout()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.STRIKEOUT;
        } else if (this.isUnderline()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.LINE_UNDERSCORE;
        } else if (this.isBoldDottedLine()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.BOLD_DOTTED_LINE;
        } else if (this.isSearchMatch()) {
            effectColor = this.myWaveColor;
            effectType = EffectType.SEARCH_MATCH;
        } else {
            effectColor = null;
            effectType = null;
        }
        return new TextAttributes(this.myFgColor, null, effectColor, effectType, this.myStyle & 3);
    }

    public SimpleTextAttributes derive(@StyleAttributeConstant int style2, @Nullable Color fg, @Nullable Color bg, @Nullable Color wave) {
        return new SimpleTextAttributes(bg != null ? bg : this.getBgColor(), fg != null ? fg : this.getFgColor(), wave != null ? wave : this.getWaveColor(), style2 == -1 ? this.getStyle() : style2);
    }

    public static SimpleTextAttributes merge(SimpleTextAttributes weak, SimpleTextAttributes strong2) {
        int style2 = strong2.getStyle() | weak.getStyle();
        Color wave = !Comparing.equal(strong2.getWaveColor(), REGULAR_ATTRIBUTES.getWaveColor()) ? strong2.getWaveColor() : weak.getWaveColor();
        Color fg = !Comparing.equal(strong2.getFgColor(), REGULAR_ATTRIBUTES.getFgColor()) ? strong2.getFgColor() : weak.getFgColor();
        Color bg = !Comparing.equal(strong2.getBgColor(), REGULAR_ATTRIBUTES.getBgColor()) ? strong2.getBgColor() : weak.getBgColor();
        return new SimpleTextAttributes(bg, fg, wave, style2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/SimpleTextAttributes", "fromTextAttributes"));
    }

    public static @interface StyleAttributeConstant {
    }
}

