/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.NotNullList;
import gnu.trove.TLongArrayList;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.CachedValueImpl");
    private volatile SoftReference<Data<T>> myData;

    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        Object value = result2 == null ? null : (Object)result2.getValue();
        Object[] dependencies2 = this.getDependencies(result2);
        if (dependencies2 == null) {
            return new Data<Object>(value, null, null);
        }
        TLongArrayList timeStamps = new TLongArrayList(dependencies2.length);
        NotNullList<Object> deps = new NotNullList<Object>(dependencies2.length);
        this.collectDependencies(timeStamps, deps, dependencies2);
        return new Data<Object>(value, ArrayUtil.toObjectArray(deps), timeStamps.toNativeArray());
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.myData = new SoftReference<Data<Data<T>>>(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data2) {
        this.myData = new SoftReference<Data<Data<T>>>(data2);
    }

    private synchronized boolean compareAndClearData(Data<T> expected) {
        if (this.getRawData() == expected) {
            this.myData = null;
            return true;
        }
        return false;
    }

    @Nullable
    protected Object[] getDependencies(CachedValueProvider.Result<T> result2) {
        return result2 == null ? null : result2.getDependencyItems();
    }

    @Nullable
    protected Object[] getDependenciesPlusValue(CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            return null;
        }
        Object[] items = result2.getDependencyItems();
        T value = result2.getValue();
        return value == null ? items : ArrayUtil.append(items, value);
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull(false) != null;
    }

    @Nullable
    private Data<T> getUpToDateOrNull(boolean dispose) {
        Data<T> data2 = this.getRawData();
        if (data2 != null) {
            if (this.isUpToDate(data2)) {
                return data2;
            }
            if (dispose && ((Data)data2).myValue instanceof Disposable && this.compareAndClearData(data2)) {
                Disposer.dispose((Disposable)((Data)data2).myValue);
            }
        }
        return null;
    }

    @Nullable
    final Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data2) {
        if (data2 == null) {
            CachedValueBase.$$$reportNull$$$0(0);
        }
        if (data2.myTimeStamps == null) {
            return true;
        }
        for (int i2 = 0; i2 < data2.myDependencies.length; ++i2) {
            Object dependency = data2.myDependencies[i2];
            if (dependency == null || !this.isDependencyOutOfDate(dependency, data2.myTimeStamps[i2])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(Object dependency, long oldTimeStamp) {
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private void collectDependencies(TLongArrayList timeStamps, List<Object> resultingDeps, Object[] dependencies2) {
        for (Object dependency : dependencies2) {
            if (dependency == null || dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                this.collectDependencies(timeStamps, resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
            timeStamps.add(this.getTimeStamp(dependency));
        }
    }

    protected long getTimeStamp(Object dependency) {
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(CachedValueProvider.Result<T> result2) {
        Data<T> data2 = this.computeData(result2);
        this.setData(data2);
        this.valueUpdated(result2.getDependencyItems());
        return (T)((Data)data2).myValue;
    }

    protected void valueUpdated(@Nullable Object[] dependencies2) {
    }

    public abstract boolean isFromMyProject(Project var1);

    @Nullable
    protected <P> T getValueWithLock(P param2) {
        Data<T> data2 = this.getUpToDateOrNull(true);
        if (data2 != null) {
            return (T)((Data)data2).myValue;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard("cachedValue").markStack();
        data2 = this.computeData(this.doCompute(param2));
        if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            while ((toReturn = this.cacheOrGetData(alreadyComputed, (reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed)) ? null : data2)) == null) {
            }
            this.valueUpdated(((Data)toReturn).myDependencies);
            return (T)((Data)toReturn).myValue;
        }
        return (T)((Data)data2).myValue;
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/CachedValueBase", "isUpToDate"));
    }

    protected static class Data<T>
    implements Disposable {
        private final T myValue;
        private final Object[] myDependencies;
        private final long[] myTimeStamps;

        public Data(T value, Object[] dependencies2, long[] timeStamps) {
            this.myValue = value;
            this.myDependencies = dependencies2;
            this.myTimeStamps = timeStamps;
        }

        @Override
        public void dispose() {
            if (this.myValue instanceof Disposable) {
                Disposer.dispose((Disposable)this.myValue);
            }
        }
    }
}

