/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodInvocator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.MethodInvocator");
    private Method myMethod;

    public MethodInvocator(Class<?> aClass2, String method, Class<?> ... parameterTypes) {
        this(true, aClass2, method, parameterTypes);
    }

    public MethodInvocator(boolean warnIfAbsent, Class<?> aClass2, String method, Class<?> ... parameterTypes) {
        block3: {
            try {
                this.myMethod = aClass2.getDeclaredMethod(method, parameterTypes);
                if (!this.myMethod.isAccessible()) {
                    this.myMethod.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e) {
                if (!warnIfAbsent) break block3;
                LOG.warn("Method not found: " + aClass2.getName() + "." + method);
            }
        }
    }

    public boolean isAvailable() {
        return this.myMethod != null;
    }

    public Object invoke(Object object, Object ... arguments2) {
        if (!this.isAvailable()) {
            throw new IllegalStateException("Method is not available");
        }
        try {
            return this.myMethod.invoke(object, arguments2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

