/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.PathUtilRt;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.PathUtil");

    private PathUtil() {
    }

    @Nullable
    public static String getLocalPath(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        if (file2.getFileSystem().getProtocol().equals("jar") && file2.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file2.getPath());
    }

    @NotNull
    public static String getLocalPath(@NotNull String path2) {
        if (path2 == null) {
            PathUtil.$$$reportNull$$$0(0);
        }
        String string = FileUtil.toSystemDependentName(StringUtil.trimEnd(path2, "!/"));
        if (string == null) {
            PathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass2) {
        if (aClass2 == null) {
            PathUtil.$$$reportNull$$$0(2);
        }
        String pathForClass = PathManager.getJarPathForClass(aClass2);
        assert (pathForClass != null) : aClass2;
        String string = pathForClass;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            PathUtil.$$$reportNull$$$0(4);
        }
        String string = PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
        if (string == null) {
            PathUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String getCanonicalPath(@NonNls String path2) {
        return FileUtil.toCanonicalPath(path2);
    }

    @NotNull
    public static String getFileName(@NotNull String path2) {
        if (path2 == null) {
            PathUtil.$$$reportNull$$$0(6);
        }
        String string = PathUtilRt.getFileName(path2);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getFileExtension(@NotNull String name) {
        int index2;
        if (name == null) {
            PathUtil.$$$reportNull$$$0(8);
        }
        if ((index2 = name.lastIndexOf(46)) < 0) {
            return null;
        }
        return name.substring(index2 + 1);
    }

    @NotNull
    public static String getParentPath(@NotNull String path2) {
        if (path2 == null) {
            PathUtil.$$$reportNull$$$0(9);
        }
        String string = PathUtilRt.getParentPath(path2);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2) {
        if (text2 == null) {
            PathUtil.$$$reportNull$$$0(11);
        }
        String string = PathUtilRt.suggestFileName(text2);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2, boolean allowDots, boolean allowSpaces) {
        if (text2 == null) {
            PathUtil.$$$reportNull$$$0(13);
        }
        String string = PathUtilRt.suggestFileName(text2, allowDots, allowSpaces);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            PathUtil.$$$reportNull$$$0(15);
        }
        return PathUtilRt.isValidFileName(fileName, true);
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        if (fileName == null) {
            PathUtil.$$$reportNull$$$0(16);
        }
        return PathUtilRt.isValidFileName(fileName, strict);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemIndependentName(path2);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemDependentName(@Nullable String path2) {
        return path2 == null ? null : FileUtilRt.toSystemDependentName(path2);
    }

    @Deprecated
    public static void assertArgumentIsSystemIndependent(String className2, String methodName, String parameterName, String argument) {
        if (argument != null && argument.contains("\\")) {
            String message = String.format("Argument for @SystemIndependent parameter '%s' of %s.%s must be system-independent: %s", parameterName, className2, methodName, argument);
            IllegalArgumentException exception = new IllegalArgumentException(message);
            StackTraceElement[] stackTrace = new StackTraceElement[exception.getStackTrace().length - 1];
            System.arraycopy(exception.getStackTrace(), 1, stackTrace, 0, stackTrace.length);
            exception.setStackTrace(stackTrace);
            LOG.error(exception);
        }
    }

    @NotNull
    public static String driveLetterToLowerCase(@NotNull String path2) {
        File file2;
        if (path2 == null) {
            PathUtil.$$$reportNull$$$0(17);
        }
        if (SystemInfo.isWindows && path2.length() >= 2 && Character.isUpperCase(path2.charAt(0)) && path2.charAt(1) == ':' && (file2 = new File(path2)).isAbsolute()) {
            String string = Character.toLowerCase(path2.charAt(0)) + path2.substring(1);
            if (string == null) {
                PathUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = path2;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String makeFileName(@NotNull String name, @Nullable String extension) {
        if (name == null) {
            PathUtil.$$$reportNull$$$0(20);
        }
        String string = StringUtil.isEmpty(extension) ? name : name + '.' + extension;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static VirtualFile getLocalFile(@NotNull VirtualFile file2) {
        VirtualFile localFile;
        VirtualFileSystem fileSystem;
        if (file2 == null) {
            PathUtil.$$$reportNull$$$0(22);
        }
        if (file2.isValid() && (fileSystem = file2.getFileSystem()) instanceof LocalFileProvider && (localFile = ((LocalFileProvider)((Object)fileSystem)).getLocalVirtualFileFor(file2)) != null) {
            VirtualFile virtualFile2 = localFile;
            if (virtualFile2 == null) {
                PathUtil.$$$reportNull$$$0(23);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = file2;
        if (virtualFile3 == null) {
            PathUtil.$$$reportNull$$$0(24);
        }
        return virtualFile3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarPathForClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "driveLetterToLowerCase";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFileName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "driveLetterToLowerCase";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "makeFileName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

