/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ByteTrie {
    private static final String EMPTY_STRING = "";
    private final ArrayList<Node> myAllNodes = new ArrayList();

    public ByteTrie() {
        Node root2 = new Node(-1, 0);
        this.myAllNodes.add(root2);
    }

    public int size() {
        return this.myAllNodes.size();
    }

    public int getHashCode(String s) {
        return this.getHashCode(s.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    public String getString(int hashCode2) {
        return new String(this.getBytes(hashCode2), CharsetToolkit.UTF8_CHARSET);
    }

    public int getHashCodeForReversedString(String s) {
        return this.getHashCodeForReversedBytes(s.getBytes(CharsetToolkit.UTF8_CHARSET));
    }

    public String getReversedString(int hashCode2) {
        return new String(this.getReversedBytes(hashCode2), CharsetToolkit.UTF8_CHARSET);
    }

    public int getHashCode(byte[] bytes) {
        return this.getHashCode(bytes, 0, bytes.length);
    }

    public int getHashCode(byte[] bytes, int offset2, int length) {
        int index2 = 0;
        while (length-- > 0) {
            index2 = this.getSubNode(index2, bytes[offset2++]);
        }
        return index2;
    }

    public long getMaximumMatch(byte[] bytes, int offset2, int length) {
        int nextIndex;
        int index2 = 0;
        int resultingLength = 0;
        while (length-- > 0 && (nextIndex = this.searchForSubNode(index2, bytes[offset2++])) != 0) {
            index2 = nextIndex;
            ++resultingLength;
        }
        return (long)index2 + ((long)resultingLength << 32);
    }

    @NotNull
    public byte[] getBytes(int hashCode2) {
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        while (hashCode2 > 0) {
            Node node = this.myAllNodes.get(hashCode2);
            this.writeByte(stream2, node.myChar);
            hashCode2 = node.myParent;
        }
        byte[] bytes = stream2.toByteArray();
        int i2 = 0;
        for (int j = bytes.length - 1; i2 < j; ++i2, --j) {
            byte swap = bytes[i2];
            bytes[i2] = bytes[j];
            bytes[j] = swap;
        }
        if (bytes == null) {
            ByteTrie.$$$reportNull$$$0(0);
        }
        return bytes;
    }

    public int getHashCodeForReversedBytes(byte[] bytes) {
        return this.getHashCodeForReversedBytes(bytes, bytes.length - 1, bytes.length);
    }

    public int getHashCodeForReversedBytes(byte[] bytes, int offset2, int length) {
        int index2 = 0;
        while (length-- > 0) {
            index2 = this.getSubNode(index2, bytes[offset2--]);
        }
        return index2;
    }

    @NotNull
    public byte[] getReversedBytes(int hashCode2) {
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        while (hashCode2 > 0) {
            Node node = this.myAllNodes.get(hashCode2);
            this.writeByte(stream2, node.myChar);
            hashCode2 = node.myParent;
        }
        byte[] byArray = stream2.toByteArray();
        if (byArray == null) {
            ByteTrie.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    private int getSubNode(int parentIndex, byte b2) {
        int index2;
        Node parentNode = this.myAllNodes.get(parentIndex);
        if (parentNode.myChildren == null) {
            parentNode.myChildren = new IntArrayList(1);
        }
        IntArrayList children2 = parentNode.myChildren;
        int left = 0;
        int right = children2.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            index2 = children2.get(middle);
            Node node = this.myAllNodes.get(index2);
            int comp2 = node.myChar - b2;
            if (comp2 == 0) {
                return index2;
            }
            if (comp2 < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        index2 = this.myAllNodes.size();
        children2.add(left, index2);
        this.myAllNodes.add(new Node(parentIndex, b2));
        return index2;
    }

    private int searchForSubNode(int parentIndex, byte b2) {
        Node parentNode = this.myAllNodes.get(parentIndex);
        IntArrayList children2 = parentNode.myChildren;
        if (children2 == null) {
            return 0;
        }
        int left = 0;
        int right = children2.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            int index2 = children2.get(middle);
            Node node = this.myAllNodes.get(index2);
            int comp2 = node.myChar - b2;
            if (comp2 == 0) {
                return index2;
            }
            if (comp2 < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        return 0;
    }

    void writeByte(ByteArrayOutputStream stream2, byte b2) {
        int out = b2;
        if (out < 0) {
            out += 256;
        }
        stream2.write(out);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/ByteTrie";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReversedBytes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Node {
        private final byte myChar;
        private final int myParent;
        private IntArrayList myChildren;

        Node(int parent2, byte b2) {
            this.myChar = b2;
            this.myParent = parent2;
        }
    }
}

