/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers.hash;

import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.HashUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Entry<K, V>[] table;
    private Entry<K, V> top;
    private Entry<K, V> back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private final EqualityPolicy<K> hashingStrategy;
    private final boolean accessOrder;

    public LinkedHashMap() {
        this(0);
    }

    public LinkedHashMap(int capacity) {
        this(capacity, 1.0f);
    }

    public LinkedHashMap(int capacity, boolean accessOrder) {
        this(capacity, 1.0f, accessOrder);
    }

    public LinkedHashMap(int capacity, float loadFactor) {
        this(capacity, loadFactor, EqualityPolicy.CANONICAL);
    }

    public LinkedHashMap(int capacity, float loadFactor, boolean accessOrder) {
        this(capacity, loadFactor, EqualityPolicy.CANONICAL, accessOrder);
    }

    public LinkedHashMap(EqualityPolicy<K> hashingStrategy) {
        this(0, 1.0f, hashingStrategy);
    }

    public LinkedHashMap(int capacity, float loadFactor, EqualityPolicy<K> hashingStrategy) {
        this(capacity, loadFactor, hashingStrategy, false);
    }

    public LinkedHashMap(int capacity, float loadFactor, EqualityPolicy<K> hashingStrategy, boolean accessOrder) {
        this.loadFactor = loadFactor;
        this.hashingStrategy = hashingStrategy;
        this.clear(capacity);
        this.accessOrder = accessOrder;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clear(0);
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] table2 = this.table;
        int hash = HashUtil.hash(key, this.hashingStrategy);
        int index2 = hash % table2.length;
        Entry e = table2[index2];
        while (e != null) {
            Object entryKey;
            if (e.keyHash == hash && ((entryKey = e.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e);
                return (V)e.value;
            }
            e = e.hashNext;
        }
        return null;
    }

    @Override
    public V put(K key, @NotNull V value) {
        if (value == null) {
            LinkedHashMap.$$$reportNull$$$0(0);
        }
        Entry<K, V>[] table2 = this.table;
        int hash = HashUtil.hash(key, this.hashingStrategy);
        int index2 = hash % table2.length;
        Entry<K, V> e = table2[index2];
        while (e != null) {
            Object entryKey;
            if (((Entry)e).keyHash == hash && ((entryKey = ((Entry)e).key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
                this.moveToTop(e);
                return e.setValue(value);
            }
            e = ((Entry)e).hashNext;
        }
        e = new Entry<K, V>(key, value, hash);
        ((Entry)e).hashNext = (Entry)table2[index2];
        table2[index2] = e;
        Entry<K, V> top = this.top;
        ((Entry)e).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e;
        } else {
            this.back = e;
        }
        this.top = e;
        ++this.size;
        if (this.removeEldestEntry(this.back, ((Entry)this.back).key, ((Entry)this.back).value)) {
            this.doRemoveEldestEntry();
        } else if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return null;
    }

    public void doRemoveEldestEntry() {
        V val = this.remove(((Entry)this.back).key);
        assert (val != null) : "LinkedHashMap.Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V remove(Object key) {
        Object entryKey;
        Entry<K, V>[] table2 = this.table;
        int hash = HashUtil.hash(key, this.hashingStrategy);
        int index2 = hash % table2.length;
        Entry e = table2[index2];
        if (e == null) {
            return null;
        }
        if (e.keyHash == hash && ((entryKey = e.key) == key || this.hashingStrategy.isEqual(entryKey, key))) {
            table2[index2] = e.hashNext;
        } else {
            Entry last2;
            do {
                last2 = e;
                if ((e = e.hashNext) != null) continue;
                return null;
            } while (e.keyHash != hash || (entryKey = e.key) != key && !this.hashingStrategy.isEqual(entryKey, key));
            last2.hashNext = e.hashNext;
        }
        this.unlink(e);
        --this.size;
        return (V)e.value;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        KeySet keySet = new KeySet();
        if (keySet == null) {
            LinkedHashMap.$$$reportNull$$$0(1);
        }
        return keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Values values2 = new Values();
        if (values2 == null) {
            LinkedHashMap.$$$reportNull$$$0(2);
        }
        return values2;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = new EntrySet();
        if (entrySet == null) {
            LinkedHashMap.$$$reportNull$$$0(3);
        }
        return entrySet;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
        return this.removeEldestEntry(eldest);
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return false;
    }

    private void init(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.back = null;
        this.top = null;
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    @Nullable
    public K getLastKey() {
        return (K)(this.top != null ? ((Entry)this.top).key : null);
    }

    @Nullable
    public V getLastValue() {
        return (V)(this.top != null ? ((Entry)this.top).value : null);
    }

    private void moveToTop(Entry<K, V> e) {
        if (!this.accessOrder) {
            return;
        }
        Entry<K, V> top = this.top;
        if (top != e) {
            Entry prev = ((Entry)e).previous;
            Entry next = ((Entry)e).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e;
            ((Entry)e).next = (Entry)top;
            ((Entry)e).previous = null;
            this.top = e;
        }
    }

    private void unlink(Entry<K, V> e) {
        Entry prev = ((Entry)e).previous;
        Entry next = ((Entry)e).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e).previous = null;
        ((Entry)e).next = null;
    }

    private void rehash(int capacity) {
        this.table = new Entry[HashUtil.adjustTableSize((int)((float)capacity / this.loadFactor))];
        this.capacity = capacity;
        Entry<K, V>[] table2 = this.table;
        int tableLen = table2.length;
        Entry e = this.back;
        while (e != null) {
            int hash = e.keyHash % tableLen;
            e.hashNext = (Entry)table2[hash];
            table2[hash] = e;
            e = e.previous;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/hash/LinkedHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/hash/LinkedHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            LinkedHashIterator linkedHashIterator = new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
            if (linkedHashIterator == null) {
                Values.$$$reportNull$$$0(0);
            }
            return linkedHashIterator;
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LinkedHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/hash/LinkedHashMap$Values", "iterator"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            LinkedHashIterator linkedHashIterator = new LinkedHashIterator<K>(){

                @Override
                public K next() {
                    return this.nextEntry().key;
                }
            };
            if (linkedHashIterator == null) {
                KeySet.$$$reportNull$$$0(0);
            }
            return linkedHashIterator;
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LinkedHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return LinkedHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/hash/LinkedHashMap$KeySet", "iterator"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            LinkedHashIterator linkedHashIterator = new LinkedHashIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return this.nextEntry();
                }
            };
            if (linkedHashIterator == null) {
                EntrySet.$$$reportNull$$$0(0);
            }
            return linkedHashIterator;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = LinkedHashMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return LinkedHashMap.this.remove(e.getKey()) != null;
        }

        @Override
        public int size() {
            return LinkedHashMap.this.size;
        }

        @Override
        public void clear() {
            LinkedHashMap.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/hash/LinkedHashMap$EntrySet", "iterator"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<K, V> e;
        private Entry<K, V> last;

        private LinkedHashIterator() {
            this.e = LinkedHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<K, V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.e = result2.previous;
            return result2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final int keyHash;
        private V value;
        private Entry<K, V> next;
        private Entry<K, V> previous;
        private Entry<K, V> hashNext;

        public Entry(K key, V value, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result2 = this.value;
            this.value = value;
            return result2;
        }
    }
}

