/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachingSemiGraph<Node>
implements GraphGenerator.SemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, List<Node>> myIn;

    public static <T> InboundSemiGraph<T> cache(InboundSemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    private CachingSemiGraph(InboundSemiGraph<Node> original) {
        this.myNodes = ContainerUtil.newLinkedHashSet(original.getNodes());
        this.myIn = new THashMap<Node, List<Node>>();
        for (Node node : this.myNodes) {
            Iterator<Node> inIterator = original.getIn(node);
            if (!inIterator.hasNext()) continue;
            ArrayList value = new ArrayList();
            ContainerUtil.addAll(value, inIterator);
            this.myIn.put(node, value);
        }
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myNodes;
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        List<Node> inNodes = this.myIn.get(n);
        return inNodes != null ? inNodes.iterator() : ContainerUtil.emptyIterator();
    }

    public static <T> CachingSemiGraph<T> create(GraphGenerator.SemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    public CachingSemiGraph(GraphGenerator.SemiGraph<Node> original) {
        this((InboundSemiGraph<Node>)original);
    }
}

