/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collection;
import java.util.Formatter;

public class DebugAssertions {
    private static final Logger LOG = Logger.getInstance(DebugAssertions.class);
    public static volatile boolean DEBUG = SystemProperties.getBooleanProperty("intellij.idea.indices.debug", false);
    public static final boolean EXTRA_SANITY_CHECKS = SystemProperties.getBooleanProperty("intellij.idea.indices.debug.extra.sanity", false);

    public static void assertTrue(boolean value) {
        if (!value) {
            LOG.assertTrue(false);
        }
    }

    public static void assertTrue(boolean value, String message, Object ... args) {
        if (!value) {
            DebugAssertions.error(message, args);
        }
    }

    public static void error(String message, Object ... args) {
        LOG.error(new Formatter().format(message, args));
    }

    public static <Key> boolean equals(Collection<Key> keys2, Collection<Key> keys22, KeyDescriptor<Key> keyDescriptor) {
        if (keys2 == null && keys22 == null) {
            return true;
        }
        if (keys2 == null || keys22 == null || keys2.size() != keys22.size()) {
            return false;
        }
        LinkedHashMap<Key, Boolean> map2 = new LinkedHashMap<Key, Boolean>(keys2.size(), 0.8f, keyDescriptor);
        for (Key key : keys2) {
            map2.put(key, Boolean.TRUE);
        }
        LinkedHashMap<Key, Boolean> map22 = new LinkedHashMap<Key, Boolean>(keys2.size(), 0.8f, keyDescriptor);
        for (Key key : keys22) {
            map22.put(key, Boolean.TRUE);
        }
        return map2.equals(map22);
    }
}

