/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.Processor;
import com.intellij.util.io.CompressedAppendableFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.MappedFileInputStream;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppendableStorageBackedByResizableMappedFile
extends ResizeableMappedFile {
    private final MyDataIS myReadStream = new MyDataIS(this);
    private byte[] myAppendBuffer;
    private volatile int myFileLength = (int)this.length();
    private volatile int myBufferPosition;
    private static final int ourAppendBufferLength = 4096;
    private final CompressedAppendableFile myCompressedAppendableFile = null;
    private final boolean testMode = false;

    public AppendableStorageBackedByResizableMappedFile(File file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        super(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned);
    }

    private void flushKeyStoreBuffer() {
        if (this.myBufferPosition > 0) {
            this.put(this.myFileLength, this.myAppendBuffer, 0, this.myBufferPosition);
            this.myFileLength += this.myBufferPosition;
            this.myBufferPosition = 0;
        }
    }

    @Override
    public void force() {
        this.flushKeyStoreBuffer();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.force();
        }
        super.force();
    }

    @Override
    public void close() {
        this.flushKeyStoreBuffer();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.dispose();
        }
        super.close();
    }

    public <Data> Data read(int addr, KeyDescriptor<Data> descriptor2) throws IOException {
        Object tempData = null;
        if (this.myCompressedAppendableFile != null) {
            tempData = this.myCompressedAppendableFile.read(addr, descriptor2);
            return (Data)tempData;
        }
        if (this.myFileLength <= addr) {
            Object data2 = descriptor2.read(new DataInputStream(new UnsyncByteArrayInputStream(this.myAppendBuffer, addr - this.myFileLength, this.myBufferPosition)));
            if (tempData != null && !descriptor2.isEqual(data2, tempData)) assert (false);
            return (Data)data2;
        }
        this.myReadStream.setup(addr, this.myFileLength);
        Object data3 = descriptor2.read(this.myReadStream);
        if (tempData != null && !descriptor2.isEqual(data3, tempData)) assert (false);
        return (Data)data3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <Data> boolean processAll(Processor<Data> processor, KeyDescriptor<Data> descriptor2) throws IOException {
        DataInputStream keysStream2;
        assert (!this.isDirty());
        DataInputStream dataInputStream = keysStream2 = this.myCompressedAppendableFile != null ? this.myCompressedAppendableFile.getStream(0L) : null;
        if (keysStream2 != null) {
            this.getPagedFileStorage().lock();
            try {
                while (true) {
                    Object key2222;
                    if (!processor.process(key2222 = descriptor2.read(keysStream2))) {
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            catch (EOFException key2222) {
                boolean key2222 = true;
                return key2222;
            }
        }
        DataInputStream keysStream = new DataInputStream(new BufferedInputStream(new LimitedInputStream(new FileInputStream(this.getPagedFileStorage().getFile()), this.myFileLength){

            @Override
            public int available() throws IOException {
                return this.remainingLimit();
            }
        }, 32768));
        try {
            while (true) {
                Object tempKey;
                Object key = descriptor2.read(keysStream);
                if (keysStream2 != null && !descriptor2.isEqual(key, tempKey = descriptor2.read(keysStream2))) assert (false);
                if (!processor.process(key)) {
                    boolean bl = false;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            boolean bl = true;
            return bl;
        }
        finally {
            keysStream.close();
        }
    }

    public int getCurrentLength() {
        int currentLength = this.myCompressedAppendableFile != null ? (int)this.myCompressedAppendableFile.length() : this.myBufferPosition + this.myFileLength;
        return currentLength;
    }

    public <Data> int append(Data value, KeyDescriptor<Data> descriptor2) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        descriptor2.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (this.myCompressedAppendableFile != null) {
            this.myCompressedAppendableFile.append(buffer, size);
            return currentLength;
        }
        if (size > 4096) {
            this.flushKeyStoreBuffer();
            this.put(currentLength, buffer, 0, size);
            this.myFileLength += size;
        } else {
            if (size > 4096 - this.myBufferPosition) {
                this.flushKeyStoreBuffer();
            }
            if (this.myAppendBuffer == null) {
                this.myAppendBuffer = new byte[4096];
            }
            System.arraycopy(buffer, 0, this.myAppendBuffer, this.myBufferPosition, size);
            this.myBufferPosition += size;
        }
        return currentLength;
    }

    public <Data> boolean checkBytesAreTheSame(int addr, Data value, KeyDescriptor<Data> descriptor2) throws IOException {
        OutputStream comparer;
        final boolean[] sameValue = new boolean[1];
        if (this.myCompressedAppendableFile != null) {
            final DataInputStream compressedStream = this.myCompressedAppendableFile.getStream(addr);
            comparer = new OutputStream(){
                boolean same = true;

                @Override
                public void write(int b2) throws IOException {
                    if (this.same) {
                        this.same = compressedStream.readByte() == (byte)b2;
                    }
                }

                @Override
                public void close() {
                    sameValue[0] = this.same;
                }
            };
        } else {
            comparer = this.buildOldComparerStream(addr, sameValue);
        }
        DataOutputStream out = new DataOutputStream(comparer);
        descriptor2.save(out, value);
        comparer.close();
        return sameValue[0];
    }

    @NotNull
    private OutputStream buildOldComparerStream(final int addr, final boolean[] sameValue) {
        final PagedFileStorage storage2 = this.getPagedFileStorage();
        OutputStream comparer = this.myFileLength <= addr ? new OutputStream(){
            int address;
            boolean same;
            {
                this.address = addr - AppendableStorageBackedByResizableMappedFile.this.myFileLength;
                this.same = true;
            }

            @Override
            public void write(int b2) {
                if (this.same) {
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myBufferPosition && AppendableStorageBackedByResizableMappedFile.this.myAppendBuffer[this.address++] == (byte)b2;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        } : new OutputStream(){
            int base;
            int address;
            boolean same;
            ByteBuffer buffer;
            final int myPageSize;
            {
                this.base = addr;
                this.address = storage2.getOffsetInPage(addr);
                this.same = true;
                this.buffer = storage2.getByteBuffer(addr, false).getCachedBuffer();
                this.myPageSize = storage2.myPageSize;
            }

            @Override
            public void write(int b2) {
                if (this.same) {
                    if (this.myPageSize == this.address && this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength) {
                        this.base += this.address;
                        this.buffer = storage2.getByteBuffer(this.base, false).getCachedBuffer();
                        this.address = 0;
                    }
                    this.same = this.address < AppendableStorageBackedByResizableMappedFile.this.myFileLength && this.buffer.get(this.address++) == (byte)b2;
                }
            }

            @Override
            public void close() {
                sameValue[0] = this.same;
            }
        };
        OutputStream outputStream2 = comparer;
        if (outputStream2 == null) {
            AppendableStorageBackedByResizableMappedFile.$$$reportNull$$$0(0);
        }
        return outputStream2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/AppendableStorageBackedByResizableMappedFile", "buildOldComparerStream"));
    }

    private class MyCompressedAppendableFile
    extends CompressedAppendableFile {
        private final File myFile;
        private DataOutputStream myChunkLengthTableStream;

        public MyCompressedAppendableFile(File file2) {
            super(AppendableStorageBackedByResizableMappedFile.this.getPagedFileStorage().getFile());
            this.myFile = file2;
        }

        @Override
        @NotNull
        protected InputStream getChunkInputStream(File appendFile, long offset2, int pageSize) throws IOException {
            byte[] buf = new byte[pageSize];
            AppendableStorageBackedByResizableMappedFile.this.get(offset2, buf, 0, pageSize);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
            if (byteArrayInputStream == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(0);
            }
            return byteArrayInputStream;
        }

        @Override
        protected void saveChunk(BufferExposingByteArrayOutputStream compressedChunk, long endOfFileOffset) throws IOException {
            AppendableStorageBackedByResizableMappedFile.super.put(endOfFileOffset, compressedChunk.getInternalBuffer(), 0, compressedChunk.size());
            if (this.myChunkLengthTableStream == null) {
                this.myChunkLengthTableStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.getChunkLengthFile(), true)));
            }
            DataInputOutputUtil.writeINT(this.myChunkLengthTableStream, compressedChunk.size());
        }

        @Override
        public synchronized void force() {
            super.force();
            try {
                if (this.myChunkLengthTableStream != null) {
                    this.myChunkLengthTableStream.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public synchronized void dispose() {
            super.dispose();
            if (this.myChunkLengthTableStream != null) {
                try {
                    this.myChunkLengthTableStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        @NotNull
        protected File getChunksFile() {
            File file2 = this.myFile;
            if (file2 == null) {
                MyCompressedAppendableFile.$$$reportNull$$$0(1);
            }
            return file2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/io/AppendableStorageBackedByResizableMappedFile$MyCompressedAppendableFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunkInputStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChunksFile";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyBufferedIS
    extends BufferedInputStream {
        public MyBufferedIS(InputStream in) {
            super(in, 512);
        }

        public void setup(long pos, long limit) {
            this.pos = 0;
            this.count = 0;
            ((MappedFileInputStream)this.in).setup(pos, limit);
        }
    }

    private static class MyDataIS
    extends DataInputStream {
        private MyDataIS(ResizeableMappedFile raf) {
            super(new MyBufferedIS(new MappedFileInputStream(raf, 0L, 0L)));
        }

        public void setup(long pos, long limit) {
            ((MyBufferedIS)this.in).setup(pos, limit);
        }
    }
}

