/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class CompactDataOutput
implements DataOutput {
    private final OutputStream out;
    private final byte[] writeBuffer = IOUtil.allocReadWriteUTFBuffer();

    public CompactDataOutput(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.out.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.out.write(b2, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }

    @Override
    public void writeInt(int val) throws IOException {
        DataInputOutputUtil.writeINT(this, val);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)(v >>> 0);
        this.out.write(this.writeBuffer, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            this.out.write((byte)s.charAt(i2));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char v = s.charAt(i2);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        IOUtil.writeUTFFast(this.writeBuffer, this, s);
    }
}

