/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.io.ByteBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.ResizeableMappedFile;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class IntToIntBtree {
    private static final int HAS_ZERO_KEY_MASK = -16777216;
    static final boolean doSanityCheck = false;
    static final boolean doDump = false;
    final int pageSize;
    private final short maxInteriorNodes;
    private final short maxLeafNodes;
    private final short maxLeafNodesInHash;
    final BtreeRootNode root;
    private int height;
    private int maxStepsSearchedInHash;
    private int totalHashStepsSearched;
    private int hashSearchRequests;
    private int pagesCount;
    private int hashedPagesCount;
    private int count;
    private int movedMembersCount;
    private boolean hasZeroKey;
    private int zeroKeyValue;
    private final boolean isLarge = true;
    private final ResizeableMappedFile storage;
    private final boolean offloadToSiblingsBeforeSplit = false;
    private final boolean indexNodeIsHashTable = true;
    final int metaDataLeafPageLength;
    final int hashPageCapacity;
    private static final boolean hasCachedMappings = false;
    private TIntIntHashMap myCachedMappings;
    private final int myCachedMappingsSize;
    private BtreeIndexNodeView myAccessNodeView;
    private int myLastGetKey;
    private int myOptimizedInserts;
    private boolean myCanUseLastKey;

    public static int version() {
        return 4 + (IOUtil.ourByteBuffersUseNativeByteOrder ? 255 : 0);
    }

    public IntToIntBtree(int pageSize, @NotNull File file2, @NotNull PagedFileStorage.StorageLockContext storageLockContext, boolean initial) throws IOException {
        if (file2 == null) {
            IntToIntBtree.$$$reportNull$$$0(0);
        }
        if (storageLockContext == null) {
            IntToIntBtree.$$$reportNull$$$0(1);
        }
        this.isLarge = true;
        this.offloadToSiblingsBeforeSplit = false;
        this.indexNodeIsHashTable = true;
        this.pageSize = pageSize;
        if (initial) {
            FileUtil.delete(file2);
        }
        this.storage = new ResizeableMappedFile(file2, pageSize, storageLockContext, 0x100000, true, IOUtil.ourByteBuffersUseNativeByteOrder);
        this.root = new BtreeRootNode(this);
        if (initial) {
            this.nextPage();
            this.root.setAddress(0);
            this.root.getNodeView().setIndexLeaf(true);
        }
        int i2 = (this.pageSize - 8) / 8 - 1;
        assert (i2 < Short.MAX_VALUE && i2 % 2 == 0);
        this.maxInteriorNodes = (short)i2;
        this.maxLeafNodes = (short)i2;
        ++i2;
        while (!IntToIntBtree.isPrime(i2)) {
            i2 -= 2;
        }
        this.hashPageCapacity = i2;
        int metaPageLen = 8;
        i2 = (int)((double)this.hashPageCapacity * 0.9);
        if ((i2 & 1) == 1) {
            ++i2;
        }
        this.metaDataLeafPageLength = metaPageLen;
        assert (i2 > 0 && i2 % 2 == 0);
        this.maxLeafNodesInHash = (short)i2;
        this.myCachedMappings = null;
        this.myCachedMappingsSize = -1;
    }

    public int persistVars(@NotNull BtreeDataStorage storage2, boolean toDisk) {
        if (storage2 == null) {
            IntToIntBtree.$$$reportNull$$$0(2);
        }
        int i2 = storage2.persistInt(0, this.height | (this.hasZeroKey ? -16777216 : 0), toDisk);
        this.hasZeroKey = (i2 & 0xFF000000) != 0;
        this.height = i2 & 0xFFFFFF;
        this.pagesCount = storage2.persistInt(4, this.pagesCount, toDisk);
        this.movedMembersCount = storage2.persistInt(8, this.movedMembersCount, toDisk);
        this.maxStepsSearchedInHash = storage2.persistInt(12, this.maxStepsSearchedInHash, toDisk);
        this.count = storage2.persistInt(16, this.count, toDisk);
        this.hashSearchRequests = storage2.persistInt(20, this.hashSearchRequests, toDisk);
        this.totalHashStepsSearched = storage2.persistInt(24, this.totalHashStepsSearched, toDisk);
        this.hashedPagesCount = storage2.persistInt(28, this.hashedPagesCount, toDisk);
        this.root.setAddress(storage2.persistInt(32, this.root.address, toDisk));
        this.zeroKeyValue = storage2.persistInt(36, this.zeroKeyValue, toDisk);
        return 40;
    }

    private static boolean isPrime(int val) {
        if (val % 2 == 0) {
            return false;
        }
        int maxDivisor = (int)Math.sqrt(val);
        for (int i2 = 3; i2 <= maxDivisor; i2 += 2) {
            if (val % i2 != 0) continue;
            return false;
        }
        return true;
    }

    private int nextPage() {
        int pageStart = (int)this.storage.length();
        this.storage.putInt(pageStart + this.pageSize - 4, 0);
        ++this.pagesCount;
        return pageStart;
    }

    public boolean get(int key, @NotNull int[] result2) {
        if (result2 == null) {
            IntToIntBtree.$$$reportNull$$$0(3);
        }
        if (key == 0) {
            if (this.hasZeroKey) {
                result2[0] = this.zeroKeyValue;
                return true;
            }
            return false;
        }
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(this);
        }
        this.myAccessNodeView.initTraversal(this.root.address);
        int index2 = this.myAccessNodeView.locate(key, false);
        if (index2 < 0) {
            this.myCanUseLastKey = true;
            this.myLastGetKey = key;
            return false;
        }
        this.myCanUseLastKey = false;
        result2[0] = this.myAccessNodeView.addressAt(index2);
        return true;
    }

    public void put(int key, int value) {
        if (key == 0) {
            this.hasZeroKey = true;
            this.zeroKeyValue = value;
            return;
        }
        boolean canUseLastKey = this.myCanUseLastKey;
        if (canUseLastKey) {
            this.myCanUseLastKey = false;
            if (key == this.myLastGetKey && !this.myAccessNodeView.myHasFullPagesAlongPath && this.myAccessNodeView.isValid()) {
                ++this.myOptimizedInserts;
                ++this.count;
                this.myAccessNodeView.insert(key, value);
                return;
            }
        }
        this.doPut(key, value);
    }

    private void doPut(int key, int value) {
        if (this.myAccessNodeView == null) {
            this.myAccessNodeView = new BtreeIndexNodeView(this);
        }
        this.myAccessNodeView.initTraversal(this.root.address);
        int index2 = this.myAccessNodeView.locate(key, true);
        if (index2 < 0) {
            ++this.count;
            this.myAccessNodeView.insert(key, value);
        } else {
            this.myAccessNodeView.setAddressAt(index2, value);
            if (!this.myAccessNodeView.myIsDirty) {
                this.myAccessNodeView.markDirty();
            }
        }
    }

    void dumpStatistics() {
        int leafPages = this.height == 3 ? this.pagesCount - (1 + this.root.getNodeView().getChildrenCount() + 1) : (this.height == 2 ? this.pagesCount - 1 : 1);
        long leafNodesCapacity = this.hashedPagesCount * this.maxLeafNodesInHash + (leafPages - this.hashedPagesCount) * this.maxLeafNodes;
        long leafNodesCapacity2 = leafPages * this.maxLeafNodes;
        int usedPercent = (int)((long)this.count * 100L / leafNodesCapacity);
        int usedPercent2 = (int)((long)this.count * 100L / leafNodesCapacity2);
        IOStatistics.dump("pagecount:" + this.pagesCount + ", height:" + this.height + ", movedMembers:" + this.movedMembersCount + ", optimized inserts:" + this.myOptimizedInserts + ", hash steps:" + this.maxStepsSearchedInHash + ", avg search in hash:" + (this.hashSearchRequests != 0 ? this.totalHashStepsSearched / this.hashSearchRequests : 0) + ", leaf pages used:" + usedPercent + "%, leaf pages used if sorted: " + usedPercent2 + "%, size:" + this.storage.length());
    }

    private void flushCachedMappings() {
    }

    public void doClose() throws IOException {
        this.myCachedMappings = null;
        this.storage.close();
    }

    public void doFlush() {
        this.flushCachedMappings();
        this.storage.force();
    }

    static void myAssert(boolean b2) {
        if (!b2) {
            IntToIntBtree.myAssert(true);
        }
        assert (b2);
    }

    public boolean processMappings(@NotNull KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(4);
        }
        this.doFlush();
        this.root.syncWithStore();
        if (this.hasZeroKey && !processor.process(0, this.zeroKeyValue)) {
            return false;
        }
        return this.processLeafPages(this.root.getNodeView(), processor);
    }

    private boolean processLeafPages(@NotNull BtreeIndexNodeView node, @NotNull KeyValueProcessor processor) throws IOException {
        if (node == null) {
            IntToIntBtree.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            IntToIntBtree.$$$reportNull$$$0(6);
        }
        if (node.isIndexLeaf()) {
            return node.processMappings(processor);
        }
        int[] childrenAddresses = new int[node.getChildrenCount() + 1];
        for (int i2 = 0; i2 < childrenAddresses.length; ++i2) {
            childrenAddresses[i2] = -node.addressAt(i2);
        }
        if (childrenAddresses.length > 0) {
            BtreeIndexNodeView child = new BtreeIndexNodeView(this);
            for (int childrenAddress : childrenAddresses) {
                child.setAddress(childrenAddress);
                if (this.processLeafPages(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/IntToIntBtree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "persistVars";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processMappings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processLeafPages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class KeyValueProcessor {
        public abstract boolean process(int var1, int var2) throws IOException;
    }

    private static class BtreeIndexNodeView
    extends BtreePage {
        static final int INTERIOR_SIZE = 8;
        static final int KEY_OFFSET = 4;
        static final int MIN_ITEMS_TO_SHARE = 20;
        private boolean isIndexLeaf;
        private boolean isHashedLeaf;
        private static final int LARGE_MOVE_THRESHOLD = 5;
        private static final int HASH_FREE = 0;
        static final int INDEX_LEAF_MASK = 1;
        static final int HASHED_LEAF_MASK = 2;
        private static final boolean useDoubleHash = true;

        BtreeIndexNodeView(IntToIntBtree btree) {
            super(btree);
        }

        private int search(int value) {
            if (this.isIndexLeaf() && this.isHashedLeaf()) {
                return this.hashIndex(value);
            }
            int hi = this.getChildrenCount() - 1;
            int lo = 0;
            while (lo <= hi) {
                int mid = lo + (hi - lo) / 2;
                int keyAtMid = this.keyAt(mid);
                if (value > keyAtMid) {
                    lo = mid + 1;
                    continue;
                }
                if (value < keyAtMid) {
                    hi = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(lo + 1);
        }

        final int addressAt(int i2) {
            return this.getInt(this.indexToOffset(i2));
        }

        private void setAddressAt(int i2, int value) {
            int offset2 = this.indexToOffset(i2);
            this.putInt(offset2, value);
        }

        private int indexToOffset(int i2) {
            return i2 * 8 + (this.isHashedLeaf() ? this.btree.metaDataLeafPageLength : 8);
        }

        private int keyAt(int i2) {
            return this.getInt(this.indexToOffset(i2) + 4);
        }

        private void setKeyAt(int i2, int value) {
            int offset2 = this.indexToOffset(i2) + 4;
            this.putInt(offset2, value);
        }

        final boolean isIndexLeaf() {
            return this.isIndexLeaf;
        }

        @Override
        protected void doInitFlags(int flags) {
            super.doInitFlags(flags);
            flags = flags >> 24 & 0xFF;
            this.isHashedLeaf = BitUtil.isSet(flags, 2);
            this.isIndexLeaf = BitUtil.isSet(flags, 1);
        }

        void setIndexLeaf(boolean value) {
            this.isIndexLeaf = value;
            this.setFlag(1, value);
        }

        private boolean isHashedLeaf() {
            return this.isHashedLeaf;
        }

        void setHashedLeaf(boolean value) {
            this.isHashedLeaf = value;
            this.setFlag(2, value);
        }

        final short getMaxChildrenCount() {
            return this.isIndexLeaf() ? (this.isHashedLeaf() ? this.btree.maxLeafNodesInHash : this.btree.maxLeafNodes) : this.btree.maxInteriorNodes;
        }

        final boolean isFull() {
            short childrenCount = this.getChildrenCount();
            if (!this.isIndexLeaf()) {
                childrenCount = (short)(childrenCount + 1);
            }
            return childrenCount == this.getMaxChildrenCount();
        }

        boolean processMappings(KeyValueProcessor processor) throws IOException {
            assert (this.isIndexLeaf());
            if (this.isHashedLeaf()) {
                int offset2 = this.myAddressInBuffer + this.indexToOffset(0);
                for (int i2 = 0; i2 < this.btree.hashPageCapacity; ++i2) {
                    int key = this.myBuffer.getInt(offset2 + 4);
                    if (key != 0 && !processor.process(key, this.myBuffer.getInt(offset2))) {
                        return false;
                    }
                    offset2 += 8;
                }
            } else {
                int childrenCount = this.getChildrenCount();
                for (int i3 = 0; i3 < childrenCount; ++i3) {
                    if (processor.process(this.keyAt(i3), this.addressAt(i3))) continue;
                    return false;
                }
            }
            return true;
        }

        public void initTraversal(int address2) {
            this.myHasFullPagesAlongPath = false;
            this.setAddress(address2);
        }

        public boolean isValid() {
            return this.myBufferWrapper.getCachedBuffer() == this.myBuffer;
        }

        private int splitNode(int parentAddress) {
            boolean indexLeaf = this.isIndexLeaf();
            boolean hashedLeaf = this.isHashedLeaf();
            short recordCount = this.getChildrenCount();
            BtreeIndexNodeView parent2 = null;
            HashLeafData hashLeafData = null;
            if (parentAddress != 0) {
                parent2 = new BtreeIndexNodeView(this.btree);
                parent2.setAddress(parentAddress);
            }
            short maxIndex = (short)(this.getMaxChildrenCount() / 2);
            BtreeIndexNodeView newIndexNode = new BtreeIndexNodeView(this.btree);
            newIndexNode.setAddress(this.btree.nextPage());
            this.syncWithStore();
            if (parent2 != null) {
                parent2.syncWithStore();
            }
            this.btree.root.syncWithStore();
            newIndexNode.setIndexLeaf(indexLeaf);
            int nextPage = this.getNextPage();
            this.setNextPage(newIndexNode.address);
            newIndexNode.setNextPage(nextPage);
            int medianKey = -1;
            if (indexLeaf && hashedLeaf) {
                if (hashLeafData == null) {
                    hashLeafData = new HashLeafData(this, recordCount);
                }
                int[] keys2 = hashLeafData.keys;
                boolean defaultSplit = true;
                if (defaultSplit) {
                    hashLeafData.clean();
                    TIntIntHashMap map2 = hashLeafData.values;
                    int avg = keys2.length / 2;
                    medianKey = keys2[avg];
                    --this.btree.hashedPagesCount;
                    this.setChildrenCount((short)0);
                    newIndexNode.setChildrenCount((short)0);
                    for (int i2 = 0; i2 < avg; ++i2) {
                        int key = keys2[i2];
                        this.insert(key, map2.get(key));
                        key = keys2[avg + i2];
                        newIndexNode.insert(key, map2.get(key));
                    }
                }
            } else {
                short recordCountInNewNode = (short)(recordCount - maxIndex);
                newIndexNode.setChildrenCount(recordCountInNewNode);
                ByteBuffer buffer = this.getBytes(this.indexToOffset(maxIndex), recordCountInNewNode * 8);
                newIndexNode.putBytes(newIndexNode.indexToOffset(0), buffer);
                if (indexLeaf) {
                    medianKey = newIndexNode.keyAt(0);
                } else {
                    newIndexNode.setAddressAt(recordCountInNewNode, this.addressAt(recordCount));
                    maxIndex = (short)(maxIndex - 1);
                    medianKey = this.keyAt(maxIndex);
                }
                this.setChildrenCount(maxIndex);
            }
            if (parent2 != null) {
                parent2.insert(medianKey, -newIndexNode.address);
            } else {
                int newRootAddress = this.btree.nextPage();
                newIndexNode.syncWithStore();
                this.syncWithStore();
                this.btree.root.setAddress(newRootAddress);
                parentAddress = newRootAddress;
                BtreeIndexNodeView rootNodeView = this.btree.root.getNodeView();
                rootNodeView.setChildrenCount((short)1);
                rootNodeView.setKeyAt(0, medianKey);
                rootNodeView.setAddressAt(0, -this.address);
                rootNodeView.setAddressAt(1, -newIndexNode.address);
            }
            return parentAddress;
        }

        private boolean doOffloadToSiblingsWhenHashed(BtreeIndexNodeView parent2, HashLeafData hashLeafData) {
            int indexInParent = parent2.search(hashLeafData.keys[0]);
            if (indexInParent >= 0) {
                BtreeIndexNodeView sibling = new BtreeIndexNodeView(this.btree);
                sibling.setAddress(-parent2.addressAt(indexInParent));
                int numberOfKeysToMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
                if (!sibling.isFull() && numberOfKeysToMove > 20) {
                    int key;
                    int i2;
                    short childrenCount = this.getChildrenCount();
                    int[] keys2 = hashLeafData.keys;
                    TIntIntHashMap map2 = hashLeafData.values;
                    for (i2 = 0; i2 < numberOfKeysToMove; ++i2) {
                        key = keys2[i2];
                        sibling.insert(key, map2.get(key));
                    }
                    parent2.setKeyAt(indexInParent, keys2[numberOfKeysToMove]);
                    if (!parent2.myIsDirty) {
                        parent2.markDirty();
                    }
                    this.setChildrenCount((short)0);
                    --this.btree.hashedPagesCount;
                    hashLeafData.clean();
                    for (i2 = numberOfKeysToMove; i2 < childrenCount; ++i2) {
                        key = keys2[i2];
                        this.insert(key, map2.get(key));
                    }
                } else if (indexInParent + 1 < parent2.getChildrenCount()) {
                    this.insertToRightSiblingWhenHashed(parent2, hashLeafData, indexInParent, sibling);
                }
            } else if (indexInParent == -1) {
                this.insertToRightSiblingWhenHashed(parent2, hashLeafData, 0, new BtreeIndexNodeView(this.btree));
            }
            return !this.isFull();
        }

        private void insertToRightSiblingWhenHashed(BtreeIndexNodeView parent2, HashLeafData hashLeafData, int indexInParent, BtreeIndexNodeView sibling) {
            sibling.setAddress(-parent2.addressAt(indexInParent + 1));
            int numberOfKeysToMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
            if (!sibling.isFull() && numberOfKeysToMove > 20) {
                int key;
                int lastChildIndex;
                int i2;
                int[] keys2 = hashLeafData.keys;
                TIntIntHashMap map2 = hashLeafData.values;
                short childrenCount = this.getChildrenCount();
                for (i2 = lastChildIndex = childrenCount - numberOfKeysToMove; i2 < childrenCount; ++i2) {
                    key = keys2[i2];
                    sibling.insert(key, map2.get(key));
                }
                parent2.setKeyAt(indexInParent, keys2[lastChildIndex]);
                if (!parent2.myIsDirty) {
                    parent2.markDirty();
                }
                this.setChildrenCount((short)0);
                --this.btree.hashedPagesCount;
                hashLeafData.clean();
                for (i2 = 0; i2 < lastChildIndex; ++i2) {
                    key = keys2[i2];
                    this.insert(key, map2.get(key));
                }
            }
        }

        private boolean doOffloadToSiblingsSorted(BtreeIndexNodeView parent2) {
            if (!this.isIndexLeaf()) {
                return false;
            }
            int indexInParent = parent2.search(this.keyAt(0));
            if (indexInParent >= 0) {
                BtreeIndexNodeView sibling = new BtreeIndexNodeView(this.btree);
                sibling.setAddress(-parent2.addressAt(indexInParent));
                int toMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
                if (toMove > 0) {
                    for (int i2 = 0; i2 < toMove; ++i2) {
                        sibling.insert(this.keyAt(i2), this.addressAt(i2));
                    }
                    parent2.setKeyAt(indexInParent, this.keyAt(toMove));
                    if (!parent2.myIsDirty) {
                        parent2.markDirty();
                    }
                    int indexOfLastChildToMove = this.getChildrenCount() - toMove;
                    IntToIntBtree intToIntBtree = this.btree;
                    intToIntBtree.movedMembersCount = intToIntBtree.movedMembersCount + indexOfLastChildToMove;
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(toMove), indexOfLastChildToMove * 8);
                    this.putBytes(this.indexToOffset(0), buffer);
                    this.setChildrenCount((short)indexOfLastChildToMove);
                } else if (indexInParent + 1 < parent2.getChildrenCount()) {
                    this.insertToRightSiblingWhenSorted(parent2, indexInParent + 1, sibling);
                }
            } else if (indexInParent == -1) {
                this.insertToRightSiblingWhenSorted(parent2, 0, new BtreeIndexNodeView(this.btree));
            }
            return !this.isFull();
        }

        private void insertToRightSiblingWhenSorted(BtreeIndexNodeView parent2, int indexInParent, BtreeIndexNodeView sibling) {
            sibling.setAddress(-parent2.addressAt(indexInParent + 1));
            int toMove = (sibling.getMaxChildrenCount() - sibling.getChildrenCount()) / 2;
            if (toMove > 0) {
                int lastChildIndex;
                short childrenCount = this.getChildrenCount();
                for (int i2 = lastChildIndex = childrenCount - toMove; i2 < childrenCount; ++i2) {
                    sibling.insert(this.keyAt(i2), this.addressAt(i2));
                }
                parent2.setKeyAt(indexInParent, this.keyAt(lastChildIndex));
                if (!parent2.myIsDirty) {
                    parent2.markDirty();
                }
                this.setChildrenCount((short)lastChildIndex);
            }
        }

        protected void dump(String s) {
        }

        private void immediateDump(String s) {
            int maxIndex = this.getChildrenCount();
            System.out.println(s + " @" + this.address);
            for (int i2 = 0; i2 < maxIndex; ++i2) {
                System.out.print(this.addressAt(i2) + " " + this.keyAt(i2) + " ");
            }
            if (!this.isIndexLeaf()) {
                System.out.println(this.addressAt(maxIndex));
            } else {
                System.out.println();
            }
        }

        private int locate(int valueHC, boolean split) {
            int searched = 0;
            int parentAddress = 0;
            int maxHeight = this.btree.height + 1;
            while (true) {
                if (this.isFull()) {
                    if (split) {
                        if ((parentAddress = this.splitNode(parentAddress)) != 0) {
                            this.setAddress(parentAddress);
                        }
                        --searched;
                    } else {
                        this.myHasFullPagesAlongPath = true;
                    }
                }
                int i2 = this.search(valueHC);
                if (++searched > maxHeight) {
                    throw new IllegalStateException();
                }
                if (this.isIndexLeaf()) {
                    this.btree.height = Math.max(this.btree.height, searched);
                    return i2;
                }
                int address2 = i2 < 0 ? this.addressAt(-i2 - 1) : this.addressAt(i2 + 1);
                parentAddress = this.address;
                this.setAddress(-address2);
            }
        }

        private void insert(int valueHC, int newValueId) {
            short recordCount = this.getChildrenCount();
            boolean indexLeaf = this.isIndexLeaf();
            if (indexLeaf) {
                if (recordCount == 0) {
                    this.setHashedLeaf(true);
                    ++this.btree.hashedPagesCount;
                }
                if (this.isHashedLeaf()) {
                    int index2 = this.hashIndex(valueHC);
                    if (index2 < 0) {
                        index2 = -index2 - 1;
                    }
                    this.setKeyAt(index2, valueHC);
                    this.setAddressAt(index2, newValueId);
                    this.setChildrenCount((short)(recordCount + 1));
                    return;
                }
            }
            int medianKeyInParent = this.search(valueHC);
            int index3 = -medianKeyInParent - 1;
            this.setChildrenCount((short)(recordCount + 1));
            int itemsToMove = recordCount - index3;
            IntToIntBtree intToIntBtree = this.btree;
            intToIntBtree.movedMembersCount = intToIntBtree.movedMembersCount + itemsToMove;
            if (indexLeaf) {
                if (itemsToMove > 5) {
                    ByteBuffer buffer = this.getBytes(this.indexToOffset(index3), itemsToMove * 8);
                    this.putBytes(this.indexToOffset(index3 + 1), buffer);
                } else {
                    for (int i2 = recordCount - 1; i2 >= index3; --i2) {
                        this.setKeyAt(i2 + 1, this.keyAt(i2));
                        this.setAddressAt(i2 + 1, this.addressAt(i2));
                    }
                }
                this.setKeyAt(index3, valueHC);
                this.setAddressAt(index3, newValueId);
            } else {
                this.setAddressAt(recordCount + 1, this.addressAt(recordCount));
                if (itemsToMove > 5) {
                    int elementsAfterIndex = recordCount - index3 - 1;
                    if (elementsAfterIndex > 0) {
                        ByteBuffer buffer = this.getBytes(this.indexToOffset(index3 + 1), elementsAfterIndex * 8);
                        this.putBytes(this.indexToOffset(index3 + 2), buffer);
                    }
                } else {
                    for (int i3 = recordCount - 1; i3 > index3; --i3) {
                        this.setKeyAt(i3 + 1, this.keyAt(i3));
                        this.setAddressAt(i3 + 1, this.addressAt(i3));
                    }
                }
                if (index3 < recordCount) {
                    this.setKeyAt(index3 + 1, this.keyAt(index3));
                }
                this.setKeyAt(index3, valueHC);
                this.setAddressAt(index3 + 1, newValueId);
            }
        }

        private int hashIndex(int value) {
            int length = this.btree.hashPageCapacity;
            int hash = value & Integer.MAX_VALUE;
            int index2 = hash % length;
            int keyAtIndex = this.keyAt(index2);
            this.btree.hashSearchRequests++;
            int total = 0;
            if (keyAtIndex != value && keyAtIndex != 0) {
                int probe = 1 + hash % (length - 2);
                do {
                    if ((index2 -= probe) < 0) {
                        index2 += length;
                    }
                    keyAtIndex = this.keyAt(index2);
                    if (++total <= length) continue;
                    throw new IllegalStateException("Index corrupted");
                } while (keyAtIndex != value && keyAtIndex != 0);
            }
            this.btree.maxStepsSearchedInHash = Math.max(this.btree.maxStepsSearchedInHash, total);
            IntToIntBtree intToIntBtree = this.btree;
            intToIntBtree.totalHashStepsSearched = intToIntBtree.totalHashStepsSearched + total;
            return keyAtIndex == 0 ? -index2 - 1 : index2;
        }

        private static class HashLeafData {
            final BtreeIndexNodeView nodeView;
            final int[] keys;
            final TIntIntHashMap values;

            HashLeafData(BtreeIndexNodeView _nodeView, int recordCount) {
                this.nodeView = _nodeView;
                IntToIntBtree btree = _nodeView.btree;
                int offset2 = this.nodeView.myAddressInBuffer + this.nodeView.indexToOffset(0);
                ByteBuffer buffer = this.nodeView.myBuffer;
                this.keys = new int[recordCount];
                this.values = new TIntIntHashMap(recordCount);
                int keyNumber = 0;
                for (int i2 = 0; i2 < btree.hashPageCapacity; ++i2) {
                    int key = buffer.getInt(offset2 + 4);
                    if (key != 0) {
                        int value = buffer.getInt(offset2);
                        if (keyNumber == this.keys.length) {
                            throw new IllegalStateException("Index corrupted");
                        }
                        this.keys[keyNumber++] = key;
                        this.values.put(key, value);
                    }
                    offset2 += 8;
                }
                Arrays.sort(this.keys);
            }

            private void clean() {
                IntToIntBtree btree = this.nodeView.btree;
                for (int i2 = 0; i2 < btree.hashPageCapacity; ++i2) {
                    this.nodeView.setKeyAt(i2, 0);
                }
            }
        }
    }

    static class BtreePage {
        static final int RESERVED_META_PAGE_LEN = 8;
        static final int FLAGS_SHIFT = 24;
        static final int LENGTH_SHIFT = 8;
        static final int LENGTH_MASK = 65535;
        protected final IntToIntBtree btree;
        protected int address = -1;
        private short myChildrenCount;
        protected int myAddressInBuffer;
        protected ByteBuffer myBuffer;
        protected ByteBufferWrapper myBufferWrapper;
        protected boolean myHasFullPagesAlongPath;
        protected boolean myIsDirty;

        public BtreePage(IntToIntBtree btree) {
            this.btree = btree;
            this.myChildrenCount = (short)-1;
        }

        void setAddress(int _address) {
            this.setAddressInternal(_address);
            this.syncWithStore();
        }

        private final void setAddressInternal(int _address) {
            this.address = _address;
        }

        protected void syncWithStore() {
            PagedFileStorage pagedFileStorage = this.btree.storage.getPagedFileStorage();
            this.myAddressInBuffer = pagedFileStorage.getOffsetInPage(this.address);
            this.myBufferWrapper = pagedFileStorage.getByteBuffer(this.address, false);
            this.myBuffer = this.myBufferWrapper.getCachedBuffer();
            this.myIsDirty = false;
            this.doInitFlags(this.myBuffer.getInt(this.myAddressInBuffer));
        }

        protected void doInitFlags(int anInt) {
            this.myChildrenCount = (short)(anInt >>> 8 & 0xFFFF);
        }

        protected final void setFlag(int mask, boolean flag) {
            int anInt = this.myBuffer.getInt(this.myAddressInBuffer);
            anInt = flag ? (anInt |= mask) : (anInt &= ~(mask <<= 24));
            this.myBuffer.putInt(this.myAddressInBuffer, anInt);
            if (!this.myIsDirty) {
                this.markDirty();
            }
        }

        void markDirty() {
            this.btree.storage.getPagedFileStorage().getByteBuffer(this.address, true);
            this.myIsDirty = true;
        }

        protected final short getChildrenCount() {
            return this.myChildrenCount;
        }

        protected final void setChildrenCount(short value) {
            this.myChildrenCount = value;
            int myValue = this.myBuffer.getInt(this.myAddressInBuffer);
            myValue &= 0xFF000000;
            this.myBuffer.putInt(this.myAddressInBuffer, myValue |= value << 8);
            if (!this.myIsDirty) {
                this.markDirty();
            }
        }

        protected final void setNextPage(int nextPage) {
            this.putInt(4, nextPage);
        }

        protected final int getNextPage() {
            return this.getInt(4);
        }

        protected final int getInt(int address2) {
            return this.myBuffer.getInt(this.myAddressInBuffer + address2);
        }

        protected final void putInt(int offset2, int value) {
            this.myBuffer.putInt(this.myAddressInBuffer + offset2, value);
        }

        protected final ByteBuffer getBytes(int address2, int length) {
            ByteBuffer duplicate = this.myBuffer.duplicate();
            duplicate.order(this.myBuffer.order());
            int newPosition = address2 + this.myAddressInBuffer;
            duplicate.position(newPosition);
            duplicate.limit(newPosition + length);
            return duplicate;
        }

        protected final void putBytes(int address2, ByteBuffer buffer) {
            this.myBuffer.position(address2 + this.myAddressInBuffer);
            this.myBuffer.put(buffer);
        }
    }

    static class BtreeRootNode {
        int address;
        final BtreeIndexNodeView nodeView;
        boolean initialized;

        BtreeRootNode(IntToIntBtree btree) {
            this.nodeView = new BtreeIndexNodeView(btree);
        }

        void setAddress(int _address) {
            this.address = _address;
            this.initialized = false;
        }

        protected void syncWithStore() {
            this.nodeView.setAddress(this.address);
            this.initialized = true;
        }

        public BtreeIndexNodeView getNodeView() {
            if (!this.initialized) {
                this.syncWithStore();
            }
            return this.nodeView;
        }
    }

    public static interface BtreeDataStorage {
        public int persistInt(int var1, int var2, boolean var3);
    }
}

