/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SafeFileOutputStream
extends OutputStream {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.SafeFileOutputStream");
    private static final boolean DO_SYNC = Registry.is("idea.io.safe.sync");
    private static final String EXTENSION_TMP = "___jb_tmp___";
    private static final String EXTENSION_OLD = "___jb_old___";
    private final File myTargetFile;
    private final boolean myPreserveAttributes;
    private final File myTempFile;
    private final FileOutputStream myOutputStream;
    private boolean myFailed = false;

    public SafeFileOutputStream(File target) throws FileNotFoundException {
        this(target, false);
    }

    public SafeFileOutputStream(File target, boolean preserveAttributes) throws FileNotFoundException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(">> " + target);
        }
        this.myTargetFile = target;
        this.myPreserveAttributes = preserveAttributes;
        this.myTempFile = new File(this.myTargetFile.getPath() + EXTENSION_TMP);
        this.myOutputStream = new FileOutputStream(this.myTempFile);
    }

    @Override
    public void write(int b2) throws IOException {
        try {
            this.myOutputStream.write(b2);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        try {
            this.myOutputStream.write(b2, off, len);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myOutputStream.flush();
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.myFailed && DO_SYNC) {
            try {
                this.myOutputStream.getFD().sync();
            }
            catch (IOException e) {
                LOG.warn(e);
                this.myFailed = true;
            }
        }
        try {
            this.myOutputStream.close();
        }
        catch (IOException e) {
            LOG.warn(e);
            this.myFailed = true;
        }
        if (this.myFailed) {
            FileUtil.delete(this.myTempFile);
            throw new IOException(CommonBundle.message("safe.write.failed", this.myTargetFile, this.myTempFile.getName()));
        }
        File oldFile = new File(this.myTargetFile.getParent(), this.myTargetFile.getName() + EXTENSION_OLD);
        if (oldFile.exists() && !FileUtil.delete(oldFile)) {
            FileUtil.delete(this.myTempFile);
            throw new IOException(CommonBundle.message("safe.write.drop.old", this.myTargetFile, oldFile.getName()));
        }
        try {
            FileUtil.rename(this.myTargetFile, oldFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.original", this.myTargetFile, this.myTempFile.getName()));
        }
        try {
            FileUtil.rename(this.myTempFile, this.myTargetFile);
        }
        catch (IOException e) {
            LOG.warn(e);
            throw new IOException(CommonBundle.message("safe.write.rename.backup", this.myTargetFile, oldFile.getName(), this.myTempFile.getName()));
        }
        if (this.myPreserveAttributes) {
            FileSystemUtil.clonePermissions(oldFile.getPath(), this.myTargetFile.getPath());
        }
        if (!FileUtil.delete(oldFile)) {
            throw new IOException(CommonBundle.message("safe.write.drop.temp", oldFile));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("<< " + this.myTargetFile);
        }
    }
}

