/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(@NotNull String name) {
        if (name == null) {
            StringRef.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, @NotNull AbstractStringEnumerator store2) {
        if (store2 == null) {
            StringRef.$$$reportNull$$$0(1);
        }
        this.id = id;
        this.store = store2;
        this.name = null;
    }

    public String getString() {
        String name = this.name;
        if (name == null) {
            try {
                this.name = name = (String)this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public void writeTo(@NotNull DataOutput out, @NotNull AbstractStringEnumerator store2) throws IOException {
        if (out == null) {
            StringRef.$$$reportNull$$$0(2);
        }
        if (store2 == null) {
            StringRef.$$$reportNull$$$0(3);
        }
        int nameId = this.getId(store2);
        out.writeByte(nameId & 0xFF);
        DataInputOutputUtil.writeINT(out, nameId >> 8);
    }

    public int getId(@NotNull AbstractStringEnumerator store2) {
        if (store2 == null) {
            StringRef.$$$reportNull$$$0(4);
        }
        if (this.id == -1) {
            try {
                this.id = store2.enumerate(this.name);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.id;
    }

    public String toString() {
        return this.getString();
    }

    public int length() {
        return this.getString().length();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    @Contract(value="null -> null")
    public static String toString(@Nullable StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static StringRef fromString(@Nullable String source2) {
        return source2 == null ? null : new StringRef(source2);
    }

    @NotNull
    public static StringRef fromNullableString(@Nullable String source2) {
        StringRef stringRef = new StringRef(source2 == null ? "" : source2);
        if (stringRef == null) {
            StringRef.$$$reportNull$$$0(5);
        }
        return stringRef;
    }

    @Nullable
    public static StringRef fromStream(@NotNull DataInput in, @NotNull AbstractStringEnumerator store2) throws IOException {
        int nameId;
        if (in == null) {
            StringRef.$$$reportNull$$$0(6);
        }
        if (store2 == null) {
            StringRef.$$$reportNull$$$0(7);
        }
        return (nameId = DataInputOutputUtil.readINT(in)) != 0 ? new StringRef(nameId, store2) : null;
    }

    @NotNull
    public static StringRef[] createArray(int count2) {
        StringRef[] stringRefArray = count2 == 0 ? EMPTY_ARRAY : new StringRef[count2];
        if (stringRefArray == null) {
            StringRef.$$$reportNull$$$0(8);
        }
        return stringRefArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/StringRef";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/StringRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNullableString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

