/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TarUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.TarUtil");

    private TarUtil() {
    }

    @NotNull
    public static TarArchiveOutputStream getTarGzOutputStream(File zipFile2) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile2);
        GzipCompressorOutputStream gcos = new GzipCompressorOutputStream((OutputStream)fos);
        TarArchiveOutputStream zip2 = new TarArchiveOutputStream((OutputStream)gcos);
        zip2.setLongFileMode(3);
        TarArchiveOutputStream tarArchiveOutputStream = zip2;
        if (tarArchiveOutputStream == null) {
            TarUtil.$$$reportNull$$$0(0);
        }
        return tarArchiveOutputStream;
    }

    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (tos == null) {
            TarUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            TarUtil.$$$reportNull$$$0(2);
        }
        if (relativeName == null) {
            TarUtil.$$$reportNull$$$0(3);
        }
        return TarUtil.addFileToTar(tos, file2, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addFileToTar(@NotNull TarArchiveOutputStream tos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor) throws IOException {
        if (tos == null) {
            TarUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            TarUtil.$$$reportNull$$$0(5);
        }
        if (relativeName == null) {
            TarUtil.$$$reportNull$$$0(6);
        }
        if (contentProcessor == null) {
            TarUtil.$$$reportNull$$$0(7);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        boolean isDir = file2.isDirectory();
        if (isDir) {
            return true;
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file2, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file2 + " as " + relativeName);
        }
        long size = file2.length();
        TarArchiveEntry e = new TarArchiveEntry(relativeName);
        e.setModTime(file2.lastModified());
        e.setSize(size);
        tos.putArchiveEntry((ArchiveEntry)e);
        InputStream is = contentProcessor.getContent(file2);
        try {
            FileUtil.copy(is, (OutputStream)tos);
        }
        finally {
            is.close();
        }
        tos.closeArchiveEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull TarArchiveOutputStream tarOutputStream, @Nullable File tarFile, @NotNull File file2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (tarOutputStream == null) {
            TarUtil.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            TarUtil.$$$reportNull$$$0(9);
        }
        if (relativePath == null) {
            TarUtil.$$$reportNull$$$0(10);
        }
        if (file2.isDirectory()) {
            return TarUtil.addDirToTarRecursively(tarOutputStream, tarFile, file2, relativePath, fileFilter, writtenItemRelativePaths);
        }
        TarUtil.addFileToTar(tarOutputStream, file2, relativePath, writtenItemRelativePaths, fileFilter);
        return true;
    }

    public static boolean addDirToTarRecursively(@NotNull TarArchiveOutputStream outputStream2, @Nullable File tarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children2;
        if (outputStream2 == null) {
            TarUtil.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            TarUtil.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            TarUtil.$$$reportNull$$$0(13);
        }
        if (tarFile != null && FileUtil.isAncestor(dir, tarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            TarUtil.addFileToTar(outputStream2, dir, relativePath, writtenItemRelativePaths, fileFilter);
        }
        if ((children2 = dir.listFiles()) != null) {
            for (File child : children2) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                TarUtil.addFileOrDirRecursively(outputStream2, tarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file2, @NotNull File outputDir2, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (file2 == null) {
            TarUtil.$$$reportNull$$$0(14);
        }
        if (outputDir2 == null) {
            TarUtil.$$$reportNull$$$0(15);
        }
        TarUtil.extract(file2, outputDir2, filenameFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(@NotNull File file2, @NotNull File outputDir2, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        if (file2 == null) {
            TarUtil.$$$reportNull$$$0(16);
        }
        if (outputDir2 == null) {
            TarUtil.$$$reportNull$$$0(17);
        }
        FileInputStream fis = new FileInputStream(file2);
        GzipCompressorInputStream gcis = new GzipCompressorInputStream((InputStream)fis);
        TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)gcis);
        try {
            TarUtil.extract(tis, outputDir2, filenameFilter, overwrite);
        }
        finally {
            fis.close();
        }
    }

    public static void extract(@NotNull TarArchiveInputStream tis, @NotNull File outputDir2, @Nullable FilenameFilter filenameFilter) throws IOException {
        if (tis == null) {
            TarUtil.$$$reportNull$$$0(18);
        }
        if (outputDir2 == null) {
            TarUtil.$$$reportNull$$$0(19);
        }
        TarUtil.extract(tis, outputDir2, filenameFilter, true);
    }

    public static void extract(@NotNull TarArchiveInputStream tis, @NotNull File outputDir2, @Nullable FilenameFilter filenameFilter, boolean overwrite) throws IOException {
        TarArchiveEntry entry;
        if (tis == null) {
            TarUtil.$$$reportNull$$$0(20);
        }
        if (outputDir2 == null) {
            TarUtil.$$$reportNull$$$0(21);
        }
        while ((entry = tis.getNextTarEntry()) != null) {
            File file2 = new File(outputDir2, entry.getName());
            if (filenameFilter != null && !filenameFilter.accept(file2.getParentFile(), file2.getName())) continue;
            TarUtil.extractEntry(entry, (InputStream)tis, outputDir2, overwrite);
        }
    }

    public static void extractEntry(TarArchiveEntry entry, InputStream inputStream, File outputDir2) throws IOException {
        TarUtil.extractEntry(entry, inputStream, outputDir2, true);
    }

    public static void extractEntry(TarArchiveEntry entry, InputStream inputStream, File outputDir2, boolean overwrite) throws IOException {
        boolean isDirectory = entry.isDirectory();
        String relativeName = entry.getName();
        File file2 = new File(outputDir2, relativeName);
        if (file2.exists() && !overwrite) {
            return;
        }
        FileUtil.createParentDirs(file2);
        if (isDirectory) {
            file2.mkdir();
        } else {
            int count2;
            if (entry.getSize() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Tar entries bigger then 2147483647 aren't supported");
            }
            int len = (int)entry.getSize();
            byte[] content2 = new byte[len];
            for (int n = 0; n < len; n += count2) {
                count2 = inputStream.read(content2, n, len - n);
                if (count2 >= 0) continue;
                throw new EOFException();
            }
            FileUtil.writeToFile(file2, content2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, OutputStream out, Map<String, File> relpathToFile) throws IOException {
        TarArchiveInputStream tis = new TarArchiveInputStream(in);
        TarArchiveOutputStream tos = new TarArchiveOutputStream(out);
        try {
            TarArchiveEntry e;
            while ((e = tis.getNextTarEntry()) != null) {
                String name = e.getName();
                if (!relpathToFile.containsKey(name)) {
                    TarArchiveEntry e2 = new TarArchiveEntry(name);
                    e2.setModTime(e.getModTime());
                    e2.setSize(e.getSize());
                    tos.putArchiveEntry((ArchiveEntry)e2);
                    FileUtil.copy((InputStream)tis, (OutputStream)tos);
                    continue;
                }
                File file2 = relpathToFile.get(name);
                relpathToFile.remove(name);
                TarUtil.addFileToTar(tos, file2, name, null, null);
            }
            for (String path2 : relpathToFile.keySet()) {
                File file3 = relpathToFile.get(path2);
                TarUtil.addFileToTar(tos, file3, path2, null, null);
            }
        }
        finally {
            tis.close();
            tos.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/TarUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tos";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarOutputStream";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarGzOutputStream";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/TarUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFileToTar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrDirRecursively";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addDirToTarRecursively";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(File file2) throws IOException {
                return new FileInputStream(file2);
            }
        };

        public InputStream getContent(File var1) throws IOException;
    }
}

