/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PropertyAccessor
implements MutableAccessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor2) {
        this(descriptor2.getName(), descriptor2.getPropertyType(), descriptor2.getReadMethod(), descriptor2.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type2, @NotNull Method readMethod2, @NotNull Method writeMethod2) {
        if (readMethod2 == null) {
            PropertyAccessor.$$$reportNull$$$0(0);
        }
        if (writeMethod2 == null) {
            PropertyAccessor.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myType = type2;
        this.myReadMethod = readMethod2;
        this.myWriteMethod = writeMethod2;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            this.myWriteMethod.setAccessible(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            PropertyAccessor.$$$reportNull$$$0(2);
        }
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            ExceptionUtil.rethrowUnchecked(exception);
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(3);
        }
        try {
            this.myWriteMethod.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            T[] constants;
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && this.myGenericType instanceof Class && ((Class)this.myGenericType).isEnum() && cause.getMessage().contains("Parameter specified as non-null is null:") && (constants = ((Class)this.myGenericType).getEnumConstants()).length > 0) {
                try {
                    Binding.LOG.warn("Cannot set enum value, will be set to first enum value", e);
                    this.myWriteMethod.invoke(host, constants[0]);
                    return;
                }
                catch (IllegalAccessException e1) {
                    throw new XmlSerializationException(e);
                }
                catch (InvocationTargetException e1) {
                    throw new XmlSerializationException(cause);
                }
            }
            throw new XmlSerializationException(cause);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(4);
        }
        this.set(host, value);
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(5);
        }
        this.set(host, value);
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(6);
        }
        this.set(host, value);
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(7);
        }
        this.set(host, value);
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(8);
        }
        this.set(host, value);
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        if (host == null) {
            PropertyAccessor.$$$reportNull$$$0(9);
        }
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        T annotation2;
        if (annotationClass == null) {
            PropertyAccessor.$$$reportNull$$$0(10);
        }
        if ((annotation2 = this.myReadMethod.getAnnotation(annotationClass)) == null) {
            annotation2 = this.myWriteMethod.getAnnotation(annotationClass);
        }
        return annotation2;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }

    @Override
    public void write(Object o, Object value) {
        this.set(o, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xmlb/PropertyAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setBoolean";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setInt";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setShort";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setLong";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setDouble";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setFloat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

