/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.SchemaTypeInfo;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdComplexTypeInfoBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class SchemaTypeInheritanceIndex
extends XmlIndex<Set<SchemaTypeInfo>> {
    private static final ID<String, Set<SchemaTypeInfo>> NAME = ID.create("SchemaTypeInheritance");
    private static final Logger LOG = Logger.getInstance("#com.intellij.xml.index.SchemaTypeInheritanceIndex");

    private static List<Set<SchemaTypeInfo>> getDirectChildrenOfType(Project project, String ns, String name) {
        GlobalSearchScope filter2 = SchemaTypeInheritanceIndex.createFilter(project);
        return FileBasedIndex.getInstance().getValues(NAME, NsPlusTag.INSTANCE.encode(Pair.create(ns, name)), filter2);
    }

    public static BiFunction<String, String, List<Set<SchemaTypeInfo>>> getWorker(Project project, VirtualFile currentFile) {
        return new MyWorker(currentFile, project);
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    @NotNull
    public ID<String, Set<SchemaTypeInfo>> getName() {
        ID<String, Set<SchemaTypeInfo>> iD = NAME;
        if (iD == null) {
            SchemaTypeInheritanceIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public DataIndexer<String, Set<SchemaTypeInfo>, FileContent> getIndexer() {
        DataIndexer<String, Set<SchemaTypeInfo>, FileContent> dataIndexer = new DataIndexer<String, Set<SchemaTypeInfo>, FileContent>(){

            @Override
            @NotNull
            public Map<String, Set<SchemaTypeInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, Set<SchemaTypeInfo>> map2 = new HashMap<String, Set<SchemaTypeInfo>>();
                MultiMap<SchemaTypeInfo, SchemaTypeInfo> multiMap = XsdComplexTypeInfoBuilder.parse(CharArrayUtil.readerFromCharSequence(inputData.getContentAsText()));
                for (SchemaTypeInfo key : multiMap.keySet()) {
                    map2.put(NsPlusTag.INSTANCE.encode(Pair.create(key.getNamespaceUri(), key.getTagName())), new HashSet<SchemaTypeInfo>(multiMap.get(key)));
                }
                HashMap<String, Set<SchemaTypeInfo>> hashMap = map2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xml/index/SchemaTypeInheritanceIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xml/index/SchemaTypeInheritanceIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            SchemaTypeInheritanceIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @Override
    @NotNull
    public DataExternalizer<Set<SchemaTypeInfo>> getValueExternalizer() {
        DataExternalizer<Set<SchemaTypeInfo>> dataExternalizer = new DataExternalizer<Set<SchemaTypeInfo>>(){

            @Override
            public void save(@NotNull DataOutput out, Set<SchemaTypeInfo> value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                DataInputOutputUtil.writeINT(out, value.size());
                for (SchemaTypeInfo key : value) {
                    IOUtil.writeUTF(out, key.getNamespaceUri());
                    IOUtil.writeUTF(out, key.getTagName());
                    out.writeBoolean(key.isIsTypeName());
                }
            }

            @Override
            public Set<SchemaTypeInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                HashSet<SchemaTypeInfo> set = new HashSet<SchemaTypeInfo>();
                int size = DataInputOutputUtil.readINT(in);
                for (int i2 = 0; i2 < size; ++i2) {
                    String nsUri = IOUtil.readUTF(in);
                    String tagName = IOUtil.readUTF(in);
                    boolean isType = in.readBoolean();
                    set.add(new SchemaTypeInfo(tagName, isType, nsUri));
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/index/SchemaTypeInheritanceIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            SchemaTypeInheritanceIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xml/index/SchemaTypeInheritanceIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NsPlusTag {
        private static final NsPlusTag INSTANCE = new NsPlusTag();
        private static final char ourSeparator = ':';

        private NsPlusTag() {
        }

        public String encode(Pair<String, String> pair) {
            return pair.getFirst() + ':' + pair.getSecond();
        }

        public Pair<String, String> decode(String s) {
            int i2 = s.indexOf(58);
            return i2 <= 0 ? Pair.create("", s) : Pair.create(s.substring(0, i2), s.substring(i2 + 1));
        }
    }

    private static class MyWorker
    implements BiFunction<String, String, List<Set<SchemaTypeInfo>>> {
        private final Project myProject;
        private final VirtualFile myCurrentFile;
        private final GlobalSearchScope myFilter;
        private final boolean myShouldParseCurrent;
        private MultiMap<SchemaTypeInfo, SchemaTypeInfo> myMap;

        private MyWorker(VirtualFile currentFile, Project project) {
            this.myCurrentFile = currentFile;
            this.myProject = project;
            this.myFilter = XmlIndex.createFilter(project);
            this.myShouldParseCurrent = this.myCurrentFile != null && !this.myFilter.contains(this.myCurrentFile);
        }

        @Override
        public List<Set<SchemaTypeInfo>> apply(String ns, String name) {
            List type2 = SchemaTypeInheritanceIndex.getDirectChildrenOfType(this.myProject, ns, name);
            if (this.myShouldParseCurrent && this.myMap == null) {
                try {
                    this.myMap = XsdComplexTypeInfoBuilder.parse(CharArrayUtil.readerFromCharSequence(VfsUtilCore.loadText(this.myCurrentFile)));
                    type2.add(new HashSet<SchemaTypeInfo>(this.myMap.get(new SchemaTypeInfo(name, true, ns))));
                }
                catch (IOException e) {
                    LOG.info(e);
                }
            }
            return type2;
        }
    }
}

