/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInspectionVisitor
extends JavaElementVisitor {
    private BaseInspection inspection = null;
    private boolean onTheFly = false;
    private ProblemsHolder holder = null;

    final void setInspection(BaseInspection inspection) {
        this.inspection = inspection;
    }

    final void setOnTheFly(boolean onTheFly) {
        this.onTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.onTheFly;
    }

    protected final void registerNewExpressionError(@NotNull PsiNewExpression expression2, Object ... infos2) {
        PsiJavaCodeReferenceElement classReference;
        if (expression2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(0);
        }
        if ((classReference = expression2.getClassOrAnonymousClassReference()) == null) {
            return;
        }
        this.registerError((PsiElement)classReference, infos2);
    }

    protected final void registerMethodCallError(@NotNull PsiMethodCallExpression expression2, Object ... infos2) {
        PsiReferenceExpression methodExpression;
        PsiElement nameToken;
        if (expression2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(1);
        }
        if ((nameToken = (methodExpression = expression2.getMethodExpression()).getReferenceNameElement()) == null) {
            return;
        }
        this.registerError(nameToken, infos2);
    }

    protected final void registerStatementError(@NotNull PsiStatement statement2, Object ... infos2) {
        PsiElement statementToken;
        if (statement2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(2);
        }
        if ((statementToken = statement2.getFirstChild()) == null || statementToken.getText().length() == 0) {
            this.registerError((PsiElement)statement2, infos2);
        } else {
            this.registerError(statementToken, infos2);
        }
    }

    protected final void registerModuleError(@NotNull PsiJavaModule module2, Object ... infos2) {
        if (module2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(3);
        }
        this.registerError((PsiElement)module2.getNameIdentifier(), infos2);
    }

    protected final void registerClassError(@NotNull PsiClass aClass2, Object ... infos2) {
        PsiElement nameIdentifier;
        if (aClass2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (aClass2 instanceof PsiEnumConstantInitializer) {
            PsiEnumConstantInitializer enumConstantInitializer = (PsiEnumConstantInitializer)aClass2;
            PsiEnumConstant enumConstant = enumConstantInitializer.getEnumConstant();
            nameIdentifier = enumConstant.getNameIdentifier();
        } else if (aClass2 instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass2;
            nameIdentifier = anonymousClass.getBaseClassReference();
        } else {
            nameIdentifier = aClass2.getNameIdentifier();
        }
        if (nameIdentifier == null) {
            return;
        }
        if (!nameIdentifier.isPhysical()) {
            this.registerError(nameIdentifier.getNavigationElement(), infos2);
            return;
        }
        this.registerError(nameIdentifier, infos2);
    }

    protected final void registerMethodError(@NotNull PsiMethod method, Object ... infos2) {
        PsiIdentifier nameIdentifier;
        if (method == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(5);
        }
        if ((nameIdentifier = method.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos2);
    }

    protected final void registerVariableError(@NotNull PsiVariable variable2, Object ... infos2) {
        PsiIdentifier nameIdentifier;
        if (variable2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(6);
        }
        if ((nameIdentifier = variable2.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos2);
    }

    protected final void registerTypeParameterError(@NotNull PsiTypeParameter typeParameter, Object ... infos2) {
        PsiIdentifier nameIdentifier;
        if (typeParameter == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(7);
        }
        if ((nameIdentifier = typeParameter.getNameIdentifier()) == null) {
            return;
        }
        this.registerError((PsiElement)nameIdentifier, infos2);
    }

    protected final void registerFieldError(@NotNull PsiField field, Object ... infos2) {
        if (field == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(8);
        }
        this.registerError((PsiElement)field.getNameIdentifier(), infos2);
    }

    protected final void registerModifierError(@NotNull String modifier, @NotNull PsiModifierListOwner parameter, Object ... infos2) {
        PsiElement[] children2;
        PsiModifierList modifiers2;
        if (modifier == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (parameter == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(10);
        }
        if ((modifiers2 = parameter.getModifierList()) == null) {
            return;
        }
        for (PsiElement child : children2 = modifiers2.getChildren()) {
            String text2 = child.getText();
            if (!modifier.equals(text2)) continue;
            this.registerError(child, infos2);
        }
    }

    protected final void registerClassInitializerError(@NotNull PsiClassInitializer initializer2, Object ... infos2) {
        PsiCodeBlock body2;
        PsiJavaToken lBrace;
        if (initializer2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(11);
        }
        if ((lBrace = (body2 = initializer2.getBody()).getLBrace()) == null) {
            this.registerError((PsiElement)initializer2, infos2);
        } else {
            this.registerError((PsiElement)lBrace, infos2);
        }
    }

    protected final void registerError(@NotNull PsiElement location2, Object ... infos2) {
        if (location2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(12);
        }
        this.registerError(location2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos2);
    }

    protected final void registerError(@NotNull PsiElement location2, ProblemHighlightType highlightType, Object ... infos2) {
        if (location2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(13);
        }
        assert (location2.getTextLength() != 0 || location2 instanceof PsiFile);
        LocalQuickFix[] fixes = this.createAndInitFixes(infos2);
        String description2 = this.inspection.buildErrorString(infos2);
        this.holder.registerProblem(location2, description2, highlightType, fixes);
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location2, int offset2, int length, Object ... infos2) {
        if (location2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(14);
        }
        this.registerErrorAtOffset(location2, offset2, length, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, infos2);
    }

    protected final void registerErrorAtOffset(@NotNull PsiElement location2, int offset2, int length, ProblemHighlightType highlightType, Object ... infos2) {
        if (location2 == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(15);
        }
        assert (location2.getTextLength() != 0 && length != 0);
        LocalQuickFix[] fixes = this.createAndInitFixes(infos2);
        String description2 = this.inspection.buildErrorString(infos2);
        TextRange range = new TextRange(offset2, offset2 + length);
        this.holder.registerProblem(location2, description2, highlightType, range, fixes);
    }

    protected final void registerErrorAtRange(@NotNull PsiElement startLocation, @NotNull PsiElement endLocation, Object ... infos2) {
        if (startLocation == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(16);
        }
        if (endLocation == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(17);
        }
        if (startLocation.getTextLength() == 0 && startLocation == endLocation) {
            return;
        }
        LocalQuickFix[] fixes = this.createAndInitFixes(infos2);
        String description2 = this.inspection.buildErrorString(infos2);
        ProblemDescriptor problemDescriptor = this.holder.getManager().createProblemDescriptor(startLocation, endLocation, description2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.onTheFly, fixes);
        this.holder.registerProblem(problemDescriptor);
    }

    @NotNull
    private LocalQuickFix[] createAndInitFixes(Object[] infos2) {
        LocalQuickFix[] fixes;
        for (InspectionGadgetsFix inspectionGadgetsFix : fixes = this.createFixes(infos2)) {
            inspectionGadgetsFix.setOnTheFly(this.onTheFly);
        }
        if (fixes == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(18);
        }
        return fixes;
    }

    @NotNull
    private InspectionGadgetsFix[] createFixes(Object ... infos2) {
        if (!this.onTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(19);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        InspectionGadgetsFix[] fixes = this.inspection.buildFixes(infos2);
        if (fixes.length > 0) {
            if (fixes == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(20);
            }
            return fixes;
        }
        InspectionGadgetsFix fix = this.inspection.buildFix(infos2);
        if (fix == null) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                BaseInspectionVisitor.$$$reportNull$$$0(21);
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{fix};
        if (inspectionGadgetsFixArray == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(22);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.visitExpression(expression2);
    }

    public final void setProblemsHolder(ProblemsHolder holder) {
        this.holder = holder;
    }

    protected boolean isVisibleHighlight(@NotNull PsiElement element) {
        if (element == null) {
            BaseInspectionVisitor.$$$reportNull$$$0(23);
        }
        return !this.isOnTheFly() || !InspectionProjectProfileManager.isInformationLevel(this.inspection.getShortName(), element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startLocation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endLocation";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/BaseInspectionVisitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/BaseInspectionVisitor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInitFixes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerNewExpressionError";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodCallError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStatementError";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerModuleError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerClassError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerMethodError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerVariableError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerTypeParameterError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerFieldError";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerModifierError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerClassInitializerError";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerError";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorAtOffset";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorAtRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

