/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReplacementUtil {
    private static final Logger LOG = Logger.getInstance(PsiReplacementUtil.class);

    public static void replaceExpression(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(0);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(1);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory2 = psiFacade.getElementFactory();
        PsiExpression newExpression = factory2.createExpressionFromText(newExpressionText, expression2);
        PsiElement replacementExpression = expression2.replace(newExpression);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        styleManager.reformat(replacementExpression);
    }

    public static PsiElement replaceExpressionAndShorten(@NotNull PsiExpression expression2, @NotNull @NonNls String newExpressionText) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(2);
        }
        if (newExpressionText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(3);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory2 = psiFacade.getElementFactory();
        PsiExpression newExpression = factory2.createExpressionFromText(newExpressionText, expression2);
        PsiElement replacementExp = expression2.replace(newExpression);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance(project);
        javaCodeStyleManager.shortenClassReferences(replacementExp);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static PsiElement replaceStatement(@NotNull PsiStatement statement2, @NotNull @NonNls String newStatementText) {
        if (statement2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(4);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(5);
        }
        Project project = statement2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory2 = psiFacade.getElementFactory();
        PsiStatement newStatement = factory2.createStatementFromText(newStatementText, statement2);
        PsiElement replacementExp = statement2.replace(newStatement);
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        return styleManager.reformat(replacementExp);
    }

    public static void replaceStatementAndShortenClassNames(@NotNull PsiStatement statement2, @NotNull @NonNls String newStatementText) {
        if (statement2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(6);
        }
        if (newStatementText == null) {
            PsiReplacementUtil.$$$reportNull$$$0(7);
        }
        Project project = statement2.getProject();
        CodeStyleManager styleManager = CodeStyleManager.getInstance(project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance(project);
        if (FileTypeUtils.isInServerPageFile(statement2)) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
            PsiFile jspFile = PsiUtilCore.getTemplateLanguageFile(statement2);
            if (jspFile == null) {
                return;
            }
            Document document = documentManager.getDocument(jspFile);
            if (document == null) {
                return;
            }
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            TextRange textRange = statement2.getTextRange();
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), newStatementText);
            documentManager.commitDocument(document);
            FileViewProvider viewProvider = jspFile.getViewProvider();
            PsiElement elementAt2 = viewProvider.findElementAt(textRange.getStartOffset(), JavaLanguage.INSTANCE);
            if (elementAt2 == null) {
                return;
            }
            int endOffset = textRange.getStartOffset() + newStatementText.length();
            while (elementAt2.getTextRange().getEndOffset() < endOffset || !(elementAt2 instanceof PsiStatement)) {
                if ((elementAt2 = elementAt2.getParent()) != null) continue;
                LOG.error("Cannot decode statement");
                return;
            }
            PsiStatement newStatement = (PsiStatement)elementAt2;
            javaStyleManager.shortenClassReferences(newStatement);
            TextRange newTextRange = newStatement.getTextRange();
            Language baseLanguage = viewProvider.getBaseLanguage();
            PsiFile element = viewProvider.getPsi(baseLanguage);
            if (element != null) {
                styleManager.reformatRange(element, newTextRange.getStartOffset(), newTextRange.getEndOffset());
            }
        } else {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
            PsiElementFactory factory2 = facade.getElementFactory();
            PsiStatement newStatement = factory2.createStatementFromText(newStatementText, statement2);
            newStatement = (PsiStatement)statement2.replace(newStatement);
            javaStyleManager.shortenClassReferences(newStatement);
            styleManager.reformat(newStatement);
        }
    }

    public static void replaceExpressionWithReferenceTo(@NotNull PsiExpression expression2, @NotNull PsiMember target) {
        if (expression2 == null) {
            PsiReplacementUtil.$$$reportNull$$$0(8);
        }
        if (target == null) {
            PsiReplacementUtil.$$$reportNull$$$0(9);
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory2 = psiFacade.getElementFactory();
        PsiReferenceExpression newExpression = (PsiReferenceExpression)factory2.createExpressionFromText("xxx", expression2);
        PsiReferenceExpression replacementExpression = (PsiReferenceExpression)expression2.replace(newExpression);
        PsiElement element = replacementExpression.bindToElement(target);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
        styleManager.shortenClassReferences(element);
    }

    @NotNull
    public static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(10);
        }
        StringBuilder out = new StringBuilder();
        PsiReplacementUtil.getElementText(element, elementToReplace, replacement, out);
        String string = out.toString();
        if (string == null) {
            PsiReplacementUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            PsiReplacementUtil.$$$reportNull$$$0(12);
        }
        if (out == null) {
            PsiReplacementUtil.$$$reportNull$$$0(13);
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children2) {
            PsiReplacementUtil.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public static void replaceOperatorAssignmentWithAssignmentExpression(@NotNull PsiAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiReplacementUtil.$$$reportNull$$$0(14);
        }
        PsiJavaToken sign = assignmentExpression.getOperationSign();
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        String operator = sign.getText();
        String newOperator = operator.substring(0, operator.length() - 1);
        String lhsText = lhs.getText();
        String rhsText = rhs == null ? "" : rhs.getText();
        boolean parentheses = ParenthesesUtils.areParenthesesNeeded(sign, rhs);
        String cast = PsiReplacementUtil.getCastString(lhs, rhs);
        StringBuilder newExpression = new StringBuilder(lhsText);
        newExpression.append('=').append(cast);
        if (!cast.isEmpty()) {
            newExpression.append('(');
        }
        newExpression.append(lhsText).append(newOperator);
        if (parentheses) {
            newExpression.append('(').append(rhsText).append(')');
        } else {
            newExpression.append(rhsText);
        }
        if (!cast.isEmpty()) {
            newExpression.append(')');
        }
        PsiReplacementUtil.replaceExpression(assignmentExpression, newExpression.toString());
    }

    private static String getCastString(PsiExpression lhs, PsiExpression rhs) {
        if (lhs == null || rhs == null) {
            return "";
        }
        PsiType lType = lhs.getType();
        PsiType rType = rhs.getType();
        if (TypeConversionUtil.isNumericType(rType)) {
            rType = TypeConversionUtil.binaryNumericPromotion(lType, rType);
        }
        if (lType == null || rType == null || TypeConversionUtil.isAssignable(lType, rType) || !TypeConversionUtil.areTypesConvertible(lType, rType)) {
            return "";
        }
        return '(' + lType.getCanonicalText() + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpressionText";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newStatementText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/PsiReplacementUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndShorten";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementAndShortenClassNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithReferenceTo";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
            case 11: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceOperatorAssignmentWithAssignmentExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

