/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodOnlyUsedFromInnerClassInspection
extends BaseInspection {
    public boolean ignoreMethodsAccessedFromAnonymousClass = false;
    public boolean ignoreStaticMethodsFromNonStaticInnerClass = false;
    public boolean onlyReportStaticMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.display.name", new Object[0]);
        if (string == null) {
            MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        PsiNamedElement element = (PsiNamedElement)infos2[0];
        String name = element.getName();
        if (infos2.length > 1) {
            if (Boolean.TRUE.equals(infos2[1])) {
                String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.extending", name);
                if (string == null) {
                    MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor.anonymous.implementing", name);
            if (string == null) {
                MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("method.only.used.from.inner.class.problem.descriptor", name);
        if (string == null) {
            MethodOnlyUsedFromInnerClassInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox(InspectionGadgetsBundle.message("method.only.used.from.inner.class.ignore.option", new Object[0]), "ignoreMethodsAccessedFromAnonymousClass");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.static.methods.accessed.from.a.non.static.inner.class", new Object[0]), "ignoreStaticMethodsFromNonStaticInnerClass");
        panel.addCheckbox(InspectionGadgetsBundle.message("only.report.static.methods", new Object[0]), "onlyReportStaticMethods");
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOnlyUsedFromInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodReferenceFinder
    implements Processor<PsiReference> {
        private final PsiClass methodClass;
        private final PsiMethod method;
        private boolean onlyAccessedFromInnerClass;
        private PsiClass cache;

        MethodReferenceFinder(PsiMethod method) {
            if (method == null) {
                MethodReferenceFinder.$$$reportNull$$$0(0);
            }
            this.onlyAccessedFromInnerClass = false;
            this.cache = null;
            this.method = method;
            this.methodClass = method.getContainingClass();
        }

        @Override
        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType(element, PsiMethod.class);
            if (this.method.equals(containingMethod)) {
                return true;
            }
            PsiClass containingClass = ClassUtils.getContainingClass(element);
            if (containingClass == null) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)containingClass;
                PsiExpressionList argumentList2 = anonymousClass.getArgumentList();
                if (PsiTreeUtil.isAncestor(argumentList2, element, true)) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
                if (MethodOnlyUsedFromInnerClassInspection.this.ignoreMethodsAccessedFromAnonymousClass) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
            }
            if (this.cache != null) {
                if (!this.cache.equals(containingClass)) {
                    this.onlyAccessedFromInnerClass = false;
                    return false;
                }
            } else if (!PsiTreeUtil.isAncestor(this.methodClass, containingClass, true)) {
                this.onlyAccessedFromInnerClass = false;
                return false;
            }
            this.onlyAccessedFromInnerClass = true;
            this.cache = containingClass;
            return true;
        }

        public boolean isOnlyAccessedFromInnerClass() {
            if (DeclarationSearchUtils.isTooExpensiveToSearch(this.method, true)) {
                return false;
            }
            ReferencesSearch.search(this.method).forEach(this);
            return this.onlyAccessedFromInnerClass;
        }

        public PsiClass getContainingClass() {
            return this.cache;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/abstraction/MethodOnlyUsedFromInnerClassInspection$MethodReferenceFinder", "<init>"));
        }
    }

    private class MethodOnlyUsedFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private MethodOnlyUsedFromInnerClassVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            PsiElement parent2;
            super.visitMethod(method);
            if (!method.hasModifierProperty("private") || method.isConstructor()) {
                return;
            }
            if (MethodOnlyUsedFromInnerClassInspection.this.onlyReportStaticMethods && !method.hasModifierProperty("static")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            MethodReferenceFinder processor = new MethodReferenceFinder(method);
            if (!processor.isOnlyAccessedFromInnerClass()) {
                return;
            }
            PsiClass containingClass = processor.getContainingClass();
            if (MethodOnlyUsedFromInnerClassInspection.this.ignoreStaticMethodsFromNonStaticInnerClass && method.hasModifierProperty("static") && (parent2 = containingClass.getParent()) instanceof PsiClass && !containingClass.hasModifierProperty("static")) {
                return;
            }
            if (containingClass instanceof PsiAnonymousClass) {
                PsiClass[] interfaces = containingClass.getInterfaces();
                if (interfaces.length == 1) {
                    PsiClass superClass = interfaces[0];
                    this.registerMethodError(method, superClass, false);
                } else {
                    PsiClass superClass = containingClass.getSuperClass();
                    if (superClass == null) {
                        return;
                    }
                    this.registerMethodError(method, superClass, true);
                }
            } else {
                this.registerMethodError(method, containingClass);
            }
        }
    }
}

