/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollectionQueryUpdateCalledVisitor
extends JavaRecursiveElementWalkingVisitor {
    private static final HashSet<String> COLLECTIONS_QUERIES = ContainerUtil.newHashSet("binarySearch", "disjoint", "frequency", "indexOfSubList", "lastIndexOfSubList", "max", "min", "nCopies", "unmodifiableList", "unmodifiableMap", "unmodifiableNavigableMap", "unmodifiableNavigableSet", "unmodifiableSet", "unmodifiableSortedMap", "unmodifiableSortedSet");
    private static final HashSet<String> COLLECTIONS_TRANSFORMS = ContainerUtil.newHashSet("asLifoQueue", "checkedCollection", "checkedList", "checkedMap", "checkedNavigableMap", "checkedNavigableSet", "checkedQueue", "checkedSet", "checkedSortedMap", "checkedSortedSet", "enumeration", "newSetFromMap", "synchronizedCollection", "singleton", "singletonList", "singletonMap", "singletonSpliterator", "synchronizedList", "synchronizedMap", "synchronizedNavigableMap", "synchronizedNavigableSet", "synchronizedSet", "synchronizedSortedMap", "synchronizedSortedSet", "unmodifiableCollection");
    @NonNls
    private final Set<String> myQueryUpdateNames;
    private final boolean myCheckForQuery;
    private boolean myQueriedUpdated;
    private final PsiVariable variable;

    CollectionQueryUpdateCalledVisitor(@Nullable PsiVariable variable2, Set<String> queryUpdateNames, boolean checkForQuery) {
        this.variable = variable2;
        this.myQueryUpdateNames = queryUpdateNames;
        this.myCheckForQuery = checkForQuery;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(0);
        }
        if (!this.myQueriedUpdated) {
            super.visitElement(element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiMethod method;
        super.visitReferenceExpression(expression2);
        PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
        if (!(parent2 instanceof PsiExpressionList)) {
            return;
        }
        PsiExpressionList expressionList = (PsiExpressionList)parent2;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (this.myCheckForQuery) {
            if (COLLECTIONS_QUERIES.contains(name) || COLLECTIONS_TRANSFORMS.contains(name)) {
                if (methodCallExpression.getParent() instanceof PsiExpressionStatement) {
                    return;
                }
            } else {
                if (!"addAll".equals(name) && !"copy".equals(name) && !"fill".equals(name) && !"replaceAll".equals(name)) return;
                PsiExpression[] arguments2 = expressionList.getExpressions();
                if (arguments2.length < 2 || PsiTreeUtil.isAncestor(arguments2[0], expression2, false)) {
                    return;
                }
            }
        } else if ("addAll".equals(name) || "fill".equals(name) || "copy".equals(name) || "replaceAll".equals(name)) {
            if (!PsiTreeUtil.isAncestor(expressionList.getExpressions()[0], expression2, false)) {
                return;
            }
        } else {
            if (!COLLECTIONS_TRANSFORMS.contains(name)) return;
            if (methodCallExpression.getParent() instanceof PsiExpressionStatement) {
                return;
            }
        }
        if ((method = methodCallExpression.resolveMethod()) == null) {
            return;
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return;
        }
        String qualifiedName2 = aClass2.getQualifiedName();
        if (!"java.util.Collections".equals(qualifiedName2)) {
            return;
        }
        this.checkExpression(expression2);
    }

    @Override
    public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
        if (statement2 == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(1);
        }
        super.visitForeachStatement(statement2);
        if (this.myQueriedUpdated || !this.myCheckForQuery) {
            return;
        }
        PsiExpression qualifier = statement2.getIteratedValue();
        this.checkExpression(qualifier);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        super.visitMethodReferenceExpression(expression2);
        if (this.myQueriedUpdated) {
            return;
        }
        String methodName = expression2.getReferenceName();
        if (!this.isQueryUpdateMethodName(methodName)) {
            if (this.myCheckForQuery) {
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)target;
                PsiType returnType = method.getReturnType();
                if (PsiType.VOID.equals(returnType)) {
                    return;
                }
                PsiType expectedType2 = ExpectedTypeUtils.findExpectedType(expression2, false);
                PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(expectedType2);
                if (aClass2 == null || LambdaHighlightingUtil.checkInterfaceFunctional(aClass2) != null) {
                    return;
                }
                PsiMethod functionalMethod = LambdaUtil.getFunctionalInterfaceMethod(aClass2);
                if (functionalMethod == null || PsiType.VOID.equals(functionalMethod.getReturnType())) {
                    return;
                }
            } else {
                return;
            }
        }
        this.checkExpression(expression2.getQualifierExpression());
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call2) {
        if (call2 == null) {
            CollectionQueryUpdateCalledVisitor.$$$reportNull$$$0(2);
        }
        if (this.myQueriedUpdated) {
            return;
        }
        super.visitMethodCallExpression(call2);
        PsiReferenceExpression methodExpression = call2.getMethodExpression();
        boolean isStatement = call2.getParent() instanceof PsiExpressionStatement;
        if (!(this.myCheckForQuery && !isStatement || this.isQueryUpdateMethodName(methodExpression.getReferenceName()))) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        this.checkExpression(qualifier);
    }

    private boolean isQueryUpdateMethodName(String methodName) {
        if (methodName == null) {
            return false;
        }
        if (this.myQueryUpdateNames.contains(methodName)) {
            return true;
        }
        for (String updateName : this.myQueryUpdateNames) {
            if (!methodName.startsWith(updateName)) continue;
            return true;
        }
        return false;
    }

    private void checkExpression(PsiExpression expression2) {
        if (this.myQueriedUpdated) {
            return;
        }
        if (this.variable != null && expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.myQueriedUpdated = true;
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            this.checkExpression(parenthesizedExpression.getExpression());
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            this.checkExpression(thenExpression);
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            this.checkExpression(elseExpression);
        } else if (this.variable == null && (expression2 == null || expression2 instanceof PsiThisExpression || expression2 instanceof PsiSuperExpression)) {
            this.myQueriedUpdated = true;
        }
    }

    boolean isQueriedUpdated() {
        return this.myQueriedUpdated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/bugs/CollectionQueryUpdateCalledVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

