/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspectionBase
extends BaseInspection {
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();

    public MalformedFormatStringInspectionBase() {
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            MalformedFormatStringInspectionBase.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            MalformedFormatStringInspectionBase.$$$reportNull$$$0(1);
        }
        this.additionalClasses = MalformedFormatStringInspectionBase.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspectionBase.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
        if (string == null) {
            MalformedFormatStringInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Object value = infos2[0];
        if (value instanceof Exception) {
            Exception exception = (Exception)value;
            String message = exception.getMessage();
            if (message != null) {
                String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.illegal", message);
                if (string == null) {
                    MalformedFormatStringInspectionBase.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
            if (string == null) {
                MalformedFormatStringInspectionBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        FormatDecode.Validator[] validators = (FormatDecode.Validator[])value;
        int argumentCount = (Integer)infos2[1];
        if (validators.length < argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", argumentCount, validators.length);
            if (string == null) {
                MalformedFormatStringInspectionBase.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (validators.length > argumentCount) {
            String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", argumentCount, validators.length);
            if (string == null) {
                MalformedFormatStringInspectionBase.$$$reportNull$$$0(6);
            }
            return string;
        }
        PsiType argumentType = (PsiType)infos2[2];
        FormatDecode.Validator validator = (FormatDecode.Validator)infos2[3];
        String string = InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", argumentType.getPresentableText(), validator.getSpecifier());
        if (string == null) {
            MalformedFormatStringInspectionBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        private int findFirstStringArgumentIndex(PsiExpression[] expressions) {
            int length = expressions.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression expression2 = expressions[i2];
                if (!ExpressionUtils.hasStringType(expression2)) continue;
                return i2;
            }
            return -1;
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression argument;
            PsiType argumentType;
            FormatDecode.Validator[] validators;
            if (expression2 == null) {
                MalformedFormatStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!FormatUtils.isFormatCall(expression2, MalformedFormatStringInspectionBase.this.methodNames, MalformedFormatStringInspectionBase.this.classNames)) {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            int formatArgumentIndex = this.findFirstStringArgumentIndex(arguments2);
            if (formatArgumentIndex < 0) {
                return;
            }
            PsiExpression formatArgument = arguments2[formatArgumentIndex];
            ++formatArgumentIndex;
            if (!ExpressionUtils.hasStringType(formatArgument) || !PsiUtil.isConstantExpression(formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value = (String)ConstantExpressionUtil.computeCastTo(formatArgument, formatType);
            if (value == null) {
                return;
            }
            int argumentCount = arguments2.length - formatArgumentIndex;
            try {
                validators = FormatDecode.decode(value, argumentCount);
            }
            catch (FormatDecode.IllegalFormatException e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (argumentCount == 1 && (argumentType = (argument = this.resolveIfPossible(arguments2[formatArgumentIndex])).getType()) instanceof PsiArrayType) {
                PsiArrayInitializerExpression arrayInitializer;
                if (argument instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)argument;
                    arrayInitializer = newExpression.getArrayInitializer();
                } else if (argument instanceof PsiArrayInitializerExpression) {
                    arrayInitializer = (PsiArrayInitializerExpression)argument;
                } else {
                    return;
                }
                if (arrayInitializer == null) {
                    return;
                }
                arguments2 = arrayInitializer.getInitializers();
                argumentCount = arguments2.length;
                formatArgumentIndex = 0;
            }
            if (validators.length != argumentCount) {
                this.registerMethodCallError(expression2, validators, argumentCount);
                return;
            }
            for (int i2 = 0; i2 < validators.length; ++i2) {
                FormatDecode.Validator validator = validators[i2];
                PsiExpression argument2 = arguments2[i2 + formatArgumentIndex];
                PsiType argumentType2 = argument2.getType();
                if (argumentType2 == null || validator == null || validator.valid(argumentType2)) continue;
                this.registerError((PsiElement)argument2, validators, argumentCount, argumentType2, validator);
            }
        }

        private PsiExpression resolveIfPossible(PsiExpression expression2) {
            PsiVariable variable2;
            PsiExpression initializer2;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && target.getContainingFile() == expression2.getContainingFile() && (initializer2 = (variable2 = (PsiVariable)target).getInitializer()) != null) {
                return initializer2;
            }
            return expression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/MalformedFormatStringInspectionBase$MalformedFormatStringVisitor", "visitMethodCallExpression"));
        }
    }
}

