/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MismatchedStringBuilderQueryUpdateInspection
extends BaseInspection {
    @NonNls
    static final Set<String> returnSelfNames = ContainerUtil.set("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse");

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfStringBuilder" == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(0);
        }
        return "MismatchedQueryAndUpdateOfStringBuilder";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.query.update.display.name", new Object[0]);
        if (string == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        boolean updated = (Boolean)infos2[0];
        PsiType type2 = (PsiType)infos2[1];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.string.builder.updated.problem.descriptor", type2.getPresentableText());
            if (string == null) {
                MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.queried.problem.descriptor", type2.getPresentableText());
        if (string == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedQueryAndUpdateOfStringBuilderVisitor();
    }

    static boolean hasReferenceToVariable(PsiVariable variable2, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            return referenceExpression.isReferenceTo(variable2);
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            PsiExpression expression2 = parenthesizedExpression.getExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable2, expression2);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (returnSelfNames.contains(name)) {
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable2, methodExpression.getQualifierExpression());
            }
        } else if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable2, thenExpression)) {
                return true;
            }
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable2, elseExpression);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringBuilderQueryCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> queryNames = ContainerUtil.set("toString", "indexOf", "lastIndexOf", "capacity", "charAt", "codePointAt", "codePointBefore", "codePointCount", "equals", "getChars", "hashCode", "length", "offsetByCodePoints", "subSequence", "substring");
        private final PsiVariable variable;
        private boolean queried;

        StringBuilderQueryCalledVisitor(PsiVariable variable2) {
            this.variable = variable2;
        }

        public boolean isQueried() {
            return this.queried;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(0);
            }
            if (this.queried) {
                return;
            }
            super.visitElement(element);
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.queried) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement parent2 = ParenthesesUtils.getParentSkipParentheses(expression2);
            if (!(parent2 instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent2;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiElement target = expression2.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type2 = polyadicExpression.getType();
            if (type2 == null || !type2.equalsToText("java.lang.String")) {
                return;
            }
            this.queried = true;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.queried) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!queryNames.contains(name)) {
                if (returnSelfNames.contains(name) && MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression) && StringBuilderQueryCalledVisitor.isVariableValueUsed(expression2)) {
                    this.queried = true;
                }
                return;
            }
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression)) {
                Object parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class, PsiLambdaExpression.class);
                if (parent2 instanceof PsiStatement && !SideEffectChecker.mayHaveSideEffects(parent2, this::isSideEffectFreeBuilderMethodCall)) {
                    return;
                }
                this.queried = true;
            }
        }

        private boolean isSideEffectFreeBuilderMethodCall(PsiMethodCallExpression call2) {
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            return !"getChars".equals(methodExpression.getReferenceName()) && ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), this.variable);
        }

        private static boolean isVariableValueUsed(PsiExpression expression2) {
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)parent2;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed(parenthesizedExpression);
            }
            if (parent2 instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent2;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed(typeCastExpression);
            }
            if (parent2 instanceof PsiReturnStatement) {
                return true;
            }
            if (parent2 instanceof PsiExpressionList) {
                PsiElement grandParent = parent2.getParent();
                if (grandParent instanceof PsiMethodCallExpression) {
                    return true;
                }
            } else {
                if (parent2 instanceof PsiArrayInitializerExpression) {
                    return true;
                }
                if (parent2 instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    return expression2.equals(rhs);
                }
                if (parent2 instanceof PsiVariable) {
                    PsiVariable variable2 = (PsiVariable)parent2;
                    PsiExpression initializer2 = variable2.getInitializer();
                    return expression2.equals(initializer2);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderQueryCalledVisitor", "visitElement"));
        }
    }

    private static class StringBuilderUpdateCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Set<String> updateNames = ContainerUtil.set("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse", "setCharAt", "setLength");
        private final PsiVariable variable;
        private boolean updated;

        public StringBuilderUpdateCalledVisitor(PsiVariable variable2) {
            this.variable = variable2;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            if (this.updated) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            this.checkReferenceExpression(expression2.getMethodExpression());
        }

        @Override
        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (this.updated) {
                return;
            }
            super.visitMethodReferenceExpression(expression2);
            this.checkReferenceExpression(expression2);
        }

        private void checkReferenceExpression(PsiReferenceExpression methodExpression) {
            String name = methodExpression.getReferenceName();
            if (!updateNames.contains(name)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, qualifierExpression)) {
                this.updated = true;
            }
        }
    }

    private static class MismatchedQueryAndUpdateOfStringBuilderVisitor
    extends BaseInspectionVisitor {
        private MismatchedQueryAndUpdateOfStringBuilderVisitor() {
        }

        @Override
        public void visitField(PsiField field) {
            boolean updated;
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass(field);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable(field, containingClass)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried(field, containingClass);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated(field, containingClass)) || UnusedSymbolUtil.isImplicitWrite(field)) {
                return;
            }
            this.registerFieldError(field, updated, field.getType());
        }

        @Override
        public void visitLocalVariable(PsiLocalVariable variable2) {
            boolean updated;
            super.visitLocalVariable(variable2);
            PsiCodeBlock codeBlock = PsiTreeUtil.getParentOfType((PsiElement)variable2, PsiCodeBlock.class);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable(variable2, codeBlock)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried(variable2, codeBlock);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated(variable2, codeBlock))) {
                return;
            }
            this.registerVariableError(variable2, updated, variable2.getType());
        }

        private static boolean checkVariable(PsiVariable variable2, PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!TypeUtils.variableHasTypeOrSubtype(variable2, "java.lang.AbstractStringBuilder")) {
                return false;
            }
            if (!(PsiUtil.skipParenthesizedExprDown(variable2.getInitializer()) instanceof PsiNewExpression)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable2, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable2, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable2, context);
        }

        private static boolean isStringBuilderUpdated(PsiVariable variable2, PsiElement context) {
            PsiExpression initializer2 = variable2.getInitializer();
            if (initializer2 != null && !ConstructionUtils.isEmptyStringBuilderInitializer(initializer2)) {
                return true;
            }
            StringBuilderUpdateCalledVisitor visitor2 = new StringBuilderUpdateCalledVisitor(variable2);
            context.accept(visitor2);
            return visitor2.isUpdated();
        }

        private static boolean isStringBuilderQueried(PsiVariable variable2, PsiElement context) {
            StringBuilderQueryCalledVisitor visitor2 = new StringBuilderQueryCalledVisitor(variable2);
            context.accept(visitor2);
            return visitor2.isQueried();
        }
    }
}

