/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEqualityInspection
extends BaseInspection {
    public boolean m_ignoreEnums = true;
    public boolean m_ignoreClassObjects = true;
    public boolean m_ignorePrivateConstructors = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("object.comparison.display.name", new Object[0]);
        if (string == null) {
            ObjectEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("object.comparison.problem.description", new Object[0]);
        if (string == null) {
            ObjectEqualityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.enumerated.ignore.option", new Object[0]), "m_ignoreEnums");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.comparison.klass.ignore.option", new Object[0]), "m_ignoreClassObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("object.equality.ignore.between.objects.of.a.type.with.only.private.constructors.option", new Object[0]), "m_ignorePrivateConstructors");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectEqualityVisitor();
    }

    @Override
    @NotNull
    public InspectionGadgetsFix[] buildFixes(Object ... infos2) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos2[0]);
        if (inspectionGadgetsFixArray == null) {
            ObjectEqualityInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ObjectEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ObjectEqualityVisitor
    extends BaseInspectionVisitor {
        private ObjectEqualityVisitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            if (expression2 == null) {
                ObjectEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isEqualityComparison(expression2)) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (!this.isObjectType(rhs)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!this.isObjectType(lhs)) {
                return;
            }
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (MethodUtils.isEquals(method) && (this.isThisReference(lhs, method.getContainingClass()) || this.isThisReference(rhs, method.getContainingClass()))) {
                return;
            }
            if (ObjectEqualityInspection.this.m_ignoreEnums && TypeConversionUtil.isEnumType(lhs.getType())) {
                return;
            }
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (!TypeConversionUtil.isBinaryOperatorApplicable(expression2.getOperationTokenType(), lhs, rhs, false)) {
                highlightType = ProblemHighlightType.INFORMATION;
            }
            if (ObjectEqualityInspection.this.m_ignoreClassObjects && ClassUtils.isFinalClassWithDefaultEquals(PsiUtil.resolveClassInClassTypeOnly(lhs.getType()))) {
                highlightType = ProblemHighlightType.INFORMATION;
            }
            if (ObjectEqualityInspection.this.m_ignorePrivateConstructors && this.typeHasPrivateConstructor(lhs)) {
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), highlightType, expression2);
        }

        private boolean typeHasPrivateConstructor(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(expression2.getType());
            return aClass2 != null && aClass2.isInterface() ? this.implementersHaveOnlyPrivateConstructors(aClass2) : ClassUtils.hasOnlyPrivateConstructors(aClass2);
        }

        private boolean implementersHaveOnlyPrivateConstructors(PsiClass aClass2) {
            GlobalSearchScope scope = GlobalSearchScope.allScope(aClass2.getProject());
            PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(6);
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess(() -> ClassInheritorsSearch.search(aClass2, scope, true).forEach(new PsiElementProcessorAdapter(processor)), null);
            if (processor.isOverflow()) {
                return false;
            }
            Collection implementers = processor.getCollection();
            for (PsiClass implementer : implementers) {
                if (implementer.isInterface() || implementer.hasModifierProperty("abstract") || ClassUtils.hasOnlyPrivateConstructors(implementer)) continue;
                return false;
            }
            return true;
        }

        private boolean isObjectType(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            return type2 != null && !(type2 instanceof PsiArrayType) && !(type2 instanceof PsiPrimitiveType) && !TypeUtils.isJavaLangString(type2) && !TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.Number");
        }

        private boolean isThisReference(@Nullable PsiExpression expression2, @Nullable PsiClass psiClass) {
            if (!(expression2 instanceof PsiThisExpression)) {
                return false;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)expression2;
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            return qualifier == null || psiClass != null && qualifier.isReferenceTo(psiClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ObjectEqualityInspection$ObjectEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

