/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ResultSetIndexZeroInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("UseOfIndexZeroInJDBCResultSet" == null) {
            ResultSetIndexZeroInspection.$$$reportNull$$$0(0);
        }
        return "UseOfIndexZeroInJDBCResultSet";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.resultset.display.name", new Object[0]);
        if (string == null) {
            ResultSetIndexZeroInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        if (((Boolean)infos2[0]).booleanValue()) {
            String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.resultset.problem.descriptor", new Object[0]);
            if (string == null) {
                ResultSetIndexZeroInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("use.0index.in.jdbc.prepared.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            ResultSetIndexZeroInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ResultSetIndexZeroVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ResultSetIndexZeroInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ResultSetIndexZeroVisitor
    extends BaseInspectionVisitor {
        private ResultSetIndexZeroVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            boolean resultSet;
            if (expression2 == null) {
                ResultSetIndexZeroVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            if (methodName.startsWith("get") || methodName.startsWith("update")) {
                resultSet = true;
            } else if (methodName.startsWith("set")) {
                resultSet = false;
            } else {
                return;
            }
            PsiExpressionList argumentList2 = expression2.getArgumentList();
            PsiExpression[] arguments2 = argumentList2.getExpressions();
            if (arguments2.length == 0) {
                return;
            }
            PsiExpression argument = arguments2[0];
            Object val = ExpressionUtils.computeConstantExpression(argument);
            if (!(val instanceof Integer) || (Integer)val != 0) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (resultSet) {
                if (TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.sql.ResultSet")) {
                    this.registerError((PsiElement)argument, Boolean.TRUE);
                }
            } else if (arguments2.length > 1 && TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.sql.PreparedStatement")) {
                this.registerError((PsiElement)argument, Boolean.FALSE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ResultSetIndexZeroInspection$ResultSetIndexZeroVisitor", "visitMethodCallExpression"));
        }
    }
}

