/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnNullInspectionBase
extends BaseInspection {
    public boolean m_reportObjectMethods = true;
    public boolean m_reportArrayMethods = true;
    public boolean m_reportCollectionMethods = true;
    public boolean m_ignorePrivateMethods = false;

    @Override
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("ReturnOfNull" == null) {
            ReturnNullInspectionBase.$$$reportNull$$$0(0);
        }
        return "ReturnOfNull";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("return.of.null.display.name", new Object[0]);
        if (string == null) {
            ReturnNullInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("return.of.null.problem.descriptor", new Object[0]);
        if (string == null) {
            ReturnNullInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        PsiMethod method;
        PsiType type2;
        PsiElement elt = (PsiElement)infos2[0];
        if (!AnnotationUtil.isAnnotatingApplicable(elt)) {
            return null;
        }
        Object element = PsiTreeUtil.getParentOfType(elt, PsiMethod.class, PsiLambdaExpression.class);
        if (element instanceof PsiLambdaExpression) {
            return null;
        }
        if (element instanceof PsiMethod && TypeUtils.isOptional(type2 = (method = (PsiMethod)element).getReturnType())) {
            return new ReplaceWithEmptyOptionalFix(((PsiClassType)type2).rawType().getCanonicalText());
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(elt.getProject());
        return new DelegatingFix(new AnnotateMethodFix(manager.getDefaultNullable(), ArrayUtil.toStringArray(manager.getNotNulls())));
    }

    protected int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod) {
        return 1;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnNullVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ReturnNullInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ReturnNullVisitor
    extends BaseInspectionVisitor {
        private ReturnNullVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression value) {
            PsiType returnType;
            PsiMethod method;
            if (value == null) {
                ReturnNullVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(value);
            String text2 = value.getText();
            if (!"null".equals(text2)) {
                return;
            }
            PsiElement parent2 = value.getParent();
            while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiTypeCastExpression) {
                parent2 = parent2.getParent();
            }
            if (!(parent2 instanceof PsiReturnStatement)) {
                return;
            }
            Object element = PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class, PsiLambdaExpression.class);
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
                returnType = method.getReturnType();
            } else if (element instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)element).getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
                returnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            } else {
                return;
            }
            if (method == null || returnType == null) {
                return;
            }
            if (TypeUtils.isOptional(returnType)) {
                this.registerError((PsiElement)value, value);
                return;
            }
            if (ReturnNullInspectionBase.this.m_ignorePrivateMethods && method.hasModifierProperty("private")) {
                return;
            }
            NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance(method.getProject());
            if (nullableNotNullManager.isNullable(method, false)) {
                return;
            }
            if (CollectionUtils.isCollectionClassOrInterface(returnType)) {
                if (ReturnNullInspectionBase.this.m_reportCollectionMethods) {
                    this.registerError((PsiElement)value, value);
                }
            } else if (returnType.getArrayDimensions() > 0) {
                if (ReturnNullInspectionBase.this.m_reportArrayMethods) {
                    this.registerError((PsiElement)value, value);
                }
            } else if (!returnType.equalsToText("java.lang.Void") && ReturnNullInspectionBase.this.m_reportObjectMethods) {
                this.registerError((PsiElement)value, value);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/siyeh/ig/bugs/ReturnNullInspectionBase$ReturnNullVisitor", "visitLiteralExpression"));
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    extends InspectionGadgetsFix {
        private final String myTypeText;

        public ReplaceWithEmptyOptionalFix(String typeText) {
            this.myTypeText = typeText;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("return.of.null.optional.quickfix", this.myTypeText, "com.google.common.base.Optional".equals(this.myTypeText) ? "absent" : "empty");
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("return.of.null.optional.quickfix.family", new Object[0]);
            if (string == null) {
                ReplaceWithEmptyOptionalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            if ("com.google.common.base.Optional".equals(this.myTypeText)) {
                PsiReplacementUtil.replaceExpression(literalExpression, this.myTypeText + ".absent()");
            } else {
                PsiReplacementUtil.replaceExpression(literalExpression, this.myTypeText + ".empty()");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/ReturnNullInspectionBase$ReplaceWithEmptyOptionalFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

