/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class StaticFieldReferenceOnSubclassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("StaticFieldReferencedViaSubclass" == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(0);
        }
        return "StaticFieldReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.field.via.subclass.display.name", new Object[0]);
        if (string == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        PsiClass declaringClass = (PsiClass)infos2[0];
        PsiClass referencedClass = (PsiClass)infos2[1];
        String string = InspectionGadgetsBundle.message("static.field.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            StaticFieldReferenceOnSubclassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new StaticFieldOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticFieldOnSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticFieldOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticFieldOnSubclassVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement qualifier = expression2.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = expression2.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiElement qualifierReferent = ((PsiReference)((Object)qualifier)).resolve();
            if (!(qualifierReferent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)qualifierReferent;
            PsiClass declaringClass = field.getContainingClass();
            if (declaringClass == null) {
                return;
            }
            if (declaringClass.equals(referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(expression2.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible(declaringClass, expression2, null)) {
                return;
            }
            PsiElement identifier = expression2.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, declaringClass, referencedClass);
        }
    }

    private static class StaticFieldOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticFieldOnSubclassFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.field.via.subclass.rationalize.quickfix", new Object[0]);
            if (string == null) {
                StaticFieldOnSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor2.getPsiElement();
            PsiReferenceExpression expression2 = (PsiReferenceExpression)name.getParent();
            assert (expression2 != null);
            PsiField field = (PsiField)expression2.resolve();
            assert (field != null);
            PsiReplacementUtil.replaceExpressionWithReferenceTo(expression2, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StaticFieldReferenceOnSubclassInspection$StaticFieldOnSubclassFix", "getFamilyName"));
        }
    }
}

