/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SuspiciousComparatorCompareInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("suspicious.comparator.compare.display.name", new Object[0]);
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("ComparatorMethodParameterNotUsed" == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(1);
        }
        return "ComparatorMethodParameterNotUsed";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = (String)infos2[0];
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousComparatorCompareVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SuspiciousComparatorCompareVisitor
    extends BaseInspectionVisitor {
        private SuspiciousComparatorCompareVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.isComparatorCompare(method) || ControlFlowUtils.methodAlwaysThrowsException(method)) {
                return;
            }
            this.check(method.getParameterList(), method.getBody());
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            PsiClass functionalInterface = PsiUtil.resolveClassInType(lambda2.getFunctionalInterfaceType());
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(lambda2)) {
                return;
            }
            this.check(lambda2.getParameterList(), lambda2.getBody());
        }

        private void check(PsiParameterList parameterList, PsiElement body2) {
            PsiStatement statement2;
            if (body2 == null || parameterList.getParametersCount() != 2) {
                return;
            }
            if (body2 instanceof PsiExpression && ExpressionUtils.isZero((PsiExpression)body2)) {
                return;
            }
            if (body2 instanceof PsiCodeBlock && (statement2 = ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)body2)) instanceof PsiReturnStatement && ExpressionUtils.isZero(((PsiReturnStatement)statement2).getReturnValue())) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameterList(parameters2, body2);
            this.checkReflexivity(parameters2, body2);
        }

        private void checkParameterList(PsiParameter[] parameters2, PsiElement context) {
            ParameterAccessVisitor visitor2 = new ParameterAccessVisitor(parameters2);
            context.accept(visitor2);
            for (PsiParameter unusedParameter : visitor2.getUnusedParameters()) {
                this.registerVariableError(unusedParameter, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.parameter.not.used", new Object[0]));
            }
        }

        private void checkReflexivity(final PsiParameter[] parameters2, PsiElement body2) {
            StandardDataFlowRunner runner = new StandardDataFlowRunner(false, true){

                @Override
                @NotNull
                protected DfaMemoryState createMemoryState() {
                    DfaMemoryState state2 = super.createMemoryState();
                    DfaVariableValue var1 = this.getFactory().getVarFactory().createVariableValue(parameters2[0], false);
                    DfaVariableValue var2 = this.getFactory().getVarFactory().createVariableValue(parameters2[1], false);
                    DfaValue condition = this.getFactory().createCondition(var1, DfaRelationValue.RelationType.EQ, var2);
                    state2.applyCondition(condition);
                    DfaMemoryState dfaMemoryState = state2;
                    if (dfaMemoryState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return dfaMemoryState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$1", "createMemoryState"));
                }
            };
            ComparatorVisitor visitor2 = new ComparatorVisitor();
            if (runner.analyzeMethod(body2, visitor2) != RunnerResult.OK) {
                return;
            }
            if (visitor2.myRange.contains(0L)) {
                return;
            }
            PsiElement context = null;
            if (visitor2.myContexts.size() == 1) {
                context = visitor2.myContexts.iterator().next();
            } else {
                Object parent2 = PsiTreeUtil.getParentOfType(body2, PsiMethod.class, PsiLambdaExpression.class);
                if (parent2 instanceof PsiMethod) {
                    context = ((PsiMethod)parent2).getNameIdentifier();
                } else if (parent2 instanceof PsiLambdaExpression) {
                    context = ((PsiLambdaExpression)parent2).getParameterList();
                }
            }
            this.registerError(context != null ? context : body2, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.reflexive", new Object[0]));
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(@NotNull PsiParameter[] parameters2) {
                if (parameters2 == null) {
                    ParameterAccessVisitor.$$$reportNull$$$0(0);
                }
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters2));
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
                if (this.parameters.isEmpty()) {
                    this.stopWalking();
                }
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ParameterAccessVisitor", "<init>"));
            }
        }

        private static class ComparatorVisitor
        extends StandardInstructionVisitor {
            LongRangeSet myRange = LongRangeSet.empty();
            Set<PsiElement> myContexts = new HashSet<PsiElement>();

            private ComparatorVisitor() {
            }

            @Override
            public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                this.myContexts.add(instruction.getReturn());
                DfaValue value = memState.peek();
                LongRangeSet range = memState.getValueFact(DfaFactType.RANGE, value);
                this.myRange = range == null ? LongRangeSet.all() : this.myRange.union(range);
                return super.visitCheckReturnValue(instruction, runner, memState);
            }
        }
    }
}

