/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.memory.InnerClassReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMayBeInterfaceInspection
extends BaseInspection {
    public boolean reportClassesWithNonAbstractMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.display.name", new Object[0]);
        if (string == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.may.be.interface.java8.option", new Object[0]), this, "reportClassesWithNonAbstractMethods");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(2);
        }
        if (this.reportClassesWithNonAbstractMethods) {
            node.addContent(new Element("option").setAttribute("name", "reportClassesWithNonAbstractMethods").setAttribute("value", "true"));
        }
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new ClassMayBeInterfaceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassMayBeInterfaceVisitor();
    }

    private static boolean isEmptyConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            ClassMayBeInterfaceInspection.$$$reportNull$$$0(3);
        }
        return method.isConstructor() && MethodUtils.isTrivial(method, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ClassMayBeInterfaceVisitor
    extends BaseInspectionVisitor {
        private ClassMayBeInterfaceVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            if (aClass2 == null) {
                ClassMayBeInterfaceVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType() || aClass2.isEnum()) {
                return;
            }
            if (aClass2 instanceof PsiTypeParameter || aClass2 instanceof PsiAnonymousClass) {
                return;
            }
            if (!aClass2.hasModifierProperty("abstract")) {
                return;
            }
            if (!this.mayBeInterface(aClass2)) {
                return;
            }
            if (ClassUtils.isInnerClass(aClass2)) {
                InnerClassReferenceVisitor visitor2 = new InnerClassReferenceVisitor(aClass2);
                aClass2.accept(visitor2);
                if (!visitor2.canInnerClassBeStatic()) {
                    return;
                }
            }
            this.registerClassError(aClass2, new Object[0]);
        }

        public boolean mayBeInterface(PsiClass aClass2) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass2.getExtendsList();
            if (extendsList != null && (extendsElements = extendsList.getReferenceElements()).length > 0) {
                return false;
            }
            PsiClassInitializer[] initializers = aClass2.getInitializers();
            if (initializers.length > 0) {
                return false;
            }
            return this.allMethodsPublicAbstract(aClass2) && this.allFieldsPublicStaticFinal(aClass2) && this.allInnerClassesPublic(aClass2);
        }

        private boolean allFieldsPublicStaticFinal(PsiClass aClass2) {
            PsiField[] fields2;
            boolean allFieldsStaticFinal = true;
            for (PsiField field : fields2 = aClass2.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public")) continue;
                allFieldsStaticFinal = false;
            }
            return allFieldsStaticFinal;
        }

        private boolean allMethodsPublicAbstract(PsiClass aClass2) {
            PsiMethod[] methods2;
            for (PsiMethod method : methods2 = aClass2.getMethods()) {
                if (ClassMayBeInterfaceInspection.isEmptyConstructor(method)) continue;
                if (!(method.hasModifierProperty("abstract") || ClassMayBeInterfaceInspection.this.reportClassesWithNonAbstractMethods && PsiUtil.isLanguageLevel8OrHigher(aClass2))) {
                    return false;
                }
                if (method.hasModifierProperty("public") && !method.hasModifierProperty("final")) continue;
                return false;
            }
            return true;
        }

        private boolean allInnerClassesPublic(PsiClass aClass2) {
            PsiClass[] innerClasses2;
            for (PsiClass innerClass : innerClasses2 = aClass2.getInnerClasses()) {
                if (innerClass.hasModifierProperty("public")) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceVisitor", "visitClass"));
        }
    }

    private static class ClassMayBeInterfaceFix
    extends InspectionGadgetsFix {
        private ClassMayBeInterfaceFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("class.may.be.interface.convert.quickfix", new Object[0]);
            if (string == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiIdentifier classNameIdentifier = (PsiIdentifier)descriptor2.getPsiElement();
            PsiClass interfaceClass = (PsiClass)classNameIdentifier.getParent();
            SearchScope searchScope = interfaceClass.getUseScope();
            ArrayList<PsiClass> elements = new ArrayList<PsiClass>();
            elements.add(interfaceClass);
            for (PsiClass inheritor : ClassInheritorsSearch.search(interfaceClass, searchScope, false)) {
                elements.add(inheritor);
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                return;
            }
            WriteAction.run(() -> {
                ClassMayBeInterfaceFix.moveSubClassExtendsToImplements(elements);
                ClassMayBeInterfaceFix.changeClassToInterface(interfaceClass);
                ClassMayBeInterfaceFix.moveImplementsToExtends(interfaceClass);
            });
        }

        private static void changeClassToInterface(PsiClass aClass2) {
            for (PsiMethod psiMethod : aClass2.getMethods()) {
                if (ClassMayBeInterfaceInspection.isEmptyConstructor(psiMethod)) {
                    psiMethod.delete();
                    continue;
                }
                PsiUtil.setModifierProperty(psiMethod, "public", false);
                if (psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract")) continue;
                PsiUtil.setModifierProperty(psiMethod, "default", true);
            }
            for (PomRenameableTarget<PsiElement> pomRenameableTarget : aClass2.getFields()) {
                PsiUtil.setModifierProperty(pomRenameableTarget, "public", false);
                PsiUtil.setModifierProperty(pomRenameableTarget, "static", false);
                PsiUtil.setModifierProperty(pomRenameableTarget, "final", false);
            }
            for (PomRenameableTarget<PsiElement> pomRenameableTarget : aClass2.getInnerClasses()) {
                PsiUtil.setModifierProperty(pomRenameableTarget, "public", false);
            }
            PsiIdentifier nameIdentifier = aClass2.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiKeyword classKeyword = PsiTreeUtil.getPrevSiblingOfType(nameIdentifier, PsiKeyword.class);
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(aClass2.getProject());
            PsiKeyword psiKeyword = factory2.createKeyword("interface");
            if (classKeyword == null) {
                return;
            }
            PsiUtil.setModifierProperty(aClass2, "abstract", false);
            PsiUtil.setModifierProperty(aClass2, "final", false);
            classKeyword.replace(psiKeyword);
        }

        private static void moveImplementsToExtends(PsiClass anInterface) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiReferenceList extendsList = anInterface.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiReferenceList implementsList = anInterface.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                extendsList.add(referenceElement);
                referenceElement.delete();
            }
        }

        private static void moveSubClassExtendsToImplements(List<PsiClass> inheritors) {
            PsiClass oldClass = inheritors.get(0);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(oldClass.getProject());
            PsiJavaCodeReferenceElement classReference = elementFactory.createClassReferenceElement(oldClass);
            for (int i2 = 1; i2 < inheritors.size(); ++i2) {
                PsiClass inheritor = inheritors.get(i2);
                PsiReferenceList extendsList = inheritor.getExtendsList();
                if (extendsList == null) continue;
                PsiReferenceList implementsList = inheritor.getImplementsList();
                ClassMayBeInterfaceFix.moveReference(extendsList, implementsList, classReference);
            }
        }

        private static void moveReference(@NotNull PsiReferenceList source2, @Nullable PsiReferenceList target, @NotNull PsiJavaCodeReferenceElement reference) {
            if (source2 == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(1);
            }
            if (reference == null) {
                ClassMayBeInterfaceFix.$$$reportNull$$$0(2);
            }
            PsiJavaCodeReferenceElement[] sourceReferences = source2.getReferenceElements();
            String fqName2 = reference.getQualifiedName();
            for (PsiJavaCodeReferenceElement sourceReference : sourceReferences) {
                String implementsReferenceFqName = sourceReference.getQualifiedName();
                if (!fqName2.equals(implementsReferenceFqName)) continue;
                if (target != null) {
                    target.add(sourceReference);
                }
                sourceReference.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "moveReference";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

