/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import com.siyeh.ig.classmetrics.CyclomaticComplexityVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassComplexityInspection
extends ClassMetricInspection {
    private static final int DEFAULT_COMPLEXITY_LIMIT = 80;

    @Override
    @NotNull
    public String getID() {
        if ("OverlyComplexClass" == null) {
            ClassComplexityInspection.$$$reportNull$$$0(0);
        }
        return "OverlyComplexClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("overly.complex.class.display.name", new Object[0]);
        if (string == null) {
            ClassComplexityInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 80;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("cyclomatic.complexity.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        Integer totalComplexity = (Integer)infos2[0];
        String string = InspectionGadgetsBundle.message("overly.complex.class.problem.descriptor", totalComplexity);
        if (string == null) {
            ClassComplexityInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassComplexityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ClassComplexityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ClassComplexityVisitor
    extends BaseInspectionVisitor {
        private ClassComplexityVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            int totalComplexity;
            if (aClass2 == null) {
                ClassComplexityVisitor.$$$reportNull$$$0(0);
            }
            if ((totalComplexity = this.calculateTotalComplexity(aClass2)) <= ClassComplexityInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass2, totalComplexity);
        }

        private int calculateTotalComplexity(PsiClass aClass2) {
            PsiMethod[] methods2 = aClass2.getMethods();
            int totalComplexity = this.calculateComplexityForMethods(methods2);
            return totalComplexity += this.calculateInitializerComplexity(aClass2);
        }

        private int calculateInitializerComplexity(PsiClass aClass2) {
            PsiClassInitializer[] initializers;
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiClassInitializer initializer2 : initializers = aClass2.getInitializers()) {
                visitor2.reset();
                initializer2.accept(visitor2);
                complexity += visitor2.getComplexity();
            }
            return complexity;
        }

        private int calculateComplexityForMethods(PsiMethod[] methods2) {
            CyclomaticComplexityVisitor visitor2 = new CyclomaticComplexityVisitor();
            int complexity = 0;
            for (PsiMethod method : methods2) {
                visitor2.reset();
                method.accept(visitor2);
                complexity += visitor2.getComplexity();
            }
            return complexity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ClassComplexityInspection$ClassComplexityVisitor", "visitClass"));
        }
    }
}

