/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CloneableImplementsCloneInspection
extends BaseInspection {
    public boolean m_ignoreCloneableDueToInheritance = false;

    @Override
    @NotNull
    public String getID() {
        if ("CloneableClassWithoutClone" == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(0);
        }
        return "CloneableClassWithoutClone";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.display.name", new Object[0]);
        if (string == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.problem.descriptor", new Object[0]);
        if (string == null) {
            CloneableImplementsCloneInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cloneable.class.without.clone.ignore.option", new Object[0]), this, "m_ignoreCloneableDueToInheritance");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new CreateCloneMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableImplementsCloneVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CloneableImplementsCloneVisitor
    extends BaseInspectionVisitor {
        private CloneableImplementsCloneVisitor() {
        }

        @Override
        public void visitClass(@NotNull PsiClass aClass2) {
            PsiMethod[] methods2;
            if (aClass2 == null) {
                CloneableImplementsCloneVisitor.$$$reportNull$$$0(0);
            }
            if (aClass2.isInterface() || aClass2.isAnnotationType() || aClass2.isEnum()) {
                return;
            }
            if (aClass2 instanceof PsiTypeParameter) {
                return;
            }
            if (CloneableImplementsCloneInspection.this.m_ignoreCloneableDueToInheritance ? !CloneUtils.isDirectlyCloneable(aClass2) : !CloneUtils.isCloneable(aClass2)) {
                return;
            }
            for (PsiMethod method : methods2 = aClass2.getMethods()) {
                if (!CloneUtils.isClone(method)) continue;
                return;
            }
            this.registerClassError(aClass2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection$CloneableImplementsCloneVisitor", "visitClass"));
        }
    }

    private static class CreateCloneMethodFix
    extends InspectionGadgetsFix {
        private CreateCloneMethodFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("cloneable.class.without.clone.quickfix", new Object[0]);
            if (string == null) {
                CreateCloneMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiClass)) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(project);
            String cloneMethod = "public " + element.getText() + " clone() throws java.lang.CloneNotSupportedException {\nreturn (" + element.getText() + ") super.clone();\n}";
            PsiMethod method = factory2.createMethodFromText(cloneMethod, element);
            parent2.add(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneableImplementsCloneInspection$CreateCloneMethodFix", "getFamilyName"));
        }
    }
}

