/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalCanBePushedInsideExpressionInspection
extends BaseInspection {
    public boolean ignoreSingleArgument = true;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.display.name", new Object[0]);
        if (string == null) {
            ConditionalCanBePushedInsideExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            ConditionalCanBePushedInsideExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.option", new Object[0]), this, "ignoreSingleArgument");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new PushConditionalInsideFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalCanBePushedInsideExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConditionalCanBePushedInsideExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalCanBePushedInsideExpressionVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression = expression2.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression2.getElseExpression();
            EquivalenceChecker.Match match2 = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, elseExpression);
            if (match2.isExactMismatch() || match2.isExactMatch()) {
                return;
            }
            this.registerError((PsiElement)expression2, ConditionalCanBePushedInsideExpressionInspection.this.ignoreSingleArgument && this.isOnlyArgumentOfMethodCall(match2.getLeftDiff(), expression2) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[0]);
        }

        private boolean isOnlyArgumentOfMethodCall(PsiElement element, PsiConditionalExpression conditional) {
            if (element == null) {
                return false;
            }
            PsiElement parent2 = element.getParent();
            if (!(parent2 instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent2;
            if (expressionList.getExpressions().length != 1) {
                return false;
            }
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiElement greatGrandParent = ParenthesesUtils.getParentSkipParentheses(grandParent);
            return greatGrandParent == conditional;
        }
    }

    private static class PushConditionalInsideFix
    extends InspectionGadgetsFix {
        private PushConditionalInsideFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("conditional.can.be.pushed.inside.expression.quickfix", new Object[0]);
            if (string == null) {
                PushConditionalInsideFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)descriptor2.getPsiElement();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            EquivalenceChecker.Match match2 = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsMatch(thenExpression, conditionalExpression.getElseExpression());
            if (!match2.isPartialMatch()) {
                return;
            }
            PsiElement leftDiff = match2.getLeftDiff();
            PsiElement rightDiff = match2.getRightDiff();
            String expression2 = "(" + conditionalExpression.getCondition().getText() + " ? " + leftDiff.getText() + " : " + rightDiff.getText() + ")";
            PsiExpression newConditionalExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(expression2, conditionalExpression);
            PsiElement replacedConditionalExpression = leftDiff.replace(newConditionalExpression);
            ParenthesesUtils.removeParentheses((PsiExpression)replacedConditionalExpression, false);
            conditionalExpression.replace(thenExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConditionalCanBePushedInsideExpressionInspection$PushConditionalInsideFix", "getFamilyName"));
        }
    }
}

