/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class InfiniteLoopStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.display.name", new Object[0]);
        if (string == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            InfiniteLoopStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        private InfiniteLoopStatementsVisitor() {
        }

        @Override
        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement2);
            this.checkStatement(statement2);
        }

        @Override
        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement2);
            this.checkStatement(statement2);
        }

        @Override
        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                InfiniteLoopStatementsVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement2);
            this.checkStatement(statement2);
        }

        private void checkStatement(PsiStatement statement2) {
            if (ControlFlowUtils.statementMayCompleteNormally(statement2)) {
                return;
            }
            if (ControlFlowUtils.containsReturn(statement2)) {
                return;
            }
            if (ControlFlowUtils.containsSystemExit(statement2)) {
                return;
            }
            this.registerStatementError(statement2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/InfiniteLoopStatementInspection$InfiniteLoopStatementsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

