/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopWithImplicitTerminationConditionInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.display.name", new Object[0]);
        if (string == null) {
            LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        if (Boolean.TRUE.equals(infos2[0])) {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.dowhile.problem.descriptor", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            LoopWithImplicitTerminationConditionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new LoopWithImplicitTerminationConditionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopWithImplicitTerminationConditionVisitor();
    }

    static boolean containsUnlabeledBreakStatement(@Nullable PsiStatement statement2) {
        if (!(statement2 instanceof PsiBlockStatement)) {
            return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(statement2);
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(codeBlock);
        return LoopWithImplicitTerminationConditionInspection.isUnlabeledBreakStatement(firstStatement);
    }

    private static boolean isUnlabeledBreakStatement(@Nullable PsiStatement statement2) {
        if (!(statement2 instanceof PsiBreakStatement)) {
            return false;
        }
        PsiBreakStatement breakStatement = (PsiBreakStatement)statement2;
        PsiIdentifier identifier = breakStatement.getLabelIdentifier();
        return identifier == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LoopWithImplicitTerminationConditionVisitor
    extends BaseInspectionVisitor {
        private LoopWithImplicitTerminationConditionVisitor() {
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement2) {
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement2, true)) {
                return;
            }
            this.registerStatementError(statement2, Boolean.FALSE);
        }

        @Override
        public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
            super.visitDoWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement2, false)) {
                return;
            }
            this.registerStatementError(statement2, Boolean.TRUE);
        }

        @Override
        public void visitForStatement(PsiForStatement statement2) {
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (!BoolUtils.isTrue(condition)) {
                return;
            }
            if (LoopWithImplicitTerminationConditionVisitor.isLoopWithImplicitTerminationCondition(statement2, true)) {
                return;
            }
            this.registerStatementError(statement2, Boolean.FALSE);
        }

        private static boolean isLoopWithImplicitTerminationCondition(PsiLoopStatement statement2, boolean firstStatement) {
            PsiStatement bodyStatement;
            PsiStatement body2 = statement2.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return true;
                }
                bodyStatement = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                bodyStatement = body2;
            }
            return !LoopWithImplicitTerminationConditionVisitor.isImplicitTerminationCondition(bodyStatement);
        }

        private static boolean isImplicitTerminationCondition(@Nullable PsiStatement statement2) {
            if (!(statement2 instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                return true;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch);
        }
    }

    private static class LoopWithImplicitTerminationConditionFix
    extends InspectionGadgetsFix {
        private LoopWithImplicitTerminationConditionFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("loop.with.implicit.termination.condition.quickfix", new Object[0]);
            if (string == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiStatement statement2;
            boolean firstStatement;
            PsiStatement body2;
            PsiExpression loopCondition;
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent2 = element.getParent();
            if (parent2 instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)parent2;
                loopCondition = whileStatement.getCondition();
                body2 = whileStatement.getBody();
                firstStatement = true;
            } else if (parent2 instanceof PsiDoWhileStatement) {
                PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)parent2;
                loopCondition = doWhileStatement.getCondition();
                body2 = doWhileStatement.getBody();
                firstStatement = false;
            } else if (parent2 instanceof PsiForStatement) {
                PsiForStatement forStatement = (PsiForStatement)parent2;
                loopCondition = forStatement.getCondition();
                body2 = forStatement.getBody();
                firstStatement = true;
            } else {
                return;
            }
            if (loopCondition == null) {
                return;
            }
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 0) {
                    return;
                }
                statement2 = firstStatement ? statements[0] : statements[statements.length - 1];
            } else {
                statement2 = body2;
            }
            if (!(statement2 instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)statement2;
            PsiExpression ifCondition = ifStatement.getCondition();
            if (ifCondition == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(thenBranch)) {
                String negatedExpressionText = BoolUtils.getNegatedExpressionText(ifCondition);
                PsiReplacementUtil.replaceExpression(loopCondition, negatedExpressionText);
                LoopWithImplicitTerminationConditionFix.replaceStatement(ifStatement, elseBranch);
            } else if (LoopWithImplicitTerminationConditionInspection.containsUnlabeledBreakStatement(elseBranch)) {
                loopCondition.replace(ifCondition);
                if (thenBranch == null) {
                    ifStatement.delete();
                } else {
                    LoopWithImplicitTerminationConditionFix.replaceStatement(ifStatement, thenBranch);
                }
            }
        }

        private static void replaceStatement(@NotNull PsiStatement replacedStatement, @Nullable PsiStatement replacingStatement) throws IncorrectOperationException {
            if (replacedStatement == null) {
                LoopWithImplicitTerminationConditionFix.$$$reportNull$$$0(1);
            }
            if (replacingStatement == null) {
                replacedStatement.delete();
                return;
            }
            if (!(replacingStatement instanceof PsiBlockStatement)) {
                replacedStatement.replace(replacingStatement);
                return;
            }
            PsiBlockStatement blockStatement = (PsiBlockStatement)replacingStatement;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                PsiElement receiver = replacedStatement.getParent();
                for (int i2 = children2.length - 2; i2 > 0; --i2) {
                    PsiElement child = children2[i2];
                    if (child instanceof PsiWhiteSpace) continue;
                    receiver.addAfter(child, replacedStatement);
                }
                replacedStatement.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacedStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/LoopWithImplicitTerminationConditionInspection$LoopWithImplicitTerminationConditionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

