/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NegatedConditionalInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("negated.conditional.display.name", new Object[0]);
        if (string == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("ConditionalExpressionWithNegatedCondition" == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(1);
        }
        return "ConditionalExpressionWithNegatedCondition";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("negated.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalVisitor();
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("negated.conditional.ignore.option", new Object[0]), this, "m_ignoreNegatedNullComparison");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos2) {
        return new NegatedConditionalFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedConditionalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NegatedConditionalVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalVisitor() {
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenBranch = expression2.getThenExpression();
            if (thenBranch == null) {
                return;
            }
            PsiExpression elseBranch = expression2.getElseExpression();
            if (elseBranch == null) {
                return;
            }
            PsiExpression condition = expression2.getCondition();
            if (!ExpressionUtils.isNegation(condition, NegatedConditionalInspection.this.m_ignoreNegatedNullComparison, false)) {
                return;
            }
            this.registerError((PsiElement)condition, new Object[0]);
        }
    }

    private static class NegatedConditionalFix
    extends InspectionGadgetsFix {
        private NegatedConditionalFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.conditional.invert.quickfix", new Object[0]);
            if (string == null) {
                NegatedConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement element = descriptor2.getPsiElement();
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element.getParent();
            assert (conditionalExpression != null);
            PsiExpression elseBranch = conditionalExpression.getElseExpression();
            PsiExpression thenBranch = conditionalExpression.getThenExpression();
            PsiExpression condition = conditionalExpression.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + '?' + elseBranch.getText() + ':' + thenBranch.getText();
            PsiReplacementUtil.replaceExpression(conditionalExpression, newStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NegatedConditionalInspection$NegatedConditionalFix", "getFamilyName"));
        }
    }
}

