/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LawOfDemeterInspection
extends BaseInspection {
    public boolean ignoreLibraryCalls = true;
    private static final Key<Integer> key = Key.create("LawOfDemeterInspection");

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("law.of.demeter.display.name", new Object[0]);
        if (string == null) {
            LawOfDemeterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos2) {
        String string = InspectionGadgetsBundle.message("law.of.demeter.problem.descriptor", new Object[0]);
        if (string == null) {
            LawOfDemeterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("law.of.demeter.ignore.library.calls.option", new Object[0]), this, "ignoreLibraryCalls");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LawOfDemeterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/dataflow/LawOfDemeterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class LawOfDemeterVisitor
    extends BaseInspectionVisitor {
        private static final int threshold = 2;

        private LawOfDemeterVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (LawOfDemeterInspection.this.ignoreLibraryCalls && LibraryUtil.callOnLibraryMethod(expression2)) {
                return;
            }
            expression2.putUserData(key, 1);
            this.checkParents(expression2, 1);
        }

        public void checkParents(PsiExpression expression2, Integer count2) {
            PsiElement parent2 = expression2.getParent();
            if (parent2 instanceof PsiLocalVariable) {
                Integer localCount = (Integer)expression2.getUserData(key);
                parent2.putUserData(key, localCount);
            } else if (parent2 instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent2;
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiLocalVariable)) {
                    return;
                }
                Integer localCount = (Integer)expression2.getUserData(key);
                element.putUserData(key, localCount);
            } else if (parent2 instanceof PsiReferenceExpression) {
                PsiElement grandParent = parent2.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                Integer userData = (Integer)grandParent.getUserData(key);
                if (userData == null) {
                    return;
                }
                int localCount = userData;
                int newCount = localCount + count2;
                if (newCount == 2) {
                    this.registerMethodCallError(methodCallExpression, new Object[0]);
                }
                grandParent.putUserData(key, newCount);
                this.checkParents(methodCallExpression, count2);
            }
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement parent2 = expression2.getParent();
            if (!(parent2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = expression2.resolve();
            if (!(element instanceof PsiLocalVariable)) {
                return;
            }
            Integer count2 = (Integer)element.getUserData(key);
            if (count2 != null) {
                this.checkParents(expression2, count2);
            }
        }
    }
}

